/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.domain;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.ObjectUtils;

public class RowDocument
implements Map<String, Object> {
    private final Map<String, Object> delegate;

    public RowDocument() {
        this.delegate = new LinkedCaseInsensitiveMap();
    }

    public RowDocument(int expectedSize) {
        this.delegate = new LinkedCaseInsensitiveMap(expectedSize);
    }

    public RowDocument(Map<String, ? extends Object> map) {
        this.delegate = new LinkedCaseInsensitiveMap();
        this.delegate.putAll(map);
    }

    public static RowDocument of(String field, @Nullable Object value) {
        return new RowDocument().append(field, value);
    }

    @Nullable
    public List getList(String key) {
        Object item = this.get(key);
        if (item instanceof List || item == null) {
            return (List)item;
        }
        throw new ClassCastException(String.format("Cannot cast element %s be cast to List", item));
    }

    @Nullable
    public Map<String, Object> getMap(String key) {
        Object item = this.get(key);
        if (item instanceof Map || item == null) {
            return (Map)item;
        }
        throw new ClassCastException(String.format("Cannot cast element %s be cast to Map", item));
    }

    public RowDocument getDocument(String key) {
        Object item = this.get(key);
        if (item instanceof RowDocument || item == null) {
            return (RowDocument)item;
        }
        throw new ClassCastException(String.format("Cannot cast element %s be cast to RowDocument", item));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    @Nullable
    public Object put(String key, @Nullable Object value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.delegate.put(key, value);
    }

    public RowDocument append(String key, @Nullable Object value) {
        this.put(key, value);
        return this;
    }

    @Override
    public Object remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowDocument that = (RowDocument)o;
        return ObjectUtils.nullSafeEquals(this.delegate, that.delegate);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.delegate);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Object> action) {
        this.delegate.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
        this.delegate.replaceAll(function);
    }

    @Override
    @Nullable
    public Object putIfAbsent(String key, Object value) {
        return this.delegate.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.delegate.remove(key, value);
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        return this.delegate.replace(key, oldValue, newValue);
    }

    @Override
    @Nullable
    public Object replace(String key, Object value) {
        return this.delegate.replace(key, value);
    }

    @Override
    public Object computeIfAbsent(String key, Function<? super String, ?> mappingFunction) {
        return this.delegate.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return this.delegate.computeIfPresent(key, remappingFunction);
    }

    @Override
    public Object compute(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return this.delegate.compute(key, remappingFunction);
    }

    @Override
    public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.delegate.merge(key, value, remappingFunction);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.delegate.toString();
    }
}

