/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.oceanbase;

import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.oceanbase.OceanBaseJdbcUtils;
import org.testcontainers.utility.DockerImageName;

public class OceanBaseCEContainer
extends JdbcDatabaseContainer<OceanBaseCEContainer> {
    static final String NAME = "oceanbasece";
    static final String DOCKER_IMAGE_NAME = "oceanbase/oceanbase-ce";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"oceanbase/oceanbase-ce");
    private static final Integer SQL_PORT = 2881;
    private static final Integer RPC_PORT = 2882;
    private static final String DEFAULT_TENANT_NAME = "test";
    private static final String DEFAULT_USER = "root";
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_DATABASE_NAME = "test";
    private Mode mode = Mode.SLIM;
    private String tenantName = "test";
    private String password = "";

    public OceanBaseCEContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public OceanBaseCEContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPorts(new int[]{SQL_PORT, RPC_PORT});
        this.setWaitStrategy((WaitStrategy)Wait.forLogMessage((String)".*boot success!.*", (int)1));
    }

    protected void configure() {
        this.addEnv("MODE", this.mode.name().toLowerCase());
        if (!"test".equals(this.tenantName)) {
            if (this.mode == Mode.SLIM) {
                this.logger().warn("The tenant name is not configurable on slim mode, so this option will be ignored.");
                this.tenantName = "test";
            } else {
                this.addEnv("OB_TENANT_NAME", this.tenantName);
            }
        }
        this.addEnv("OB_TENANT_PASSWORD", this.password);
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady((WaitStrategyTarget)this);
    }

    public String getDriverClassName() {
        return OceanBaseJdbcUtils.getDriverClass();
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters("?", "&");
        String prefix = OceanBaseJdbcUtils.isMySQLDriver(this.getDriverClassName()) ? "jdbc:mysql://" : "jdbc:oceanbase://";
        return prefix + this.getHost() + ":" + this.getMappedPort(SQL_PORT) + "/" + "test" + additionalUrlParams;
    }

    public String getDatabaseName() {
        return "test";
    }

    public String getUsername() {
        return "root@" + this.tenantName;
    }

    public String getPassword() {
        return this.password;
    }

    protected String getTestQueryString() {
        return "SELECT 1";
    }

    public OceanBaseCEContainer withMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public OceanBaseCEContainer withTenantName(String tenantName) {
        this.tenantName = tenantName;
        return this;
    }

    public OceanBaseCEContainer withPassword(String password) {
        this.password = password;
        return this;
    }

    public static enum Mode {
        NORMAL,
        MINI,
        SLIM;

    }
}

