/*
 * Decompiled with CFR 0.152.
 */
package org.yeauty.support;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.yeauty.annotation.RequestParam;
import org.yeauty.pojo.PojoEndpointServer;
import org.yeauty.support.MethodArgumentResolver;

public class RequestParamMapMethodArgumentResolver
implements MethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        RequestParam requestParam = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        return requestParam != null && Map.class.isAssignableFrom(parameter.getParameterType()) && !StringUtils.hasText((String)requestParam.name());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, Channel channel, Object object) throws Exception {
        RequestParam ann = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        String name = ann.name();
        if (name.isEmpty() && (name = parameter.getParameterName()) == null) {
            throw new IllegalArgumentException("Name for argument type [" + parameter.getNestedParameterType().getName() + "] not available, and parameter name information not found in class file either.");
        }
        if (!channel.hasAttr(PojoEndpointServer.REQUEST_PARAM)) {
            QueryStringDecoder decoder = new QueryStringDecoder(((FullHttpRequest)object).uri());
            channel.attr(PojoEndpointServer.REQUEST_PARAM).set((Object)decoder.parameters());
        }
        Map requestParams = (Map)channel.attr(PojoEndpointServer.REQUEST_PARAM).get();
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap(requestParams);
        if (MultiValueMap.class.isAssignableFrom(parameter.getParameterType())) {
            return multiValueMap;
        }
        return multiValueMap.toSingleValueMap();
    }
}

