// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/api/v2/ratelimit/ratelimit.proto

package io.envoyproxy.envoy.api.v2.ratelimit;

/**
 * <pre>
 * A RateLimitDescriptor is a list of hierarchical entries that are used by the service to
 * determine the final rate limit key and overall allowed limit. Here are some examples of how
 * they might be used for the domain "envoy".
 * .. code-block:: cpp
 *   ["authenticated": "false"], ["remote_address": "10.0.0.1"]
 * What it does: Limits all unauthenticated traffic for the IP address 10.0.0.1. The
 * configuration supplies a default limit for the *remote_address* key. If there is a desire to
 * raise the limit for 10.0.0.1 or block it entirely it can be specified directly in the
 * configuration.
 * .. code-block:: cpp
 *   ["authenticated": "false"], ["path": "/foo/bar"]
 * What it does: Limits all unauthenticated traffic globally for a specific path (or prefix if
 * configured that way in the service).
 * .. code-block:: cpp
 *   ["authenticated": "false"], ["path": "/foo/bar"], ["remote_address": "10.0.0.1"]
 * What it does: Limits unauthenticated traffic to a specific path for a specific IP address.
 * Like (1) we can raise/block specific IP addresses if we want with an override configuration.
 * .. code-block:: cpp
 *   ["authenticated": "true"], ["client_id": "foo"]
 * What it does: Limits all traffic for an authenticated client "foo"
 * .. code-block:: cpp
 *   ["authenticated": "true"], ["client_id": "foo"], ["path": "/foo/bar"]
 * What it does: Limits traffic to a specific path for an authenticated client "foo"
 * The idea behind the API is that (1)/(2)/(3) and (4)/(5) can be sent in 1 request if desired.
 * This enables building complex application scenarios with a generic backend.
 * </pre>
 *
 * Protobuf type {@code envoy.api.v2.ratelimit.RateLimitDescriptor}
 */
public final class RateLimitDescriptor extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.api.v2.ratelimit.RateLimitDescriptor)
    RateLimitDescriptorOrBuilder {
private static final long serialVersionUID = 0L;
  // Use RateLimitDescriptor.newBuilder() to construct.
  private RateLimitDescriptor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private RateLimitDescriptor() {
    entries_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new RateLimitDescriptor();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.api.v2.ratelimit.RatelimitProto.internal_static_envoy_api_v2_ratelimit_RateLimitDescriptor_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.api.v2.ratelimit.RatelimitProto.internal_static_envoy_api_v2_ratelimit_RateLimitDescriptor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.class, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Builder.class);
  }

  public interface EntryOrBuilder extends
      // @@protoc_insertion_point(interface_extends:envoy.api.v2.ratelimit.RateLimitDescriptor.Entry)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Descriptor key.
     * </pre>
     *
     * <code>string key = 1 [(.validate.rules) = { ... }</code>
     * @return The key.
     */
    java.lang.String getKey();
    /**
     * <pre>
     * Descriptor key.
     * </pre>
     *
     * <code>string key = 1 [(.validate.rules) = { ... }</code>
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString
        getKeyBytes();

    /**
     * <pre>
     * Descriptor value.
     * </pre>
     *
     * <code>string value = 2 [(.validate.rules) = { ... }</code>
     * @return The value.
     */
    java.lang.String getValue();
    /**
     * <pre>
     * Descriptor value.
     * </pre>
     *
     * <code>string value = 2 [(.validate.rules) = { ... }</code>
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString
        getValueBytes();
  }
  /**
   * Protobuf type {@code envoy.api.v2.ratelimit.RateLimitDescriptor.Entry}
   */
  public static final class Entry extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:envoy.api.v2.ratelimit.RateLimitDescriptor.Entry)
      EntryOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Entry.newBuilder() to construct.
    private Entry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Entry() {
      key_ = "";
      value_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Entry();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.api.v2.ratelimit.RatelimitProto.internal_static_envoy_api_v2_ratelimit_RateLimitDescriptor_Entry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.api.v2.ratelimit.RatelimitProto.internal_static_envoy_api_v2_ratelimit_RateLimitDescriptor_Entry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.class, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.Builder.class);
    }

    public static final int KEY_FIELD_NUMBER = 1;
    private volatile java.lang.Object key_;
    /**
     * <pre>
     * Descriptor key.
     * </pre>
     *
     * <code>string key = 1 [(.validate.rules) = { ... }</code>
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Descriptor key.
     * </pre>
     *
     * <code>string key = 1 [(.validate.rules) = { ... }</code>
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private volatile java.lang.Object value_;
    /**
     * <pre>
     * Descriptor value.
     * </pre>
     *
     * <code>string value = 2 [(.validate.rules) = { ... }</code>
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Descriptor value.
     * </pre>
     *
     * <code>string value = 2 [(.validate.rules) = { ... }</code>
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry)) {
        return super.equals(obj);
      }
      io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry other = (io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry) obj;

      if (!getKey()
          .equals(other.getKey())) return false;
      if (!getValue()
          .equals(other.getValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code envoy.api.v2.ratelimit.RateLimitDescriptor.Entry}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:envoy.api.v2.ratelimit.RateLimitDescriptor.Entry)
        io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.EntryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.envoyproxy.envoy.api.v2.ratelimit.RatelimitProto.internal_static_envoy_api_v2_ratelimit_RateLimitDescriptor_Entry_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.envoyproxy.envoy.api.v2.ratelimit.RatelimitProto.internal_static_envoy_api_v2_ratelimit_RateLimitDescriptor_Entry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.class, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.Builder.class);
      }

      // Construct using io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        key_ = "";

        value_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.envoyproxy.envoy.api.v2.ratelimit.RatelimitProto.internal_static_envoy_api_v2_ratelimit_RateLimitDescriptor_Entry_descriptor;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry getDefaultInstanceForType() {
        return io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.getDefaultInstance();
      }

      @java.lang.Override
      public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry build() {
        io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry buildPartial() {
        io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry result = new io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry(this);
        result.key_ = key_;
        result.value_ = value_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry) {
          return mergeFrom((io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry other) {
        if (other == io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.getDefaultInstance()) return this;
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          onChanged();
        }
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                key_ = input.readStringRequireUtf8();

                break;
              } // case 10
              case 18: {
                value_ = input.readStringRequireUtf8();

                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object key_ = "";
      /**
       * <pre>
       * Descriptor key.
       * </pre>
       *
       * <code>string key = 1 [(.validate.rules) = { ... }</code>
       * @return The key.
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Descriptor key.
       * </pre>
       *
       * <code>string key = 1 [(.validate.rules) = { ... }</code>
       * @return The bytes for key.
       */
      public com.google.protobuf.ByteString
          getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Descriptor key.
       * </pre>
       *
       * <code>string key = 1 [(.validate.rules) = { ... }</code>
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        key_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Descriptor key.
       * </pre>
       *
       * <code>string key = 1 [(.validate.rules) = { ... }</code>
       * @return This builder for chaining.
       */
      public Builder clearKey() {
        
        key_ = getDefaultInstance().getKey();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Descriptor key.
       * </pre>
       *
       * <code>string key = 1 [(.validate.rules) = { ... }</code>
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        key_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       * <pre>
       * Descriptor value.
       * </pre>
       *
       * <code>string value = 2 [(.validate.rules) = { ... }</code>
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Descriptor value.
       * </pre>
       *
       * <code>string value = 2 [(.validate.rules) = { ... }</code>
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString
          getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Descriptor value.
       * </pre>
       *
       * <code>string value = 2 [(.validate.rules) = { ... }</code>
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Descriptor value.
       * </pre>
       *
       * <code>string value = 2 [(.validate.rules) = { ... }</code>
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        
        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Descriptor value.
       * </pre>
       *
       * <code>string value = 2 [(.validate.rules) = { ... }</code>
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        value_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:envoy.api.v2.ratelimit.RateLimitDescriptor.Entry)
    }

    // @@protoc_insertion_point(class_scope:envoy.api.v2.ratelimit.RateLimitDescriptor.Entry)
    private static final io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry();
    }

    public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Entry>
        PARSER = new com.google.protobuf.AbstractParser<Entry>() {
      @java.lang.Override
      public Entry parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Entry> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Entry> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public static final int ENTRIES_FIELD_NUMBER = 1;
  private java.util.List<io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry> entries_;
  /**
   * <pre>
   * Descriptor entries.
   * </pre>
   *
   * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public java.util.List<io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry> getEntriesList() {
    return entries_;
  }
  /**
   * <pre>
   * Descriptor entries.
   * </pre>
   *
   * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.EntryOrBuilder> 
      getEntriesOrBuilderList() {
    return entries_;
  }
  /**
   * <pre>
   * Descriptor entries.
   * </pre>
   *
   * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public int getEntriesCount() {
    return entries_.size();
  }
  /**
   * <pre>
   * Descriptor entries.
   * </pre>
   *
   * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry getEntries(int index) {
    return entries_.get(index);
  }
  /**
   * <pre>
   * Descriptor entries.
   * </pre>
   *
   * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.EntryOrBuilder getEntriesOrBuilder(
      int index) {
    return entries_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    for (int i = 0; i < entries_.size(); i++) {
      output.writeMessage(1, entries_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < entries_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, entries_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor other = (io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor) obj;

    if (!getEntriesList()
        .equals(other.getEntriesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getEntriesCount() > 0) {
      hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
      hash = (53 * hash) + getEntriesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A RateLimitDescriptor is a list of hierarchical entries that are used by the service to
   * determine the final rate limit key and overall allowed limit. Here are some examples of how
   * they might be used for the domain "envoy".
   * .. code-block:: cpp
   *   ["authenticated": "false"], ["remote_address": "10.0.0.1"]
   * What it does: Limits all unauthenticated traffic for the IP address 10.0.0.1. The
   * configuration supplies a default limit for the *remote_address* key. If there is a desire to
   * raise the limit for 10.0.0.1 or block it entirely it can be specified directly in the
   * configuration.
   * .. code-block:: cpp
   *   ["authenticated": "false"], ["path": "/foo/bar"]
   * What it does: Limits all unauthenticated traffic globally for a specific path (or prefix if
   * configured that way in the service).
   * .. code-block:: cpp
   *   ["authenticated": "false"], ["path": "/foo/bar"], ["remote_address": "10.0.0.1"]
   * What it does: Limits unauthenticated traffic to a specific path for a specific IP address.
   * Like (1) we can raise/block specific IP addresses if we want with an override configuration.
   * .. code-block:: cpp
   *   ["authenticated": "true"], ["client_id": "foo"]
   * What it does: Limits all traffic for an authenticated client "foo"
   * .. code-block:: cpp
   *   ["authenticated": "true"], ["client_id": "foo"], ["path": "/foo/bar"]
   * What it does: Limits traffic to a specific path for an authenticated client "foo"
   * The idea behind the API is that (1)/(2)/(3) and (4)/(5) can be sent in 1 request if desired.
   * This enables building complex application scenarios with a generic backend.
   * </pre>
   *
   * Protobuf type {@code envoy.api.v2.ratelimit.RateLimitDescriptor}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.api.v2.ratelimit.RateLimitDescriptor)
      io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.api.v2.ratelimit.RatelimitProto.internal_static_envoy_api_v2_ratelimit_RateLimitDescriptor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.api.v2.ratelimit.RatelimitProto.internal_static_envoy_api_v2_ratelimit_RateLimitDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.class, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (entriesBuilder_ == null) {
        entries_ = java.util.Collections.emptyList();
      } else {
        entries_ = null;
        entriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.api.v2.ratelimit.RatelimitProto.internal_static_envoy_api_v2_ratelimit_RateLimitDescriptor_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor getDefaultInstanceForType() {
      return io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor build() {
      io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor buildPartial() {
      io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor result = new io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor(this);
      int from_bitField0_ = bitField0_;
      if (entriesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          entries_ = java.util.Collections.unmodifiableList(entries_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.entries_ = entries_;
      } else {
        result.entries_ = entriesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor) {
        return mergeFrom((io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor other) {
      if (other == io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.getDefaultInstance()) return this;
      if (entriesBuilder_ == null) {
        if (!other.entries_.isEmpty()) {
          if (entries_.isEmpty()) {
            entries_ = other.entries_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureEntriesIsMutable();
            entries_.addAll(other.entries_);
          }
          onChanged();
        }
      } else {
        if (!other.entries_.isEmpty()) {
          if (entriesBuilder_.isEmpty()) {
            entriesBuilder_.dispose();
            entriesBuilder_ = null;
            entries_ = other.entries_;
            bitField0_ = (bitField0_ & ~0x00000001);
            entriesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getEntriesFieldBuilder() : null;
          } else {
            entriesBuilder_.addAllMessages(other.entries_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry m =
                  input.readMessage(
                      io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.parser(),
                      extensionRegistry);
              if (entriesBuilder_ == null) {
                ensureEntriesIsMutable();
                entries_.add(m);
              } else {
                entriesBuilder_.addMessage(m);
              }
              break;
            } // case 10
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.util.List<io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry> entries_ =
      java.util.Collections.emptyList();
    private void ensureEntriesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        entries_ = new java.util.ArrayList<io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry>(entries_);
        bitField0_ |= 0x00000001;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.Builder, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.EntryOrBuilder> entriesBuilder_;

    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public java.util.List<io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry> getEntriesList() {
      if (entriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(entries_);
      } else {
        return entriesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public int getEntriesCount() {
      if (entriesBuilder_ == null) {
        return entries_.size();
      } else {
        return entriesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry getEntries(int index) {
      if (entriesBuilder_ == null) {
        return entries_.get(index);
      } else {
        return entriesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder setEntries(
        int index, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry value) {
      if (entriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntriesIsMutable();
        entries_.set(index, value);
        onChanged();
      } else {
        entriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder setEntries(
        int index, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.Builder builderForValue) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.set(index, builderForValue.build());
        onChanged();
      } else {
        entriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder addEntries(io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry value) {
      if (entriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntriesIsMutable();
        entries_.add(value);
        onChanged();
      } else {
        entriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder addEntries(
        int index, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry value) {
      if (entriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntriesIsMutable();
        entries_.add(index, value);
        onChanged();
      } else {
        entriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder addEntries(
        io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.Builder builderForValue) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.add(builderForValue.build());
        onChanged();
      } else {
        entriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder addEntries(
        int index, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.Builder builderForValue) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.add(index, builderForValue.build());
        onChanged();
      } else {
        entriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder addAllEntries(
        java.lang.Iterable<? extends io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry> values) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, entries_);
        onChanged();
      } else {
        entriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder clearEntries() {
      if (entriesBuilder_ == null) {
        entries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        entriesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder removeEntries(int index) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.remove(index);
        onChanged();
      } else {
        entriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.Builder getEntriesBuilder(
        int index) {
      return getEntriesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.EntryOrBuilder getEntriesOrBuilder(
        int index) {
      if (entriesBuilder_ == null) {
        return entries_.get(index);  } else {
        return entriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.EntryOrBuilder> 
         getEntriesOrBuilderList() {
      if (entriesBuilder_ != null) {
        return entriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(entries_);
      }
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.Builder addEntriesBuilder() {
      return getEntriesFieldBuilder().addBuilder(
          io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.getDefaultInstance());
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.Builder addEntriesBuilder(
        int index) {
      return getEntriesFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.getDefaultInstance());
    }
    /**
     * <pre>
     * Descriptor entries.
     * </pre>
     *
     * <code>repeated .envoy.api.v2.ratelimit.RateLimitDescriptor.Entry entries = 1 [(.validate.rules) = { ... }</code>
     */
    public java.util.List<io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.Builder> 
         getEntriesBuilderList() {
      return getEntriesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.Builder, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.EntryOrBuilder> 
        getEntriesFieldBuilder() {
      if (entriesBuilder_ == null) {
        entriesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.Entry.Builder, io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor.EntryOrBuilder>(
                entries_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        entries_ = null;
      }
      return entriesBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.api.v2.ratelimit.RateLimitDescriptor)
  }

  // @@protoc_insertion_point(class_scope:envoy.api.v2.ratelimit.RateLimitDescriptor)
  private static final io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor();
  }

  public static io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RateLimitDescriptor>
      PARSER = new com.google.protobuf.AbstractParser<RateLimitDescriptor>() {
    @java.lang.Override
    public RateLimitDescriptor parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<RateLimitDescriptor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RateLimitDescriptor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

