/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.envoy.rls.datasource;

import com.alibaba.csp.sentinel.cluster.server.envoy.rls.rule.EnvoyRlsRule;
import com.alibaba.csp.sentinel.cluster.server.envoy.rls.rule.EnvoyRlsRuleManager;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.datasource.FileRefreshableDataSource;
import com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

public class EnvoyRlsRuleDataSourceService {
    private final Yaml yaml = this.createYamlParser();
    private ReadableDataSource<String, List<EnvoyRlsRule>> ds;

    private Yaml createYamlParser() {
        Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(true);
        return new Yaml(representer);
    }

    public synchronized void init() throws Exception {
        if (this.ds != null) {
            return;
        }
        String configPath = this.getRuleConfigPath();
        if (StringUtil.isBlank((String)configPath)) {
            throw new IllegalStateException("Empty rule config path, please set the file path in the env: SENTINEL_RLS_RULE_FILE_PATH");
        }
        this.ds = new FileRefreshableDataSource(configPath, s -> Arrays.asList((EnvoyRlsRule)this.yaml.loadAs(s, EnvoyRlsRule.class)));
        EnvoyRlsRuleManager.register2Property((SentinelProperty<List<EnvoyRlsRule>>)this.ds.getProperty());
    }

    public synchronized void onShutdown() {
        if (this.ds != null) {
            try {
                this.ds.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getRuleConfigPath() {
        return Optional.ofNullable(System.getenv("SENTINEL_RLS_RULE_FILE_PATH")).orElse(SentinelConfig.getConfig((String)"csp.sentinel.rls.rule.file"));
    }
}

