/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.envoy.rls.flow;

import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.flow.statistic.ClusterMetricStatistics;
import com.alibaba.csp.sentinel.cluster.flow.statistic.data.ClusterFlowEvent;
import com.alibaba.csp.sentinel.cluster.flow.statistic.metric.ClusterMetric;
import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.cluster.server.log.ClusterServerStatLogUtil;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;

public final class SimpleClusterFlowChecker {
    public static TokenResult acquireClusterToken(FlowRule rule, int acquireCount) {
        Long id = rule.getClusterConfig().getFlowId();
        ClusterMetric metric = ClusterMetricStatistics.getMetric((long)id);
        if (metric == null) {
            return new TokenResult(Integer.valueOf(-1));
        }
        double latestQps = metric.getAvg(ClusterFlowEvent.PASS);
        double globalThreshold = rule.getCount() * ClusterServerConfigManager.getExceedCount();
        double nextRemaining = globalThreshold - latestQps - (double)acquireCount;
        if (nextRemaining >= 0.0) {
            metric.add(ClusterFlowEvent.PASS, (long)acquireCount);
            metric.add(ClusterFlowEvent.PASS_REQUEST, 1L);
            ClusterServerStatLogUtil.log((String)("flow|pass|" + id), (int)acquireCount);
            ClusterServerStatLogUtil.log((String)("flow|pass_request|" + id), (int)1);
            return new TokenResult(Integer.valueOf(0)).setRemaining((int)nextRemaining).setWaitInMs(0);
        }
        metric.add(ClusterFlowEvent.BLOCK, (long)acquireCount);
        metric.add(ClusterFlowEvent.BLOCK_REQUEST, 1L);
        ClusterServerStatLogUtil.log((String)("flow|block|" + id), (int)acquireCount);
        ClusterServerStatLogUtil.log((String)("flow|block_request|" + id), (int)1);
        return SimpleClusterFlowChecker.blockedResult();
    }

    private static TokenResult blockedResult() {
        return new TokenResult(Integer.valueOf(1)).setRemaining(0).setWaitInMs(0);
    }

    private SimpleClusterFlowChecker() {
    }
}

