/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway;

import com.digiwin.app.module.utils.DWResourceUtils;
import com.digiwin.app.schedule.quartz.DWQuartz;
import com.digiwin.gateway.DWApiGatewayEnvironment;
import com.digiwin.gateway.DWSwitcher;
import com.digiwin.gateway.spring.DWServerSpringResourceReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import javax.annotation.PreDestroy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

@SpringBootApplication(exclude={MongoAutoConfiguration.class, MongoDataAutoConfiguration.class})
@ImportResource(value={"dwweb:dw-server.properties"}, reader=DWServerSpringResourceReader.class)
@EnableCaching
public class DWApiGatewayApplication {
    private static Log log = LogFactory.getLog(DWApiGatewayApplication.class);
    private static List<String> profile = new ArrayList<String>();
    private static ClassLoader classLoader;

    public static void main(String[] args) throws Exception {
        classLoader = DWApiGatewayApplication.class.getClassLoader();
        if (args.length > 0 && args[0].equalsIgnoreCase("dev")) {
            DWApiGatewayApplication.settingDevEnv();
        }
        DWApiGatewayApplication.initQueue();
        DWApiGatewayApplication.initCache();
        DWApiGatewayApplication.initFilter();
        DWApiGatewayApplication.initAppSetting();
        DWApiGatewayApplication.initServerScale();
        DWApiGatewayApplication.initServerSetting();
        DWApiGatewayApplication.initProfile();
        SpringApplication springApplication = new SpringApplication(new Class[]{DWApiGatewayApplication.class});
        springApplication.setEnvironment((ConfigurableEnvironment)new DWApiGatewayEnvironment());
        springApplication.addListeners(new ApplicationListener[]{new ApplicationPidFileWriter("DWApiGatewayApplication.pid")});
        springApplication.run(args);
    }

    private static void initQueue() throws Exception {
        Properties properties = new Properties();
        try (InputStream inputStream = classLoader.getResourceAsStream("dw-queue.properties");){
            if (inputStream == null) {
                return;
            }
            properties.load(inputStream);
            if (properties.isEmpty()) {
                return;
            }
        }
        String queueRoleProfile = properties.getProperty("queue.role", "");
        String isHeartbeat = properties.getProperty("queue.heartbeat", "false");
        if (!StringUtils.isEmpty((Object)queueRoleProfile)) {
            profile.add(queueRoleProfile);
        }
        if (Boolean.valueOf(isHeartbeat).booleanValue()) {
            profile.add("Heartbeat");
        }
    }

    private static void initCache() throws Exception {
        if (!DWSwitcher.isCloseCache()) {
            Properties properties = new Properties();
            try (InputStream inputStream = classLoader.getResourceAsStream("dw-cache.properties");){
                if (inputStream == null) {
                    return;
                }
                properties.load(inputStream);
                if (properties.isEmpty()) {
                    return;
                }
            }
            profile.add("openCache");
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                System.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
        } else {
            System.setProperty("spring.cache.type", "NONE");
        }
    }

    private static void initFilter() throws Exception {
        Properties properties = new Properties();
        try (InputStream inputStream = classLoader.getResourceAsStream("dw-filter.properties");){
            if (inputStream == null) {
                return;
            }
            properties.load(inputStream);
            if (properties.isEmpty()) {
                return;
            }
        }
        String filterProfile = properties.getProperty("filter", "");
        if (!StringUtils.isEmpty((Object)filterProfile)) {
            profile.add(filterProfile);
        }
    }

    private static void initServerScale() throws Exception {
        Properties properties = new Properties();
        try (InputStream inputStream = classLoader.getResourceAsStream("dw-scale.properties");){
            if (inputStream == null) {
                profile.add("lite");
                return;
            }
            properties.load(inputStream);
            if (properties.isEmpty()) {
                profile.add("lite");
                return;
            }
        }
        String scaleProfile = properties.getProperty("scale", "lite");
        profile.add(scaleProfile);
    }

    private static void initServerSetting() throws Exception {
        Properties properties = new Properties();
        try (InputStream inputStream = classLoader.getResourceAsStream("dw-server.properties");){
            if (inputStream == null) {
                profile.add("nio");
                return;
            }
            properties.load(inputStream);
            if (properties.isEmpty()) {
                profile.add("nio");
                return;
            }
        }
        String ioProfile = properties.getProperty("controller.io", "nio");
        String server = properties.getProperty("server", "tomcat");
        DWApiGatewayApplication.setTenantEnv(properties);
        String tokenExpiredTime = properties.getProperty("server.token.expiredTime", "600000");
        System.setProperty("server.token.expiredTime", tokenExpiredTime);
        profile.add(ioProfile);
        profile.add(server);
    }

    private static void initAppSetting() throws Exception {
        System.setProperty("spring.mvc.throw-exception-if-no-handler-found", "true");
        System.setProperty("spring.resources.add-mappings", "false");
        Properties properties = new Properties();
        try (InputStream inputStream = classLoader.getResourceAsStream("bootstrap.properties");){
            if (inputStream == null) {
                System.setProperty("appName", "");
                return;
            }
            properties.load(inputStream);
            if (properties.isEmpty()) {
                System.setProperty("appName", "");
                return;
            }
            String appName = (String)properties.getOrDefault((Object)"spring.application.name", "");
            System.setProperty("appName", appName);
            String appToken = (String)properties.getOrDefault((Object)"iam.apToken", "");
            System.setProperty("appToken", "");
            log.info((Object)("appToken=" + appToken));
        }
    }

    private static void initProfile() throws Exception {
        System.setProperty("spring.profiles.active", String.join((CharSequence)",", profile));
    }

    @PreDestroy
    public void onDestroy() throws Exception {
        DWQuartz.shutdown();
    }

    private static void settingDevEnv() throws IOException {
        String classParentRootURL = DWResourceUtils.getClassRootPathParentFolder().getPath();
        String webInfLocation = Matcher.quoteReplacement("WebContent" + File.separator + "WEB-INF");
        String srcPath = classParentRootURL.replaceAll("target", webInfLocation);
        File srcDir = new File(srcPath);
        File destDir = new File(classParentRootURL);
        FileUtils.copyDirectory((File)srcDir, (File)destDir);
    }

    private static void setTenantEnv(Properties properties) {
        String dwapiTokenMode = properties.getProperty("server.http.tokenmode", "DWApiGateway");
        System.setProperty("server.http.tokenmode", dwapiTokenMode);
        log.info((Object)("dw-server:server.http.tokenmode:" + dwapiTokenMode));
        String dwapiTenantEnable = properties.getProperty("server.tenant", "true");
        System.setProperty("server.tenant", dwapiTenantEnable);
        log.info((Object)("dw-server:server.tenant=" + dwapiTenantEnable));
        String dwapiTenantColumnName = properties.getProperty("server.tenant.columnname", "tenantsid");
        System.setProperty("server.tenant.columnname", dwapiTenantColumnName);
        log.info((Object)("dw-server:server.tenant.columnname=" + dwapiTenantColumnName));
    }
}

