/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.module.utils.DWResourceUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.controller.ServiceInvoker;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.async.DeferredResult;

@RestController
@Profile(value={"nio"})
public class EaiNioController {
    @Autowired
    private ServiceInvoker serviceInvoker;
    @Autowired
    private DWContainerContext containerContext;
    @Autowired
    Environment environment;

    @RequestMapping(method={RequestMethod.POST}, path={"/eai/callback"})
    public DeferredResult<Object> callback() throws Exception {
        HttpServletRequest request = this.getRequest();
        DWHeader header = (DWHeader)request.getAttribute("DWHeader");
        DWMethod method = (DWMethod)request.getAttribute("DWMethod");
        String moduleName = (String)request.getAttribute("moduleName");
        String serviceName = (String)request.getAttribute("serviceName");
        DWDefaultParameters invokeParameters = this.getDWParameters(request);
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        Properties properties = DWResourceUtils.getProperties((String)"dw-eai.properties");
        String digiSrvver = properties.getProperty("eai.host.ver");
        DeferredResult<Object> deferredResult = this.serviceInvoker.eai(digiSrvver, header, method, moduleName, serviceName, (DWParameters)invokeParameters, profile);
        return deferredResult;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/eai"})
    public DeferredResult<Object> eai() throws Exception {
        HttpServletRequest request = this.getRequest();
        DWHeader header = (DWHeader)request.getAttribute("DWHeader");
        DWMethod method = (DWMethod)request.getAttribute("DWMethod");
        String moduleName = (String)request.getAttribute("moduleName");
        String serviceName = (String)request.getAttribute("serviceName");
        DWDefaultParameters invokeParameters = this.getDWParameters(request);
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        Properties properties = DWResourceUtils.getProperties((String)"dw-eai.properties");
        String digiSrvver = properties.getProperty("eai.host.ver");
        DeferredResult<Object> deferredResult = this.serviceInvoker.eai(digiSrvver, header, method, moduleName, serviceName, (DWParameters)invokeParameters, profile);
        return deferredResult;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/eai/syncProd"})
    public Object syncProd() throws Exception {
        HttpServletRequest request = this.getRequest();
        String digiService = request.getHeader("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String name = digiServiceJo.getString("name");
        Map<Object, Object> result = new HashMap();
        HttpServletResponse response = this.getResponse();
        response.addHeader("Content-Type", "application/json; charset=UTF-8");
        switch (name) {
            case "getProdRegInfo": {
                response.addHeader("action", "reg");
                result = this.getProdRegInfo();
                break;
            }
            case "getSrvRegInfo": {
                response.addHeader("action", "reg");
                result = this.getSrvRegInfo();
                break;
            }
            case "doSyncProcess": {
                response.addHeader("digi-srvcode", "000");
                break;
            }
        }
        return result;
    }

    public Map<String, Object> getProdRegInfo() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String ip = this.getIP();
        String port = this.environment.getProperty("local.server.port");
        String offset = this.getTimezoneOffset();
        Properties properties = DWResourceUtils.getProperties((String)"dw-eai.properties");
        String prod = properties.getProperty("eai.host.prod");
        String ver = properties.getProperty("eai.host.ver");
        String id = properties.getProperty("eai.host.id");
        String uid = properties.getProperty("eai.host.uid");
        String retrytimes = properties.getProperty("eai.host.retrytimes", "");
        String retryinterval = properties.getProperty("eai.host.retryinterval", "");
        String concurrence = properties.getProperty("eai.host.concurrence", "");
        HashMap<String, String> host = new HashMap<String, String>();
        host.put("prod", prod);
        host.put("ver", ver);
        host.put("ip", ip);
        host.put("id", id);
        host.put("uid", uid);
        host.put("timezone", offset);
        host.put("restful", "http://" + ip + ":" + port + "/eai");
        if (!StringUtils.isBlank((CharSequence)retrytimes)) {
            host.put("retrytimes", retrytimes);
        }
        if (!StringUtils.isBlank((CharSequence)retryinterval)) {
            host.put("retryinterval", retryinterval);
        }
        if (!StringUtils.isBlank((CharSequence)concurrence)) {
            host.put("concurrence", concurrence);
        }
        result.put("host", host);
        return result;
    }

    public Map<String, Object> getSrvRegInfo() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String ip = this.getIP();
        Properties properties = DWResourceUtils.getProperties((String)"dw-eai.properties");
        String prod = properties.getProperty("eai.host.prod");
        String ver = properties.getProperty("eai.host.ver");
        String id = properties.getProperty("eai.host.id");
        String uid = properties.getProperty("eai.host.uid");
        HashMap<String, String> host = new HashMap<String, String>();
        host.put("prod", prod);
        host.put("ver", ver);
        host.put("ip", ip);
        host.put("id", id);
        host.put("uid", uid);
        HashMap<String, List> service = new HashMap<String, List>();
        List srvname = this.containerContext.getEaiServiceList();
        service.put("srvname", srvname);
        result.put("service", service);
        result.put("host", host);
        return result;
    }

    private HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        return request;
    }

    private DWDefaultParameters getDWParameters(HttpServletRequest request) throws Exception {
        JSONObject headerJo = new JSONObject();
        Enumeration headerNames = request.getHeaderNames();
        for (String headerName : Collections.list(headerNames)) {
            if (!headerName.startsWith("digi-")) continue;
            if ("digi-message".equalsIgnoreCase(headerName)) {
                headerJo.put(headerName, (Object)new String(Base64.getDecoder().decode(request.getHeader(headerName)), StandardCharsets.UTF_8));
                continue;
            }
            headerJo.put(headerName, (Object)request.getHeader(headerName));
        }
        String body = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        JSONObject invokeParameterJo = new JSONObject();
        invokeParameterJo.put("headers", (Object)headerJo);
        invokeParameterJo.put("messageBody", (Object)body);
        DWDefaultParameters invokeParameters = new DWDefaultParameters(invokeParameterJo.toMap());
        return invokeParameters;
    }

    private HttpServletResponse getResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = ((ServletRequestAttributes)requestAttributes).getResponse();
        return response;
    }

    private String getTimezoneOffset() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = GregorianCalendar.getInstance(timeZone);
        int offsetInMillis = timeZone.getOffset(calendar.getTimeInMillis());
        String offset = String.format("%d", Math.abs(offsetInMillis / 3600000));
        offset = (offsetInMillis >= 0 ? "+" : "-") + offset;
        return offset;
    }

    private String getIP() throws Exception {
        String defaultIp = InetAddress.getLocalHost().getHostAddress();
        Properties properties = DWResourceUtils.getProperties((String)"dw-eai.properties");
        String ip = properties.getProperty("eai.host.ip", defaultIp);
        return ip;
    }
}

