/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.server;

import java.io.InputStream;
import java.util.Properties;
import org.apache.catalina.connector.Connector;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;

public class DWTomcat
extends TomcatServletWebServerFactory {
    private static final String DEFAULT_PORT = "8085";
    private static final String ACCEPT_COUNT = "100";
    private static final String MAX_CONNECTIONS = "10000";
    private static final String MIN_SPARE_THREADS = "10";
    private static final String MAX_THREADS = "200";

    public DWTomcat() {
        this.initialize();
    }

    private void initialize() {
        super.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new DWTomcatConnectorCustomizer()});
    }

    private class DWTomcatConnectorCustomizer
    implements TomcatConnectorCustomizer {
        private DWTomcatConnectorCustomizer() {
        }

        public void customize(Connector connector) {
            Properties properties = new Properties();
            ClassLoader classLoader = DWTomcat.class.getClassLoader();
            try (InputStream inputStream = classLoader.getResourceAsStream("dw-server.properties");){
                if (inputStream == null) {
                    connector.setPort(Integer.valueOf(DWTomcat.DEFAULT_PORT).intValue());
                    return;
                }
                properties.load(inputStream);
                if (properties.isEmpty()) {
                    connector.setPort(Integer.valueOf(DWTomcat.DEFAULT_PORT).intValue());
                    return;
                }
                String port = properties.getProperty("server.port", DWTomcat.DEFAULT_PORT);
                String acceptCount = properties.getProperty("server.tomcat.acceptCount", DWTomcat.ACCEPT_COUNT);
                String maxConnections = properties.getProperty("server.tomcat.maxConnections", DWTomcat.MAX_CONNECTIONS);
                String minSpareThreads = properties.getProperty("server.tomcat.minSpareThreads", DWTomcat.MIN_SPARE_THREADS);
                String maxThreads = properties.getProperty("server.tomcat.maxThreads", DWTomcat.MAX_THREADS);
                connector.setPort(Integer.valueOf(port).intValue());
                connector.setAttribute("acceptCount", (Object)acceptCount);
                connector.setAttribute("maxConnections", (Object)maxConnections);
                connector.setAttribute("minSpareThreads", (Object)minSpareThreads);
                connector.setAttribute("maxThreads", (Object)maxThreads);
            }
            catch (Exception e) {
                connector.setPort(Integer.valueOf(DWTomcat.DEFAULT_PORT).intValue());
                e.printStackTrace();
            }
        }
    }
}

