/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.server;

import java.io.InputStream;
import java.util.Properties;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;

public class DWUndertow
extends UndertowServletWebServerFactory {
    private static final String DEFAULT_PORT = "8085";

    public DWUndertow() {
        this.initialize();
    }

    private void initialize() {
        Properties properties = new Properties();
        ClassLoader classLoader = DWUndertow.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream("dw-server.properties");){
            if (inputStream == null) {
                super.setPort(Integer.valueOf(DEFAULT_PORT).intValue());
                return;
            }
            properties.load(inputStream);
            if (properties.isEmpty()) {
                super.setPort(Integer.valueOf(DEFAULT_PORT).intValue());
                return;
            }
            String port = properties.getProperty("server.port", DEFAULT_PORT);
            int defaultIoThreads = Math.max(Runtime.getRuntime().availableProcessors(), 2);
            int defaultWorkerThreads = defaultIoThreads * 8;
            String ioThreads = properties.getProperty("server.undertow.io-threads", String.valueOf(defaultIoThreads));
            String workerThreads = properties.getProperty("server.undertow.worker-threads", String.valueOf(defaultWorkerThreads));
            super.setPort(Integer.valueOf(port).intValue());
            super.setIoThreads(Integer.valueOf(ioThreads));
            super.setWorkerThreads(Integer.valueOf(workerThreads));
        }
        catch (Exception e) {
            super.setPort(Integer.valueOf(DEFAULT_PORT).intValue());
            e.printStackTrace();
        }
    }
}

