/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.spring;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DWServerSpringResourceReader
extends XmlBeanDefinitionReader {
    private static Log log = LogFactory.getLog(DWServerSpringResourceReader.class);
    public static final String DW_WEBPATH_URL_PREFIX = "dwweb:";
    public static final String ARGUMENT_SPRING_CONFIG_FILE_NAME = "springconfigfilename";
    private DWResourcePatternResolver dwResourceLoader = new DWResourcePatternResolver();

    public DWServerSpringResourceReader(BeanDefinitionRegistry registry) {
        super(registry);
    }

    public ResourceLoader getResourceLoader() {
        return this.dwResourceLoader;
    }

    public class DWResourcePatternResolver
    extends PathMatchingResourcePatternResolver {
        public Resource[] getResources(String locationPattern) throws IOException {
            if (locationPattern.startsWith(DWServerSpringResourceReader.DW_WEBPATH_URL_PREFIX)) {
                String resourceName = locationPattern.split(DWServerSpringResourceReader.DW_WEBPATH_URL_PREFIX)[1];
                Properties properties = new Properties();
                try (InputStream inputStream = this.getClassLoader().getResourceAsStream(resourceName);){
                    if (inputStream == null) {
                        throw new IOException(locationPattern + " not found!");
                    }
                    properties.load(inputStream);
                }
                String[] springConfigs = this.getServerSpringConfigs(properties);
                ArrayList<Resource> resources = new ArrayList<Resource>();
                for (String config : springConfigs) {
                    Resource[] rsList = super.getResources(config);
                    resources.addAll(Arrays.asList(rsList));
                }
                Resource[] rsArray = new Resource[resources.size()];
                rsArray = resources.toArray(rsArray);
                return rsArray;
            }
            return super.getResources(locationPattern);
        }

        private String[] getServerSpringConfigs(Properties properties) {
            String springConfigFileName = properties.getProperty(DWServerSpringResourceReader.ARGUMENT_SPRING_CONFIG_FILE_NAME);
            if (springConfigFileName == null || springConfigFileName.isEmpty()) {
                return new String[0];
            }
            String[] springConfigFileNames = springConfigFileName.split(",");
            String[] configArray = new String[springConfigFileNames.length];
            for (int i = 0; i < springConfigFileNames.length; ++i) {
                String eachConfigFileName = springConfigFileNames[i];
                log.info((Object)("> " + i + ". Spring config: " + eachConfigFileName + "."));
            }
            return springConfigFileNames;
        }
    }
}

