/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.queue;

import com.digiwin.processor.enums.KeyStoreEnum;
import com.digiwin.queue.exceptions.MqConnectFailException;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Client {
    private static final Log log = LogFactory.getLog(Client.class);
    protected static final int DEFAULT_AMQP_PORT = 5672;
    protected static final int DEFAULT_PROTOCOL_PORT = 15672;
    protected static final int DEFAULT_RETRY_TIMES = 3;
    protected static final long DEFAULT_RETRY_INTERVAL = 5000L;
    protected String mqHost;
    protected Integer amqpPort;
    protected Integer amqpSslPort;
    protected String mqUserName;
    protected String mqPassword;
    protected boolean useSsl = false;
    protected static final String VHOST_NAMESPACE = "_vhost";
    private Timer heartbeat;
    private boolean heartbeatRunning = false;
    public int retryTimes;
    public long retryInterval;
    private final Map<String, ConnectionFactory> CONNECTION_FACTORY_MAP = new HashMap<String, ConnectionFactory>();

    public String getMqHost() {
        return this.mqHost;
    }

    public String getMqUserName() {
        return this.mqUserName;
    }

    public String getMqPassword() {
        return this.mqPassword;
    }

    protected void setProp(String mqHost, Integer amqpPort, Integer amqpSslPort, String mqUserName, String mqPassword) {
        this.mqHost = mqHost;
        this.amqpPort = amqpPort;
        this.amqpSslPort = amqpSslPort;
        this.mqUserName = mqUserName;
        this.mqPassword = mqPassword;
    }

    public void openSSL() {
        this.useSsl = true;
    }

    public void openSSL(KeyStoreEnum keyStore) {
        this.useSsl = true;
    }

    protected Connection getConnection(String vhost) throws MqConnectFailException {
        ConnectionFactory tFactory = this.CONNECTION_FACTORY_MAP.get(vhost);
        if (tFactory == null) {
            tFactory = new ConnectionFactory();
            tFactory.setHost(this.mqHost);
            Integer tPort = null;
            tPort = this.useSsl ? this.amqpSslPort : this.amqpPort;
            if (tPort != null) {
                tFactory.setPort(tPort.intValue());
            }
            tFactory.setVirtualHost(vhost);
            tFactory.setUsername(this.mqUserName);
            tFactory.setPassword(this.mqPassword);
            tFactory.setAutomaticRecoveryEnabled(false);
            tFactory.setTopologyRecoveryEnabled(false);
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            InputStream keyStoreStream = null;
            char[] tPwd = "28682266".toCharArray();
            if (this.useSsl) {
                keyStoreStream = classloader.getResourceAsStream("mqSSL/store");
                try {
                    KeyStore jks = KeyStore.getInstance("JKS");
                    jks.load(keyStoreStream, tPwd);
                    TrustManagerFactory keyStoreManager = TrustManagerFactory.getInstance("SunX509");
                    keyStoreManager.init(jks);
                    SSLContext context = SSLContext.getInstance("TLSv1.2");
                    context.init(null, keyStoreManager.getTrustManagers(), null);
                    tFactory.useSslProtocol(context);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new MqConnectFailException(String.format("SSL error occurred: %s:%s,vhost: %s", tFactory.getHost(), tFactory.getPort(), tFactory.getVirtualHost()), e);
                }
            }
            this.CONNECTION_FACTORY_MAP.put(vhost, tFactory);
        }
        Connection tConnection = null;
        int tCount = 0;
        while (true) {
            try {
                tConnection = tFactory.newConnection();
                log.info((Object)String.format("Successful connection to MQ server: %s:%s,vhost: %s", tFactory.getHost(), tFactory.getPort(), tFactory.getVirtualHost()));
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
                if (++tCount == this.retryTimes) {
                    throw new MqConnectFailException(String.format("Unable to connect to MQ server: %s:%s,vhost: %s", tFactory.getHost(), tFactory.getPort(), tFactory.getVirtualHost()) + ", " + e.getMessage(), e);
                }
                log.warn((Object)("Connect to MQ server failed, retry after " + this.retryInterval + " millisecond."));
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException e1) {
                    log.debug((Object)e1.getMessage(), (Throwable)e1);
                }
                continue;
            }
            break;
        }
        return tConnection;
    }

    public abstract void close();

    public void enableHeartbeat() {
        if (!this.heartbeatRunning) {
            this.heartbeat = new Timer();
            this.heartbeat.schedule(new TimerTask(){

                @Override
                public void run() {
                    Client.this.doHeartbeat();
                }
            }, 0L, TimeUnit.SECONDS.toMillis(10L));
            this.heartbeatRunning = true;
        }
    }

    public void disableHeartbeat() {
        if (this.heartbeatRunning) {
            try {
                this.heartbeat.cancel();
                this.heartbeatRunning = false;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected abstract void doHeartbeat();
}

