/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.queue.tenant;

import com.digiwin.app.queue.DWQueueReceiver;
import com.digiwin.processor.enums.HttpMethod;
import com.digiwin.processor.polling.CircuitBreaker;
import com.digiwin.queue.Client;
import com.digiwin.queue.HttpUtil;
import com.digiwin.queue.RabbitmqTopicSupporter;
import com.digiwin.queue.TokenUtil;
import com.digiwin.queue.exceptions.MqConnectFailException;
import com.digiwin.queue.tenant.TenantClientImpl;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public abstract class TenantClient
extends Client {
    private static final Log log = LogFactory.getLog(TenantClient.class);
    protected static final String END = "DWQueue-tenant";
    protected static ExecutorService executorService = Executors.newCachedThreadPool();
    protected Connection tenantConnecion;
    protected Connection saasConnection;
    protected static boolean standby = false;
    protected static CircuitBreaker tenantCircuitBreaker = CircuitBreaker.CLOSED;
    protected static ExecutorService circuitBreakerPollingExecutorService = Executors.newSingleThreadExecutor();
    protected ExecutorService messagePollingExecutorService = Executors.newSingleThreadExecutor();
    protected String tenantId;
    protected String gatewayId;
    protected String gatewayName;
    protected String apName;
    protected DWQueueReceiver receiver;

    public static TenantClient init(String processorHost) {
        return TenantClient.init(processorHost, 3, 5000L, false);
    }

    public static TenantClient init(String processorHost, boolean standby) {
        return TenantClient.init(processorHost, 3, 5000L, standby);
    }

    public static TenantClient init(String processorHost, Integer retryTimes, Long retryInterval) {
        return TenantClient.init(processorHost, retryTimes, retryInterval, false);
    }

    public static TenantClient init(String processorHost, Integer retryTimes, Long retryInterval, boolean standby) {
        TenantClientImpl instance = new TenantClientImpl();
        instance.retryTimes = retryTimes;
        instance.retryInterval = retryInterval;
        TenantClient.setProcessorUrl((String)processorHost);
        TenantClient.setStandby(standby);
        TenantClient.tenantCircuitBreakerPolling();
        return instance;
    }

    protected static void setStandby(boolean standby) {
        TenantClient.standby = standby;
    }

    public abstract String onRegister(String var1, String var2, String var3, DWQueueReceiver var4);

    @Deprecated
    public abstract String onRegisterV01(String var1, String var2, String var3, String var4);

    @Deprecated
    public abstract String onReRegisterV01(String var1, String var2, String var3);

    @Deprecated
    public abstract void onTopicV01(String var1, String var2, String var3, String var4, DWQueueReceiver var5) throws Exception;

    public abstract String sendToSaas(String var1, String var2, String var3, String var4, Long var5) throws MqConnectFailException, TimeoutException, Exception;

    public void close() {
        this.disableHeartbeat();
        try {
            if (this.tenantConnecion != null) {
                this.tenantConnecion.abort();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (this.saasConnection != null) {
                this.saasConnection.abort();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected static void tenantCircuitBreakerPolling() {
        if (!standby) {
            return;
        }
        Runnable circuitBreakerPollingTask = new Runnable(){

            @Override
            public void run() {
                block13: while (true) {
                    try {
                        while (true) {
                            String token = TokenUtil.get();
                            String encodeToken = URLEncoder.encode(token, StandardCharsets.UTF_8.toString());
                            String url = processorUrl + "api/polling/circuitbreaker?status=" + tenantCircuitBreaker.value() + "&token=" + encodeToken;
                            RequestConfig defaultRequestConfig = RequestConfig.custom().build();
                            try {
                                CloseableHttpResponse response = HttpUtil.executHttpRequest((RequestConfig)defaultRequestConfig, (String)url, (HttpMethod)HttpMethod.GET);
                                Throwable throwable = null;
                                try {
                                    int statusCode = response.getStatusLine().getStatusCode();
                                    if (statusCode == 204) continue block13;
                                    if (statusCode == 200) {
                                        Type type;
                                        Gson gson = new Gson();
                                        HttpEntity httpEntity = response.getEntity();
                                        String responseString = EntityUtils.toString((HttpEntity)httpEntity);
                                        Map map = (Map)gson.fromJson(responseString, type = new TypeToken<Map<String, String>>(){}.getType());
                                        String circuitBreakerString = (String)map.get("circuitBreaker");
                                        CircuitBreaker circuitBreaker = CircuitBreaker.fromString((String)circuitBreakerString);
                                        if (tenantCircuitBreaker.equals((Object)circuitBreaker)) continue block13;
                                        log.warn((Object)("[circuitBreakerPolling] " + tenantCircuitBreaker + " -> " + circuitBreaker));
                                        tenantCircuitBreaker = circuitBreaker;
                                        continue block13;
                                    }
                                    log.warn((Object)("[circuitBreakerPolling] Unexpected status code: " + statusCode));
                                    continue block13;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (response == null) continue block13;
                                    if (throwable != null) {
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue block13;
                                    }
                                    response.close();
                                    continue block13;
                                }
                            }
                            catch (Exception e) {
                                log.error((Object)("[circuitBreakerPolling] message: " + e.getMessage()), (Throwable)e);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("[circuitBreakerPolling] message: " + e.getMessage()), (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        };
        if (circuitBreakerPollingExecutorService == null) {
            circuitBreakerPollingExecutorService = Executors.newSingleThreadExecutor();
        }
        circuitBreakerPollingExecutorService.execute(circuitBreakerPollingTask);
    }

    protected void messagePolling() {
        if (!standby) {
            return;
        }
        Runnable messagePollingTask = new Runnable(){

            @Override
            public void run() {
                while (!CircuitBreaker.CLOSED.equals((Object)tenantCircuitBreaker)) {
                    try {
                        String token = TokenUtil.get();
                        String encodeToken = URLEncoder.encode(token, StandardCharsets.UTF_8.toString());
                        RabbitmqTopicSupporter topicSupporter = new RabbitmqTopicSupporter(TenantClient.this.tenantId, TenantClient.this.gatewayId, TenantClient.this.gatewayName, TenantClient.this.apName);
                        String publishKey = topicSupporter.getPublishKey();
                        String messagePollingUrl = processorUrl + "api/polling/message?publishKey=" + publishKey + "&token=" + encodeToken + "&tenantId=" + TenantClient.this.tenantId;
                        RequestConfig defaultRequestConfig = RequestConfig.custom().build();
                        try {
                            CloseableHttpResponse messagePollingResponse = HttpUtil.executHttpRequest((RequestConfig)defaultRequestConfig, (String)messagePollingUrl, (HttpMethod)HttpMethod.GET);
                            Throwable throwable = null;
                            try {
                                int statusCode = messagePollingResponse.getStatusLine().getStatusCode();
                                Gson gson = new Gson();
                                if (statusCode == 204) continue;
                                if (statusCode == 200) {
                                    HttpEntity httpEntity = messagePollingResponse.getEntity();
                                    String messageString = EntityUtils.toString((HttpEntity)httpEntity);
                                    Type type = new TypeToken<Map<String, String>>(){}.getType();
                                    Map messageMap = (Map)gson.fromJson(messageString, type);
                                    String uuid = (String)messageMap.get("uuid");
                                    final String message = (String)messageMap.get("message");
                                    ExecutorService messagePollingExecutorService = Executors.newSingleThreadExecutor();
                                    Callable<String> task = new Callable<String>(){

                                        @Override
                                        public String call() throws Exception {
                                            String result = TenantClient.this.receiver.execute(message);
                                            result = Objects.toString(result, "");
                                            return result;
                                        }
                                    };
                                    Future<String> future = messagePollingExecutorService.submit(task);
                                    messagePollingExecutorService.shutdown();
                                    String result = future.get();
                                    String responseUrl = processorUrl + "api/standby/response";
                                    String responseToken = TokenUtil.get();
                                    HashMap<String, String> response = new HashMap<String, String>();
                                    response.put("tenantId", TenantClient.this.tenantId);
                                    response.put("uuid", uuid);
                                    response.put("response", result);
                                    response.put("token", responseToken);
                                    String responseString = gson.toJson(response);
                                    HttpUtil.executHttpRequest((String)responseUrl, (HttpMethod)HttpMethod.POST, (String)responseString);
                                    continue;
                                }
                                log.info((Object)("[messagePolling] Unexpected status code: " + statusCode));
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (messagePollingResponse == null) continue;
                                if (throwable != null) {
                                    try {
                                        messagePollingResponse.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                messagePollingResponse.close();
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)("[messagePolling] message: " + e.getMessage()), (Throwable)e);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("[messagePolling] message: " + e.getMessage()), (Throwable)e);
                        continue;
                    }
                    break;
                }
                return;
            }
        };
        if (this.messagePollingExecutorService == null) {
            this.messagePollingExecutorService = Executors.newSingleThreadExecutor();
        }
        this.messagePollingExecutorService.execute(messagePollingTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishMessageToSaas(Connection connection, RabbitmqTopicSupporter topicSupporter, AMQP.BasicProperties props, String message) throws Exception {
        int count = 0;
        while (true) {
            Channel tChannel = null;
            try {
                tChannel = connection.createChannel();
                tChannel.confirmSelect();
                tChannel.basicPublish(topicSupporter.getExchangeName(), topicSupporter.getPublishKey(), props, message.getBytes("UTF-8"));
                tChannel.waitForConfirmsOrDie();
            }
            catch (Exception e) {
                if (++count == this.retryTimes) {
                    throw e;
                }
                log.warn((Object)"Publish message failed,retry");
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException e1) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            finally {
                if (tChannel == null) continue;
                try {
                    tChannel.abort();
                }
                catch (IOException e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            break;
        }
    }
}

