/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.queue.tenant;

import com.digiwin.app.queue.DWQueueReceiver;
import com.digiwin.queue.Client;
import com.digiwin.queue.RabbitmqTopicSupporter;
import com.digiwin.queue.exceptions.MqConnectFailException;
import com.digiwin.queue.tenant.TenantClientImpl;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TenantClient
extends Client {
    private static final Logger log = LoggerFactory.getLogger(TenantClient.class);
    protected static final String URL_REGEX = "https?:.+";
    protected static final String PROCESSOR_PORT = "8080";
    protected static final Pattern IP = Pattern.compile("^((([0-9]{1,3}\\.){3})[0-9]{1,3})$");
    protected static ExecutorService executorService = Executors.newCachedThreadPool();
    protected String processorUrl;
    protected Connection tenantConnecion;
    protected Connection saasConnection;

    public static TenantClient init(String processorHost) {
        return TenantClient.init(processorHost, 3, 5000L);
    }

    public static TenantClient init(String processorHost, Integer retryTimes, Long retryInterval) {
        TenantClientImpl instance = new TenantClientImpl();
        instance.retryTimes = retryTimes;
        instance.retryInterval = retryInterval;
        log.info("MQ Processor host = " + processorHost);
        if (processorHost.matches(URL_REGEX)) {
            instance.processorUrl = processorHost.endsWith("/") ? processorHost : processorHost + "/";
        } else {
            if (TenantClient.isIpPattern(processorHost)) {
                processorHost = processorHost + ":8080";
            }
            instance.processorUrl = "http://" + processorHost + "/";
        }
        return instance;
    }

    public abstract String onRegister(String var1, String var2, String var3, DWQueueReceiver var4);

    @Deprecated
    public abstract String onRegisterV01(String var1, String var2, String var3, String var4);

    @Deprecated
    public abstract String onReRegisterV01(String var1, String var2, String var3);

    @Deprecated
    public abstract void onTopicV01(String var1, String var2, String var3, String var4, DWQueueReceiver var5) throws Exception;

    public abstract String sendToSaas(String var1, String var2, String var3, String var4, Long var5) throws MqConnectFailException, TimeoutException, Exception;

    public void close() {
        this.disableHeartbeat();
        try {
            if (this.tenantConnecion != null) {
                this.tenantConnecion.close();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.saasConnection != null) {
                this.saasConnection.close();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isIpPattern(String host) {
        return IP.matcher(host).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishMessageToSaas(Connection connection, RabbitmqTopicSupporter topicSupporter, AMQP.BasicProperties props, String message) throws Exception {
        int count = 0;
        while (true) {
            Channel tChannel = null;
            try {
                tChannel = connection.createChannel();
                tChannel.confirmSelect();
                tChannel.basicPublish(topicSupporter.getExchangeName(), topicSupporter.getPublishKey(), props, message.getBytes("UTF-8"));
                tChannel.waitForConfirmsOrDie();
            }
            catch (Exception e) {
                if (++count == this.retryTimes) {
                    throw e;
                }
                log.warn("Publish message failed,retry");
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException e1) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            finally {
                if (tChannel == null) continue;
                try {
                    tChannel.close();
                }
                catch (Exception e) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            break;
        }
    }
}

