/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.queue;

import com.digiwin.app.queue.DWQueueApplicationContextProvider;
import com.digiwin.app.queue.DWQueueConsumer;
import com.digiwin.app.queue.DWQueueSaasProducer;
import com.digiwin.app.queue.DWQueueTenantProducer;
import com.digiwin.app.queue.DWQueueTopicManager;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqChannel;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqClientHolder;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqConsumer;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqQueueDeclarer;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqSaasProducer;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqTenantProducer;
import com.digiwin.app.queue.rabbitmq.Heartbeat;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.rabbitmq.client.ConnectionFactory;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"Saas", "Tenant"})
public class DWQueueConfiguration {
    private static final Pattern IP = Pattern.compile("^((([0-9]{1,3}\\.){3})[0-9]{1,3})$");

    private static boolean isIpPattern(String host) {
        return IP.matcher(host).matches();
    }

    @Bean
    public Void serverSetting() throws Exception {
        ClassLoader classLoader = DWQueueConfiguration.class.getClassLoader();
        Properties properties = new Properties();
        try (InputStream inputStream = classLoader.getResourceAsStream("dw-queue.properties");){
            properties.load(inputStream);
        }
        String serviceUrl = properties.getProperty("queue.dmc.serviceUrl");
        if (StringUtils.isBlank((CharSequence)serviceUrl)) {
            return null;
        }
        String adminName = properties.getProperty("queue.dmc.adminName");
        String adminPwd = properties.getProperty("queue.dmc.adminPwd");
        String name = properties.getProperty("queue.dmc.name");
        String pwd = properties.getProperty("queue.dmc.pwd");
        String bucketName = properties.getProperty("queue.dmc.bucketName");
        ServerSetting.setServiceUrl((String)serviceUrl);
        ServerSetting.setIdentityAdminName((String)adminName);
        ServerSetting.setIdentityAdminPwd((String)adminPwd);
        ServerSetting.setIdentityName((String)name);
        ServerSetting.setIdentityPwd((String)pwd);
        ServerSetting.setBucketName((String)bucketName);
        ServerSetting.initialize();
        return null;
    }

    @Bean
    @Profile(value={"Saas"})
    public DWQueueApplicationContextProvider publicCloudApplicationContextProvider() {
        return new DWQueueApplicationContextProvider("Saas");
    }

    @Bean
    @Profile(value={"Tenant"})
    public DWQueueApplicationContextProvider privateCloudApplicationContextProvider() {
        return new DWQueueApplicationContextProvider("Tenant");
    }

    @Bean
    public ConnectionFactory connectionFactory() throws Exception {
        ClassLoader classLoader = DWQueueConfiguration.class.getClassLoader();
        Properties properties = new Properties();
        try (InputStream inputStream = classLoader.getResourceAsStream("dw-queue.properties");){
            properties.load(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        String host = properties.getProperty("queue.rabbitmq.host", "");
        String username = properties.getProperty("queue.rabbitmq.username", "");
        String password = properties.getProperty("queue.rabbitmq.password", "");
        int handshakeTimeout = Integer.valueOf(properties.getProperty("queue.rabbitmq.handshakeTimeout", "10"));
        int tcpConnectionTimeout = Integer.valueOf(properties.getProperty("queue.rabbitmq.tcpConnectionTimeout", "60"));
        int heartbeat = Integer.valueOf(properties.getProperty("queue.rabbitmq.heartbeat", "60"));
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(host);
        factory.setUsername(username);
        factory.setPassword(password);
        factory.setAutomaticRecoveryEnabled(true);
        factory.setTopologyRecoveryEnabled(true);
        factory.setNetworkRecoveryInterval(10000);
        factory.setHandshakeTimeout(handshakeTimeout * 1000);
        factory.setConnectionTimeout(tcpConnectionTimeout * 1000);
        factory.setRequestedHeartbeat(heartbeat);
        return factory;
    }

    @Bean(name={"QueueDeclarer"})
    public DWRabbitmqQueueDeclarer queueDeclarer() {
        return new DWRabbitmqQueueDeclarer();
    }

    @Bean
    public DWRabbitmqChannel rabbitmqChannel() {
        return new DWRabbitmqChannel();
    }

    @Bean
    public DWQueueConsumer queueConsumer() {
        return new DWRabbitmqConsumer();
    }

    @Bean(name={"TopicManager"})
    public DWQueueTopicManager topicManager() {
        return new DWQueueTopicManager();
    }

    @Bean
    public DWRabbitmqClientHolder clientHolder() throws Exception {
        ClassLoader classLoader = DWQueueConfiguration.class.getClassLoader();
        Properties properties = new Properties();
        try (InputStream inputStream = classLoader.getResourceAsStream("dw-queue.properties");){
            properties.load(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        String host = properties.getProperty("queue.rabbitmq.host", "");
        if (DWQueueConfiguration.isIpPattern(host)) {
            host = host + ":15672";
        }
        String url = "http://" + host + "/api/consumers";
        String username = properties.getProperty("queue.rabbitmq.username", "");
        String password = properties.getProperty("queue.rabbitmq.password", "");
        return new DWRabbitmqClientHolder(url, username, password);
    }

    @Bean
    @Profile(value={"Heartbeat"})
    @DependsOn(value={"QueueDeclarer"})
    public Heartbeat heartbeat() throws Exception {
        ClassLoader classLoader = DWQueueConfiguration.class.getClassLoader();
        Properties properties = new Properties();
        try (InputStream inputStream = classLoader.getResourceAsStream("dw-queue.properties");){
            properties.load(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        String rate = properties.getProperty("queue.heartbeat.rate");
        return new Heartbeat(Long.valueOf(rate));
    }

    @Configuration
    @Profile(value={"Tenant"})
    public static class TenantConfiguration {
        @Bean
        @DependsOn(value={"QueueDeclarer", "TopicManager"})
        public DWQueueTenantProducer tenantProducer() {
            return new DWRabbitmqTenantProducer();
        }
    }

    @Configuration
    @Profile(value={"Saas"})
    public static class SaasConfiguration {
        @Bean
        @DependsOn(value={"QueueDeclarer", "TopicManager"})
        public DWQueueSaasProducer saasProducer() {
            return new DWRabbitmqSaasProducer();
        }
    }
}

