/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.queue.rabbitmq;

import com.digiwin.app.queue.DWQueueClientHolder;
import com.digiwin.app.queue.Queue;
import com.digiwin.app.queue.rabbitmq.RabbitmqTopicSupporter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

public class DWRabbitmqClientHolder
implements DWQueueClientHolder {
    private String url;
    private String username;
    private String password;

    public DWRabbitmqClientHolder(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    @Override
    public List<Map<String, String>> get(String tenantId, String apName) throws Exception {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        CloseableHttpClient httpclient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
        HttpGet httpGet = new HttpGet(this.url);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
        StringBuffer result = new StringBuffer();
        String line = "";
        while ((line = bufferedReader.readLine()) != null) {
            result.append(line);
        }
        JSONArray ja = new JSONArray(result.toString());
        ArrayList<Map<String, String>> alives = new ArrayList<Map<String, String>>();
        for (int i = 0; i < ja.length(); ++i) {
            JSONObject jo = ja.getJSONObject(i);
            JSONObject queueJo = jo.getJSONObject("queue");
            RabbitmqTopicSupporter topicSupporter = new RabbitmqTopicSupporter(Queue.HEARTBEAT.toString());
            if (!topicSupporter.getQueueName().equals(queueJo.getString("name"))) continue;
            String[] consumerTagParts = jo.getString("consumer_tag").split("\\.");
            HashMap<String, String> alive = new HashMap<String, String>();
            if (!consumerTagParts[0].equals(tenantId) || !consumerTagParts[3].equals(apName)) continue;
            alive.put("gatewayId", consumerTagParts[1]);
            alive.put("gatewayName", consumerTagParts[2]);
            alives.add(alive);
        }
        return alives;
    }
}

