/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.queue.rabbitmq;

import com.digiwin.app.queue.BroadcastStandardCompleteCallback;
import com.digiwin.app.queue.BroadcastStandardTimeoutCallback;
import com.digiwin.app.queue.DWQueueApplicationContextProvider;
import com.digiwin.app.queue.DWQueueProducer;
import com.digiwin.app.queue.DWQueueSaasProducer;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqClientHolder;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqProducer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;

public class DWRabbitmqSaasProducer
extends DWRabbitmqProducer
implements DWQueueSaasProducer {
    @Override
    public String onStandardBroadcast(List<String> topics, String message, Integer timeout, TimeUnit timeoutUnit) throws Exception {
        return this.onCustomBroadcast(topics, message, timeout, timeoutUnit, new HashMap<String, DWQueueProducer.CompleteCallback>(), new HashMap<String, DWQueueProducer.TimeoutCallback>());
    }

    @Override
    public String onCustomBroadcast(List<String> topics, String message, Integer timeout, TimeUnit timeoutUnit, Map<String, DWQueueProducer.CompleteCallback> customCompleteCallbacks, Map<String, DWQueueProducer.TimeoutCallback> customTimeoutCallbacks) throws Exception {
        if (customCompleteCallbacks == null) {
            customCompleteCallbacks = new HashMap<String, DWQueueProducer.CompleteCallback>();
        }
        if (customTimeoutCallbacks == null) {
            customTimeoutCallbacks = new HashMap<String, DWQueueProducer.TimeoutCallback>();
        }
        ArrayBlockingQueue<String> response = new ArrayBlockingQueue<String>(topics.size());
        for (String topic : topics) {
            String gatewayId = topic.split("\\.")[1];
            DWQueueProducer.CompleteCallback customCompleteCallback = customCompleteCallbacks.getOrDefault(gatewayId, null);
            DWQueueProducer.TimeoutCallback customTimeoutCallback = customTimeoutCallbacks.getOrDefault(gatewayId, null);
            BroadcastStandardCompleteCallback completeCallback = new BroadcastStandardCompleteCallback(response, customCompleteCallback);
            BroadcastStandardTimeoutCallback timeoutCallback = new BroadcastStandardTimeoutCallback(response, customTimeoutCallback);
            super.onSend(topic, message, completeCallback, timeoutCallback, timeout, timeoutUnit);
        }
        while (response.remainingCapacity() != 0) {
        }
        JSONArray ja = new JSONArray();
        Iterator iterator = response.iterator();
        while (iterator.hasNext()) {
            JSONObject jo = new JSONObject((String)iterator.next());
            ja.put((Object)jo);
        }
        return ja.toString();
    }

    public String queryRegister(String tenantId, String apName) {
        ApplicationContext context = DWQueueApplicationContextProvider.getApplicationContext();
        DWRabbitmqClientHolder clientHolder = (DWRabbitmqClientHolder)context.getBean(DWRabbitmqClientHolder.class);
        List<Object> clients = new ArrayList();
        try {
            clients = clientHolder.get(tenantId, apName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONArray responseJa = new JSONArray(clients);
        return responseJa.toString();
    }
}

