/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.queue.rabbitmq;

import com.digiwin.app.queue.DWQueueTenantProducer;
import com.digiwin.app.queue.Queue;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqChannel;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqProducer;
import com.digiwin.app.queue.rabbitmq.RabbitmqTopicSupporter;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.UUID;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class DWRabbitmqTenantProducer
extends DWRabbitmqProducer
implements DWQueueTenantProducer {
    @Autowired
    private DWRabbitmqChannel rabbitmqChannel;

    @Override
    public String onRegister(String tenantId, String gatewayName, String apName) throws Exception {
        return this.onReRegister(tenantId, null, gatewayName, apName);
    }

    @Override
    public String onReRegister(String tenantId, String gatewayId, String gatewayName, String apName) throws Exception {
        JSONObject jo = new JSONObject();
        try {
            if (gatewayId == null) {
                Long currentTimeMillis = System.currentTimeMillis();
                Long nanoTime = System.nanoTime();
                String seed = tenantId + gatewayName + apName + currentTimeMillis.toString() + nanoTime.toString();
                UUID uuid = UUID.nameUUIDFromBytes(seed.toString().getBytes("UTF-8"));
                StringBuilder stringBuilder = new StringBuilder(uuid.toString().replaceAll("-", ""));
                stringBuilder.deleteCharAt(16);
                stringBuilder.deleteCharAt(12);
                gatewayId = stringBuilder.toString();
            }
            RabbitmqTopicSupporter topicSupporter = new RabbitmqTopicSupporter(Queue.HEARTBEAT.toString());
            Channel channel = this.rabbitmqChannel.getChannel();
            String queueName = topicSupporter.getQueueName();
            String consumerTag = tenantId + "." + gatewayId + "." + gatewayName + "." + apName;
            channel.basicConsume(queueName, true, consumerTag, (Consumer)new DefaultConsumer(channel));
            jo.put("result", true);
            jo.put("tenantId", (Object)tenantId);
            jo.put("gatewayId", (Object)gatewayId);
            jo.put("description", (Object)"");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            jo.put("result", false);
            jo.put("tenantId", (Object)tenantId);
            jo.put("gatewayId", (Object)"");
            jo.put("description", (Object)stringWriter.toString());
        }
        return jo.toString();
    }
}

