/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.queue.rabbitmq;

import com.digiwin.app.queue.rabbitmq.DWRabbitmqClientHolder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class Heartbeat
implements Runnable {
    @Autowired
    private DWRabbitmqClientHolder clientHolder;
    private Thread worker;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private String tenantId;
    private String apName;
    private long rate;
    private HeartbeatCallback heartbeatCallback;

    public Heartbeat(long rate) {
        this.rate = rate;
        this.heartbeatCallback = null;
    }

    @PostConstruct
    public void start() {
        if (this.running.get()) {
            return;
        }
        this.worker = new Thread(this);
        this.worker.setName("heartbeat" + UUID.randomUUID().toString());
        this.worker.start();
    }

    public void stop() {
        this.running.set(false);
    }

    @Override
    public void run() {
        this.running.set(true);
        while (this.running.get()) {
            try {
                TimeUnit.SECONDS.sleep(this.rate);
                final List<Map<String, String>> alives = this.clientHolder.get(this.tenantId, this.apName);
                if (this.heartbeatCallback == null) continue;
                Executors.newSingleThreadExecutor().submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Heartbeat.this.heartbeatCallback.onHeartbeat(alives);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setHeartbeatCallback(String tenantId, String apName, HeartbeatCallback heartbeatCallback) {
        this.tenantId = tenantId;
        this.apName = apName;
        this.heartbeatCallback = heartbeatCallback;
    }

    public static interface HeartbeatCallback {
        public void onHeartbeat(List<Map<String, String>> var1);
    }
}

