/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.resource;

import com.digiwin.app.service.DWServiceContext;
import java.util.Locale;
import java.util.ResourceBundle;

public final class DWResourceBundle {
    public static final String KEY_LOCALE = "locale";

    public static String getString(String baseName, String key) {
        Locale locale = DWResourceBundle.getCurrentLocale();
        String value = DWResourceBundle.getString(baseName, locale, key);
        return value;
    }

    public static String getString(String baseName, Locale locale, String key) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ResourceBundle rb = ResourceBundle.getBundle(baseName, locale, cl);
        String value = rb.getString(key);
        return value;
    }

    public static Locale getCurrentLocale() {
        String localeString = (String)DWServiceContext.getContext().getProfile().get(KEY_LOCALE);
        if (localeString == null || localeString.isEmpty()) {
            return Locale.getDefault();
        }
        return DWResourceBundle.getLocale(localeString);
    }

    public static Locale getLocale(String localeString) {
        String[] parts = localeString.split("_");
        String lang = parts[0];
        String country = parts.length > 1 ? parts[1] : "";
        Locale locale = new Locale(lang, country);
        return locale;
    }

    public static String getString(String baseName, String key, Object ... patternArguments) {
        String format = DWResourceBundle.getString(baseName, key);
        String formatResult = String.format(format, patternArguments);
        return formatResult;
    }
}

