/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.job;

import com.digiwin.app.schedule.entity.DWScheduleSimpleJobInfo;
import com.digiwin.app.schedule.quartz.job.DWJobInvoker;
import com.digiwin.app.schedule.service.DWScheduleService;
import com.digiwin.app.schedule.util.DWScheduleExceptionUtils;
import com.digiwin.app.schedule.util.DWScheduleTimeUtils;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class SimpleTriggerBuilderJob
implements Job,
InterruptableJob {
    private static final String CLASS_TAG = "[DWSchedule.SimpleTriggerBuilderJob]";
    private static Log log = LogFactory.getLog(SimpleTriggerBuilderJob.class);
    private DWScheduleService quartzService = DWScheduleService.getInstance();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        DWScheduleSimpleJobInfo simpleJobInfo = (DWScheduleSimpleJobInfo)jobDataMap.get((Object)"jobInfo");
        String startTime = simpleJobInfo.getStartTime();
        String endTime = simpleJobInfo.getEndTime();
        String internalTime = simpleJobInfo.getInternalTime();
        String triggerName = simpleJobInfo.getTriggerName();
        String jobName = simpleJobInfo.getJobName();
        String jobGroup = simpleJobInfo.getGroupName();
        Class<DWJobInvoker> jobClass = DWJobInvoker.class;
        try {
            Date date = DWScheduleTimeUtils.getToday();
            Date startDate = new Date(date.getTime() + Long.parseLong(startTime));
            Date endDate = new Date(date.getTime() + Long.parseLong(endTime));
            Date now = new Date();
            if (startDate.getTime() < now.getTime() && endDate.getTime() > now.getTime()) {
                Long internalTimeLong = Long.parseLong(internalTime);
                Long diff = now.getTime() - startDate.getTime();
                startDate = new Date(startDate.getTime() + (diff / internalTimeLong + 1L) * internalTimeLong);
            }
            this.quartzService.addSimpleTriggerJob(jobName, triggerName, jobGroup, startDate, endDate, internalTime, jobDataMap, jobClass);
            log.info((Object)("triggerName:" + triggerName + "\u6392\u7a0b\u555f\u52d5"));
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(log, CLASS_TAG, e);
            e.printStackTrace();
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
    }
}

