/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.listener;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.schedule.dbservice.DWScheduleRecordDBService;
import com.digiwin.app.schedule.util.DWScheduleExceptionUtils;
import com.digiwin.app.schedule.util.DWScheduleMailUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.listeners.TriggerListenerSupport;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DWJobInterruptListener
extends TriggerListenerSupport
implements SchedulerPlugin {
    private static final String CLASS_TAG = "[DWSchedule.DWQuartzJobListener]";
    private static Log log = LogFactory.getLog(DWJobInterruptListener.class);
    private long defalutMaxRuntime = 30L;
    private String name = "DWJobInterruptListener";
    private ScheduledExecutorService executor;
    private ScheduledFuture future;
    private Scheduler scheduler;
    private static final String JOB_INTERRUPT_MONITOR_KEY = "JOB_INTERRUPT_MONITOR_KEY";
    private DWScheduleRecordDBService recordService = DWScheduleRecordDBService.getInstance();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");

    public String getName() {
        return this.name;
    }

    public void initialize(String name, Scheduler scheduler, ClassLoadHelper helper) throws SchedulerException {
        this.name = name;
        this.executor = Executors.newScheduledThreadPool(1);
        scheduler.getContext().put(JOB_INTERRUPT_MONITOR_KEY, (Object)this);
        this.scheduler = scheduler;
        this.scheduler.getListenerManager().addTriggerListener((TriggerListener)this);
    }

    public ScheduledFuture scheduleJobInterruptMonitor(JobKey jobkey, long delay) {
        return this.executor.schedule(new InterruptMonitor(jobkey, this.scheduler, this.recordService), delay, TimeUnit.MINUTES);
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
        try {
            DWJobInterruptListener listener = (DWJobInterruptListener)((Object)context.getScheduler().getContext().get((Object)JOB_INTERRUPT_MONITOR_KEY));
            long jobDataDelay = this.defalutMaxRuntime;
            if (context.getJobDetail().getJobDataMap().get((Object)"max_runtime") != null) {
                jobDataDelay = context.getJobDetail().getJobDataMap().getLong("max_runtime");
            }
            this.future = listener.scheduleJobInterruptMonitor(context.getJobDetail().getKey(), jobDataDelay);
            log.debug((Object)("Job's Interrupt Monitor has been scheduled to interrupt with the delay :" + this.defalutMaxRuntime));
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            String scheduleId = jobDataMap.getString("schedule_id");
            String executeId = this.sdf.format(new Date()) + "-" + scheduleId;
            jobDataMap.put("execute_id", executeId);
        }
        catch (SchedulerException e) {
            log.info((Object)("Error scheduling interrupt monitor " + e.getMessage()), (Throwable)e);
        }
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
        if (this.future != null) {
            this.future.cancel(true);
        }
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String executeState = jobDataMap.getString("execute_status");
        Object contactList = jobDataMap.get((Object)"contact_list");
        try {
            DWScheduleMailUtils.sendEmail(contactList, executeState);
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(log, CLASS_TAG, e);
        }
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        if (jobDataMap.containsKey((Object)"is_allow_concurrent") && jobDataMap.get((Object)"is_allow_concurrent").equals(false)) {
            JobKey jobKey = context.getJobDetail().getKey();
            Scheduler scheduler = context.getScheduler();
            try {
                List excutingJobs = scheduler.getCurrentlyExecutingJobs();
                for (JobExecutionContext jobContext : excutingJobs) {
                    if (!jobContext.getJobDetail().getKey().equals((Object)jobKey)) continue;
                    String message = jobKey + " is already running.";
                    log.info((Object)message);
                    if (this.future != null) {
                        this.future.cancel(true);
                    }
                    return true;
                }
            }
            catch (SchedulerException e) {
                DWScheduleExceptionUtils.log(log, CLASS_TAG, (Exception)((Object)e));
            }
        }
        return false;
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void start() {
    }

    public long getDefalutMaxRuntime() {
        return this.defalutMaxRuntime;
    }

    public void setDefalutMaxRuntime(long defalutMaxRuntime) {
        this.defalutMaxRuntime = defalutMaxRuntime;
    }

    static class InterruptMonitor
    implements Runnable {
        private final JobKey jobKey;
        private final Scheduler scheduler;
        private final DWScheduleRecordDBService recordService;
        private final Logger log = LoggerFactory.getLogger(this.getClass());

        InterruptMonitor(JobKey jobKey, Scheduler scheduler, DWScheduleRecordDBService recordService) {
            this.jobKey = jobKey;
            this.scheduler = scheduler;
            this.recordService = recordService;
        }

        @Override
        public void run() {
            try {
                this.log.info("Interrupting Job as it ran more than the configured max time. Job Details [" + this.jobKey.getName() + ":" + this.jobKey.getGroup() + "]");
                JobDataMap jobDataMap = this.scheduler.getJobDetail(this.jobKey).getJobDataMap();
                String scheduleId = jobDataMap.getString("schedule_id");
                String exeCuteId = jobDataMap.getString("execute_id");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
                DWDataSet dataSet = new DWDataSet();
                DWDataRow row = dataSet.newTable("dw_schedule_record").newRow();
                row.set("execute_id", (Object)exeCuteId);
                row.set("schedule_id", (Object)scheduleId);
                row.set("execute_status", (Object)"interrupted");
                row.set("end_time", (Object)sdf.format(new Timestamp(new Date().getTime())));
                row.set("$state", (Object)"U");
                DWDataRow scheduleRow = dataSet.newTable("dw_schedule").newRow();
                scheduleRow.set("schedule_id", (Object)scheduleId);
                scheduleRow.set("recent_status", (Object)"interrupted");
                scheduleRow.set("$state", (Object)"U");
                this.recordService.updateByDataSet(dataSet);
                this.scheduler.interrupt(this.jobKey);
            }
            catch (Exception ex) {
                this.log.info("Error interrupting Job: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

