/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.util;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.schedule.dataobject.ScheduleContactDO;
import com.digiwin.app.schedule.dataobject.ScheduleRecordDO;
import com.digiwin.app.schedule.dataobject.ScheduleTimeDO;
import com.digiwin.app.schedule.entity.DWScheduleQuartzInfo;
import com.digiwin.app.schedule.entity.InternalTime;
import com.google.gson.Gson;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWScheduleCastUtils {
    private static final String CLASS_TAG = "[DWSchedule.DWScheduleCastUtils]";
    private static Log log = LogFactory.getLog(DWScheduleCastUtils.class);
    private static Gson gson = new Gson();
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String getMapValueAsString(Map<String, Object> paramsMap, String attribute, String attributeName) throws Exception {
        String attributeValue = MapUtils.getString(paramsMap, (Object)attribute);
        if (attributeValue == null) {
            log.error((Object)("[DWSchedule.DWScheduleCastUtils] Exception : " + attributeName + "\u4e3a\u7a7a"));
            throw new Exception(attributeName + "\u4e3a\u7a7a");
        }
        if (attributeValue.length() <= 0) {
            log.error((Object)("[DWSchedule.DWScheduleCastUtils] Exception : " + attributeName + "\u957f\u5ea6\u4e0d\u53ef\u4e3a\u96f6"));
            throw new Exception(attributeName + "\u957f\u5ea6\u4e0d\u53ef\u4e3a\u96f6");
        }
        return attributeValue;
    }

    public static Integer getMapValueAsInteger(Map<String, Object> paramsMap, String attribute, String attributeName) throws Exception {
        Integer attributeValue = MapUtils.getInteger(paramsMap, (Object)attribute);
        if (attributeValue == null) {
            log.error((Object)("[DWSchedule.DWScheduleCastUtils] Exception : " + attributeName + "\u4e3a\u7a7a"));
            throw new Exception(attributeName + "\u4e3a\u7a7a");
        }
        return attributeValue;
    }

    public static DWScheduleQuartzInfo convertMapToDWScheduleQuartzInfo(Map<String, Object> paramsMap) throws Exception {
        DWScheduleQuartzInfo quartzInfo = new DWScheduleQuartzInfo();
        quartzInfo.setId(MapUtils.getInteger(paramsMap, (Object)"id"));
        quartzInfo.setScheduleId(MapUtils.getString(paramsMap, (Object)"schedule_id"));
        quartzInfo.setScheduleName(MapUtils.getString(paramsMap, (Object)"schedule_name"));
        quartzInfo.setJobName(MapUtils.getString(paramsMap, (Object)"job_name"));
        quartzInfo.setScheduleType(MapUtils.getString(paramsMap, (Object)"schedule_type"));
        quartzInfo.setEnableStatus(MapUtils.getString(paramsMap, (Object)"enable_status"));
        quartzInfo.setDescription(MapUtils.getString(paramsMap, (Object)"description"));
        quartzInfo.setEffectiveTime(DWScheduleCastUtils.convertObjectTimestamp(paramsMap.get("effective_time")));
        quartzInfo.setExpireTime(DWScheduleCastUtils.convertObjectTimestamp(paramsMap.get("expire_time")));
        quartzInfo.setMaxRuntime(MapUtils.getString(paramsMap, (Object)"max_runtime"));
        quartzInfo.setScheduleParam(MapUtils.getMap(paramsMap, (Object)"schedule_param"));
        quartzInfo.setModuleName(MapUtils.getString(paramsMap, (Object)"module_name"));
        quartzInfo.setRrule(MapUtils.getString(paramsMap, (Object)"r_rule"));
        ScheduleTimeDO detail = new ScheduleTimeDO();
        detail.setScheduleId(quartzInfo.getScheduleId());
        quartzInfo.setDetail(DWScheduleCastUtils.convertMapToScheduleTimeDO(detail, paramsMap, quartzInfo.getScheduleType()));
        ArrayList<ScheduleContactDO> contactList = new ArrayList<ScheduleContactDO>();
        quartzInfo.setContactList(DWScheduleCastUtils.convertMapToScheduleContactDOList(contactList, paramsMap, quartzInfo.getScheduleId()));
        return quartzInfo;
    }

    private static ScheduleTimeDO convertMapToScheduleTimeDO(ScheduleTimeDO detail, Map<String, Object> paramsMap, String scheduleType) throws Exception {
        if ("1".equals(scheduleType)) {
            detail.setAssignTime(MapUtils.getString(paramsMap, (Object)"assign_time"));
        } else if ("2".equals(scheduleType)) {
            detail.setMonth(MapUtils.getString(paramsMap, (Object)"month", (String)""));
            detail.setWeekOfMonth(MapUtils.getString(paramsMap, (Object)"week_of_month", (String)""));
            detail.setWeek(MapUtils.getString(paramsMap, (Object)"day_of_week", (String)""));
            detail.setDayOfMonth(MapUtils.getString(paramsMap, (Object)"day_of_month", (String)""));
            detail.setTime(MapUtils.getString(paramsMap, (Object)"time", (String)""));
            detail.setTime1(MapUtils.getString(paramsMap, (Object)"time1", (String)""));
            detail.setTime2(MapUtils.getString(paramsMap, (Object)"time2", (String)""));
            detail.setTime3(MapUtils.getString(paramsMap, (Object)"time3", (String)""));
            detail.setHoliday(MapUtils.getString(paramsMap, (Object)"holiday", (String)""));
            detail.setDayRadio(MapUtils.getString(paramsMap, (Object)"day_radio"));
            detail.setMonthRadio(MapUtils.getString(paramsMap, (Object)"month_radio"));
            detail.setTimeRadio(MapUtils.getString(paramsMap, (Object)"time_radio"));
            detail.setWeekRadio(MapUtils.getString(paramsMap, (Object)"week_radio"));
        } else if ("4".equals(scheduleType)) {
            detail.setMinutely(MapUtils.getInteger(paramsMap, (Object)"minutely", (Integer)-1));
            detail.setHourly(MapUtils.getInteger(paramsMap, (Object)"hourly", (Integer)-1));
            detail.setDaily(MapUtils.getInteger(paramsMap, (Object)"daily", (Integer)-1));
            detail.setWeekly(MapUtils.getInteger(paramsMap, (Object)"weekly", (Integer)-1));
            detail.setByDay(MapUtils.getString(paramsMap, (Object)"byday"));
            detail.setMonthly(MapUtils.getInteger(paramsMap, (Object)"monthly", (Integer)-1));
            detail.setByMonthday(MapUtils.getInteger(paramsMap, (Object)"bymonthday", (Integer)0));
            detail.setByWeeklyday(MapUtils.getString(paramsMap, (Object)"byweeklyday"));
            detail.setRepeatCount(MapUtils.getInteger(paramsMap, (Object)"repeat_count", (Integer)-1));
            detail.setStartTime(DWScheduleCastUtils.convertStringToTimestamp(MapUtils.getString(paramsMap, (Object)"start_time")));
            detail.setEndTime(DWScheduleCastUtils.convertStringToTimestamp(MapUtils.getString(paramsMap, (Object)"end_time")));
        } else {
            detail.setFrequency(MapUtils.getInteger(paramsMap, (Object)"frequency"));
            detail.setRepeatCount(MapUtils.getInteger(paramsMap, (Object)"repeat_count"));
            detail.setRepeatType(MapUtils.getInteger(paramsMap, (Object)"repeat_type"));
            detail.setStartTime(DWScheduleCastUtils.convertStringToTimestamp(MapUtils.getString(paramsMap, (Object)"start_time")));
            detail.setEndTime(DWScheduleCastUtils.convertStringToTimestamp(MapUtils.getString(paramsMap, (Object)"end_time")));
        }
        detail.setIsAllowConcurrent(MapUtils.getString(paramsMap, (Object)"is_allow_concurrent"));
        return detail;
    }

    private static ScheduleContactDO convertMapToScheduleContactDO(Map<String, String> map, String scheduleId) throws Exception {
        ScheduleContactDO contact = new ScheduleContactDO();
        contact.setId(MapUtils.getInteger(map, (Object)"id"));
        contact.setScheduleId(scheduleId);
        contact.setSendCondition(MapUtils.getString(map, (Object)"send_condition"));
        contact.setMailContent(MapUtils.getString(map, (Object)"mail_content"));
        contact.setMailSubject(MapUtils.getString(map, (Object)"mail_subject"));
        contact.setMailType(MapUtils.getString(map, (Object)"mail_type"));
        contact.setReceiverName(MapUtils.getString(map, (Object)"receiver_name"));
        contact.setReceiverEmail(MapUtils.getString(map, (Object)"receiver_email"));
        return contact;
    }

    private static List<ScheduleContactDO> convertMapToScheduleContactDOList(List<ScheduleContactDO> contactList, Map<String, Object> paramsMap, String scheduleId) throws Exception {
        if (paramsMap.containsKey("contact_list")) {
            List list = (List)MapUtils.getObject(paramsMap, (Object)"contact_list");
            for (Object obj : list) {
                if (!(obj instanceof Map)) continue;
                Map map = (Map)obj;
                contactList.add(DWScheduleCastUtils.convertMapToScheduleContactDO(map, scheduleId));
            }
        }
        return contactList;
    }

    public static List<ScheduleContactDO> convertToScheduleContactList(List<Map<String, Object>> contactList) throws Exception {
        List<ScheduleContactDO> list = null;
        for (Map<String, Object> map : contactList) {
            ScheduleContactDO contact = new ScheduleContactDO();
            contact.setId(MapUtils.getInteger(map, (Object)"id"));
            contact.setScheduleId(MapUtils.getString(map, (Object)"schedule_id"));
            contact.setMailType(MapUtils.getString(map, (Object)"mail_type"));
            contact.setMailSubject(MapUtils.getString(map, (Object)"mail_subject"));
            contact.setMailContent(MapUtils.getString(map, (Object)"mail_content"));
            contact.setReceiverEmail(MapUtils.getString(map, (Object)"receiver_email"));
            contact.setSendCondition(MapUtils.getString(map, (Object)"send_condition"));
            contact.setReceiverName(MapUtils.getString(map, (Object)"receiver_name"));
        }
        return list;
    }

    public static InternalTime convertStringToInternalTime(String str) {
        InternalTime time = new InternalTime();
        String[] timeArray = str.split(",");
        time.setStartHour(timeArray[0]);
        time.setStartMinute(timeArray[1]);
        time.setStartSecond(timeArray[2]);
        time.setEndHour(timeArray[3]);
        time.setEndMinute(timeArray[4]);
        time.setEndSecond(timeArray[5]);
        time.setContinueTime(timeArray[6]);
        time.setContinueType(timeArray[7]);
        return time;
    }

    public static DWDataSet convertScheduleQuartzInfoToScheduleDataSet(DWDataSet dataSet, DWScheduleQuartzInfo info, String rowState) {
        DWDataRow row = dataSet.newTable("dw_schedule").newRow();
        row.set("schedule_id", (Object)info.getScheduleId());
        row.set("schedule_name", (Object)info.getScheduleName());
        row.set("job_name", (Object)info.getJobName());
        row.set("schedule_type", (Object)info.getScheduleType());
        row.set("enable_status", (Object)info.getEnableStatus());
        row.set("description", (Object)info.getDescription());
        row.set("effective_time", (Object)info.getEffectiveTime());
        row.set("expire_time", (Object)info.getExpireTime());
        row.set("max_runtime", (Object)info.getMaxRuntime());
        row.set("schedule_param", (Object)gson.toJson(info.getScheduleParam()));
        row.set("module_name", (Object)info.getModuleName());
        row.set("$state", (Object)rowState);
        return dataSet;
    }

    public static DWDataSet convertScheduleQuartzInfoToScheduleTimeDataSet(DWDataSet dataSet, DWScheduleQuartzInfo info, String rowState) {
        ScheduleTimeDO timeDo = info.getDetail();
        DWDataRow row = dataSet.newTable("dw_schedule_time").newRow();
        row.set("schedule_id", (Object)info.getScheduleId());
        row.set("month", (Object)timeDo.getMonth());
        row.set("week_of_month", (Object)timeDo.getWeekOfMonth());
        row.set("week", (Object)timeDo.getWeek());
        row.set("day_of_month", (Object)timeDo.getDayOfMonth());
        row.set("assign_time", (Object)timeDo.getAssignTime());
        row.set("time", (Object)timeDo.getTime());
        row.set("time1", (Object)timeDo.getTime1());
        row.set("time2", (Object)timeDo.getTime2());
        row.set("time3", (Object)timeDo.getTime3());
        row.set("holiday", (Object)timeDo.getHoliday());
        row.set("is_allow_concurrent", (Object)timeDo.getIsAllowConcurrent());
        row.set("day_radio", (Object)timeDo.getDayRadio());
        row.set("month_radio", (Object)timeDo.getMonthRadio());
        row.set("time_radio", (Object)timeDo.getTimeRadio());
        row.set("week_radio", (Object)timeDo.getWeekRadio());
        row.set("frequency", (Object)timeDo.getFrequency());
        row.set("repeat_count", (Object)timeDo.getRepeatCount());
        row.set("repeat_type", (Object)timeDo.getRepeatType());
        row.set("start_time", (Object)timeDo.getStartTime());
        row.set("end_time", (Object)timeDo.getEndTime());
        row.set("$state", (Object)rowState);
        row.set("minutely", (Object)timeDo.getMinutely());
        row.set("hourly", (Object)timeDo.getHourly());
        row.set("daily", (Object)timeDo.getDaily());
        row.set("byday", (Object)timeDo.getByDay());
        row.set("weekly", (Object)timeDo.getWeekly());
        row.set("monthly", (Object)timeDo.getMonthly());
        row.set("bymonthday", (Object)timeDo.getByMonthday());
        row.set("byweeklyday", (Object)timeDo.getByWeeklyday());
        return dataSet;
    }

    public static DWDataSet convertScheduleRecordDOToDataSet(ScheduleRecordDO record, String rowState) {
        DWDataSet dataSet = new DWDataSet();
        DWDataRow row = dataSet.newTable("dw_schedule_record").newRow();
        row.set("execute_id", (Object)record.getExecuteId());
        row.set("schedule_id", (Object)record.getScheduleId());
        row.set("execute_status", (Object)record.getExecuteStatus());
        row.set("message", (Object)record.getMessage());
        row.set("message_detail", (Object)record.getMessageDetail());
        row.set("start_time", (Object)record.getStartTime());
        row.set("end_time", (Object)record.getEndTime());
        row.set("schedule_param", (Object)gson.toJson((Object)record.getScheduleParam()));
        row.set("job_name", (Object)record.getJobName());
        row.set("$state", (Object)rowState);
        return dataSet;
    }

    public static DWDataSet convertScheduleContactDOListToDataSet(DWDataSet dataSet, List<ScheduleContactDO> contactList, String rowState) {
        DWDataTable table = null;
        for (ScheduleContactDO contact : contactList) {
            if (table == null) {
                table = dataSet.newTable("dw_schedule_contact");
            }
            DWDataRow row = table.newRow();
            if (contact.getId() != null) {
                row.set("id", (Object)contact.getId());
            }
            row.set("schedule_id", (Object)contact.getScheduleId());
            row.set("mail_type", (Object)contact.getMailType());
            row.set("mail_subject", (Object)contact.getMailSubject());
            row.set("mail_content", (Object)contact.getMailContent());
            row.set("receiver_email", (Object)contact.getReceiverEmail());
            row.set("send_condition", (Object)contact.getSendCondition());
            row.set("$state", (Object)rowState);
        }
        return dataSet;
    }

    public static DWScheduleQuartzInfo convertDataRowToScheduleQuartzInfo(DWDataRow row) {
        DWScheduleQuartzInfo info = new DWScheduleQuartzInfo();
        info.setScheduleId((String)row.get("schedule_id"));
        info.setScheduleName((String)row.get("schedule_name"));
        info.setJobName((String)row.get("job_name"));
        info.setScheduleType((String)row.get("schedule_type"));
        info.setEnableStatus((String)row.get("enable_status"));
        info.setDescription((String)row.get("description"));
        info.setEffectiveTime((Date)row.get("effective_time"));
        info.setExpireTime((Date)row.get("expire_time"));
        info.setMaxRuntime(row.get("max_runtime"));
        info.setLastSuccessTime((Date)row.get("last_success_time"));
        info.setLastPeriodTime((Date)row.get("last_success_time"));
        info.setNextExecuteTime((Date)row.get("next_execute_time"));
        info.setModuleName((String)row.get("module_name"));
        Object params = row.get("schedule_param");
        info.setScheduleParam(params == null ? MapUtils.EMPTY_MAP : (Map)gson.fromJson((String)params, Map.class));
        return info;
    }

    public static DWScheduleQuartzInfo convertDataSetToScheduleQuartzInfo(DWDataSet dataSet) {
        DWScheduleQuartzInfo info = new DWScheduleQuartzInfo();
        DWDataRow row = dataSet.getTable("dw_schedule").getRow(0);
        info.setScheduleId((String)row.get("schedule_id"));
        info.setScheduleName((String)row.get("schedule_name"));
        info.setJobName((String)row.get("job_name"));
        info.setScheduleType((String)row.get("schedule_type"));
        info.setEnableStatus((String)row.get("enable_status"));
        info.setDescription((String)row.get("description"));
        info.setEffectiveTime((Date)row.get("effective_time"));
        info.setExpireTime((Date)row.get("expire_time"));
        info.setMaxRuntime(row.get("max_runtime"));
        info.setLastSuccessTime((Date)row.get("last_success_time"));
        info.setLastPeriodTime((Date)row.get("last_success_time"));
        info.setNextExecuteTime((Date)row.get("next_execute_time"));
        Object params = row.get("schedule_param");
        info.setScheduleParam(params == null ? MapUtils.EMPTY_MAP : (Map)gson.fromJson((String)params, Map.class));
        return info;
    }

    public static ScheduleTimeDO convertDataRowToScheduleTimeDo(DWDataRow row) throws ParseException {
        ScheduleTimeDO timeDo = new ScheduleTimeDO();
        timeDo.setScheduleId((String)row.get("schedule_id"));
        timeDo.setMonth((String)row.get("month"));
        timeDo.setWeekOfMonth((String)row.get("week_of_month"));
        timeDo.setWeek((String)row.get("week"));
        timeDo.setDayOfMonth((String)row.get("day_of_month"));
        timeDo.setAssignTime((String)row.get("assign_time"));
        timeDo.setTime((String)row.get("time"));
        timeDo.setTime1((String)row.get("time1"));
        timeDo.setTime2((String)row.get("time2"));
        timeDo.setTime3((String)row.get("time3"));
        timeDo.setHoliday((String)row.get("holiday"));
        timeDo.setIsAllowConcurrent((String)row.get("is_allow_concurrent"));
        timeDo.setFrequency(row.get("frequency"));
        timeDo.setDayRadio((String)row.get("day_radio"));
        timeDo.setMonthRadio((String)row.get("month_radio"));
        timeDo.setTimeRadio((String)row.get("time_radio"));
        timeDo.setWeekRadio((String)row.get("week_radio"));
        timeDo.setRepeatCount((Integer)row.get("repeat_count"));
        timeDo.setRepeatType(row.get("repeat_type"));
        timeDo.setStartTime((Date)row.get("start_time"));
        timeDo.setEndTime((Date)row.get("end_time"));
        timeDo.setMinutely((Integer)row.get("minutely"));
        timeDo.setHourly((Integer)row.get("hourly"));
        timeDo.setDaily((Integer)row.get("daily"));
        timeDo.setByDay((String)row.get("byday"));
        timeDo.setWeekly((Integer)row.get("weekly"));
        timeDo.setMonthly((Integer)row.get("monthly"));
        timeDo.setByMonthday((Integer)row.get("bymonthday"));
        timeDo.setByWeeklyday((String)row.get("byweeklyday"));
        return timeDo;
    }

    public static Date convertObjectToDate(Object object) {
        if (object != null && object instanceof Date) {
            return (Date)object;
        }
        return null;
    }

    public static Date convertStringToDate(String dateString) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)dateString)) {
            return sdf.parse(dateString);
        }
        return null;
    }

    public static Timestamp convertObjectTimestamp(Object object) {
        if (object != null && object instanceof Timestamp) {
            return (Timestamp)object;
        }
        return null;
    }

    public static Timestamp convertStringToTimestamp(String dateString) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)dateString)) {
            return Timestamp.valueOf(dateString);
        }
        return null;
    }
}

