/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.util;

import com.digiwin.app.module.utils.DWResourceUtils;
import com.digiwin.app.schedule.dataobject.ScheduleContactDO;
import com.digiwin.utils.DWMailUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWScheduleMailUtils {
    private static final String CLASS_TAG = "[DWSchedule.DWScheduleMailUtils]";
    private static Log log = LogFactory.getLog(DWScheduleMailUtils.class);

    public static void sendEmail(Object list, String executeState) throws Exception {
        List contactList = (List)list;
        String mailSubject = "";
        String mailContent = "";
        if (contactList != null && contactList.size() > 0) {
            ArrayList<String> receiver = new ArrayList<String>();
            ArrayList<String> cc = new ArrayList<String>();
            ArrayList<String> bcc = new ArrayList<String>();
            for (int i = 0; i < contactList.size(); ++i) {
                ScheduleContactDO contact = (ScheduleContactDO)contactList.get(i);
                if (!contact.getSendCondition().equals(executeState)) continue;
                mailSubject = contact.getMailSubject();
                mailContent = contact.getMailContent();
                switch (contact.getMailType()) {
                    case "1": {
                        receiver.add(contact.getReceiverEmail());
                        break;
                    }
                    case "2": {
                        cc.add(contact.getReceiverEmail());
                        break;
                    }
                    case "3": {
                        bcc.add(contact.getReceiverEmail());
                    }
                }
                String receiverList = DWScheduleMailUtils.getMailCsvList(receiver);
                String ccList = DWScheduleMailUtils.getMailCsvList(cc);
                String bccList = DWScheduleMailUtils.getMailCsvList(bcc);
                Properties properties = DWResourceUtils.getProperties((String)"dw-schedule-email.properties");
                String sender = (String)properties.get("email.username");
                String smtpHost = (String)properties.get("email.smtphost");
                int port = Integer.valueOf((String)properties.get("email.port"));
                String username = (String)properties.get("email.username");
                String passwd = (String)properties.get("email.passwd");
                int typeOfConnection = Integer.valueOf((String)properties.get("email.typeOfConnection"));
                DWMailUtils.doSendMail((String)sender, (String)receiverList, (String)ccList, (String)bccList, (String)smtpHost, (int)port, (String)username, (String)passwd, (String)mailSubject, (String)mailContent, (Integer)typeOfConnection);
                log.info((Object)("[DWSchedule.DWScheduleMailUtils] receiver: " + String.join((CharSequence)",", receiver)));
                log.info((Object)("[DWSchedule.DWScheduleMailUtils] cc: " + String.join((CharSequence)",", cc)));
                log.info((Object)("[DWSchedule.DWScheduleMailUtils] bcc: " + String.join((CharSequence)",", bcc)));
                log.info((Object)("[DWSchedule.DWScheduleMailUtils] mailSubject: " + mailSubject));
                log.info((Object)("[DWSchedule.DWScheduleMailUtils] executeState: " + executeState));
            }
        }
    }

    private static String getMailCsvList(List<String> mailReceivers) {
        if (mailReceivers.size() == 0) {
            return "";
        }
        String list = "";
        for (String receiver : mailReceivers) {
            list = list + receiver + ",";
        }
        if (list.endsWith(",")) {
            list = list.substring(0, list.length() - 1);
        }
        return list;
    }
}

