var app = angular.module('app');

app.controller('metadataController',
	function($scope, $http, DWMessage, DWSaveService, metadataService) {

	
	$scope.isBusy = "0";
	
	//Model connection
	$scope.connection = {};
	//$scope.connection.url = "127.0.0.1:3306";
	//$scope.connection.schema = "";
	//$scope.connection.id = "";
	//$scope.connection.password = "";
	
	//Model response info
	$scope.responseInfo = {};
	$scope.responseInfo.connectMessage = null;
	$scope.responseInfo.executeSQLMessage = null;
	
	//Model tables info
	$scope.tables = {};
	$scope.tables.selectedTables = []; 
	$scope.tables.tablesInDb = [];
	
	//Model metadata info
	$scope.metadata = {};
	
	//Model dw_rdbms_relations
	$scope.metadata.dw_rdbms_relations = [];
	$scope.metadata.dw_rdbms_relations_selected = {};
	$scope.metadata.dw_rdbms_relations_selected.index = -1;
	$scope.metadata.dw_rdbms_relations_selected.primary_table_no = null;
	$scope.metadata.dw_rdbms_relations_selected.primary_table_pk = null;
	$scope.metadata.dw_rdbms_relations_selected.primary_table_pk0 = null;
	$scope.metadata.dw_rdbms_relations_selected.primary_table_pk1 = null;
	$scope.metadata.dw_rdbms_relations_selected.primary_table_pk2 = null;
	$scope.metadata.dw_rdbms_relations_selected.primary_table_pk3 = null;
	$scope.metadata.dw_rdbms_relations_selected.primary_table_pk4 = null;
	$scope.metadata.dw_rdbms_relations_selected.reference_table_no = null;
	$scope.metadata.dw_rdbms_relations_selected.reference_table_pk = null;
	$scope.metadata.dw_rdbms_relations_selected.reference_table_pk0 = null;
	$scope.metadata.dw_rdbms_relations_selected.reference_table_pk1 = null;
	$scope.metadata.dw_rdbms_relations_selected.reference_table_pk2 = null;
	$scope.metadata.dw_rdbms_relations_selected.reference_table_pk3 = null;
	$scope.metadata.dw_rdbms_relations_selected.reference_table_pk4 = null;	
	$scope.metadata.dw_rdbms_relations_selected.type = null;	
	$scope.metadata.dw_rdbms_relations_edit = {};
	$scope.metadata.dw_rdbms_relations_edit.type = [
		{
			name:"null(Auto)",
			value:null
		},
		{
			name:"Auto",
			value:"Auto"
		},
		{
			name:"OneToOne",
			value:"OneToOne"
		},
		{
			name:"OneToMany",
			value:"OneToMany"
		},
		{
			name:"ManyToMany",
			value:"ManyToMany"
		}	
	];
	
	$scope.metadata.dw_rdbms_relations_edit.primary_table_pk = [];
	$scope.metadata.dw_rdbms_relations_edit.reference_table_pk = [];
	$scope.metadata.dw_rdbms_relations_edit.listCompId = "dwRdbmsRelationsList";
	$scope.metadata.dw_rdbms_relations_edit.listCompHeight = 0;
	$scope.metadata.dw_rdbms_relations_edit.editCompId = "dwRdbmsRelationsEditForm";
	$scope.metadata.dw_rdbms_relations_edit.editCompHeight = 0;
	$scope.metadata.dw_rdbms_relations_edit.status = "";

	//Model dw_rdbms_tables
	$scope.metadata.dw_rdbms_tables = [];
	$scope.metadata.dw_rdbms_tables_selected = {};
	$scope.metadata.dw_rdbms_tables_selected.index = -1;
	$scope.metadata.dw_rdbms_tables_selected.table_name = null;
	$scope.metadata.dw_rdbms_tables_selected.table_display_name = null;
	$scope.metadata.dw_rdbms_tables_selected.table_description = null;
	$scope.metadata.dw_rdbms_tables_selected.delete_constraint = null;
	$scope.metadata.dw_rdbms_tables_selected.hint_field = null;	
	$scope.metadata.dw_rdbms_tables_edit = {};	
	$scope.metadata.dw_rdbms_tables_edit.hint_field = [];
	$scope.metadata.dw_rdbms_tables_edit.listCompId = "dwRdbmsTablesList";
	$scope.metadata.dw_rdbms_tables_edit.listCompHeight = 0;
	$scope.metadata.dw_rdbms_tables_edit.editCompId = "dwRdbmsTablesEditForm";
	$scope.metadata.dw_rdbms_tables_edit.editCompHeight = 0;
	$scope.metadata.dw_rdbms_tables_edit.status = "";

	//Model dw_rdbms_fields
	$scope.metadata.dw_rdbms_fields = [];
	$scope.metadata.dw_rdbms_fields_selected = {};
	$scope.metadata.dw_rdbms_fields_selected.index = -1;
	$scope.metadata.dw_rdbms_fields_selected.table_name = null;
	$scope.metadata.dw_rdbms_fields_selected.seq = null;
	$scope.metadata.dw_rdbms_fields_selected.field_name = null;
	$scope.metadata.dw_rdbms_fields_selected.is_key = null;
	$scope.metadata.dw_rdbms_fields_selected.nullable = null;
	$scope.metadata.dw_rdbms_fields_selected.field_type = null;
	$scope.metadata.dw_rdbms_fields_selected.size = null;
	$scope.metadata.dw_rdbms_fields_selected.scale = null;
	$scope.metadata.dw_rdbms_fields_selected.default_value = null;
	$scope.metadata.dw_rdbms_fields_selected.field_display_name = null;
	$scope.metadata.dw_rdbms_fields_selected.is_version = null;
	$scope.metadata.dw_rdbms_fields_selected.is_auto_increment = null;
	$scope.metadata.dw_rdbms_fields_selected.status_code = null;
	$scope.metadata.dw_rdbms_fields_edit = {};	
	$scope.metadata.dw_rdbms_fields_edit.listCompId = "dwRdbmsFieldsList";
	$scope.metadata.dw_rdbms_fields_edit.listCompHeight = 0;
	$scope.metadata.dw_rdbms_fields_edit.editCompId = "dwRdbmsFieldsEditForm";
	$scope.metadata.dw_rdbms_fields_edit.editCompHeight = 0;
	$scope.metadata.dw_rdbms_fields_edit.status = "";

	$scope.sqlResult = "";

	/**
	 * 加載保存的請求
	 */	
	$scope.$on('$viewContentLoaded', function() {
		DWSaveService.getData('metadata', 'connection')
		.then(function successCallback(userDataModel) {
			var result = userDataModel.getResult();			
			$scope.connection.url = result.url;
			$scope.connection.schema = result.schema;
			$scope.connection.id = result.id;
			$scope.connection.password = result.password;
		}, function errorCallback(userDataModel) {	
			$scope.connection.url = "127.0.0.1:3306";
			$scope.connection.schema = "";
			$scope.connection.id = "";
			$scope.connection.password = "";		
			//DWMessage.showError("Metadata[Database連線配置]讀取失敗!");
		});			
	});
  
	$scope.$on('$destroy', function() {
		//var parameters = {};
		//parameters.tempData = $scope.tempData;
		
		//parameterStorage.setData('dwRedisUtilController', parameters);
	});
	
	/**
	 * 設定 busy
	 * @param busy 是否忙錄
	 */
	$scope.setBusy = function (busy) {
		
		this.isBusy = busy ? "1" : "0";
	}
	
	$scope.cancelRequest = function() {		
		this.setBusy(false);
	}
		
	/**
	 * 連線數據庫
	 */
	$scope.connectDatabase = function() {
		//alert($scope.connection.url);
		//alert($scope.connection.id);
		//alert($scope.connection.password);
		$scope.responseInfo.connectMessage = null;
		
		var controller = this;
		
		var connectionInfo = {};
		connectionInfo.url = $scope.connection.url;
		connectionInfo.schema = $scope.connection.schema;
		connectionInfo.id = $scope.connection.id;
		connectionInfo.password = $scope.connection.password;
		
		controller.setBusy(true);
			
		DWSaveService.postData('metadata', 'connection', connectionInfo)
			.then(
				function successCallback(response) {
				}, 
				function errorCallback(response) {
					if(response.isConflict()) {						
						DWSaveService.putData('metadata', 'connection', connectionInfo)
						.then(function successCallback(response) {
														
						}, function errorCallback(response) {																		
							DWMessage.showError("Metadata[Database連線配置]保存失敗!");
						});
					}
					else {
						DWMessage.showError("Metadata[Database連線配置]保存失敗!");
					}
				});

		metadataService.connectDatabase(connectionInfo).then(
				function(serviceResult) { // success
					
					//alert(serviceResult);
					controller.setBusy(false);
					var serviceResultInfo = serviceResult.getResult();
					//alert(serviceResultInfo.success);
					//alert(serviceResultInfo.message);
					$scope.responseInfo.connectMessage = serviceResultInfo.message;
					DWMessage.showInfo("回應成功!");
					if(serviceResultInfo.success === true){
						//alert(serviceResultInfo.tableNames);
						$scope.tables.tablesInDb = serviceResultInfo.tableNames;
					}
				},
				
				function(serviceResult) { // failure

					controller.setBusy(false);
					//alert(serviceResult.getStatus());
					$scope.responseInfo.connectMessage = serviceResult.getStatus();
					DWMessage.showWarning("回應異常!");
					
				}
			);
		
		
	}
	/**
	 * 依據選擇的表清單，調用後端產生對應的metadata
	 */
	$scope.generateMetadata = function() {
		//alert($scope.selectedTables);
		//return ;
		var controller = this;
					
		controller.setBusy(true);
		
		metadataService.generateMetadata($scope.tables.selectedTables).then(
				function(serviceResult) { // success
					
					//alert(serviceResult);
					controller.setBusy(false);
					var serviceResultInfo = serviceResult.getResult();
					//alert(serviceResultInfo.success);
					//alert(serviceResultInfo.message);
					//$scope.responseInfo.connectMessage = serviceResultInfo.message;
					DWMessage.showInfo("回應成功!");
					if(serviceResultInfo.success === true){

						//綁定後端回傳的dw_rdbms_reations
						$scope.metadata.dw_rdbms_relations = serviceResultInfo.dw_rdbms_relations;
						//設定dw_rdbms_relations list的高度
						$scope.metadata.dw_rdbms_relations_edit.listCompHeight = 220;
						//設定dw_rdbms_relations edit form的高度
						$scope.metadata.dw_rdbms_relations_edit.editCompHeight = 260;
						//顯示dw_rdbms_relations list
						changeHeight($scope.metadata.dw_rdbms_relations_edit.listCompId, $scope.metadata.dw_rdbms_relations_edit.listCompHeight);
						//隱藏dw_rdbms_relations edit form
						changeHeight($scope.metadata.dw_rdbms_relations_edit.editCompId, 0);

						//綁定後端回傳的dw_rdbms_tables
						$scope.metadata.dw_rdbms_tables = serviceResultInfo.dw_rdbms_tables;
						//設定dw_rdbms_tables list的高度
						$scope.metadata.dw_rdbms_tables_edit.listCompHeight = 150;
						//設定dw_rdbms_tables edit form的高度
						$scope.metadata.dw_rdbms_tables_edit.editCompHeight = 190;
						//顯示dw_rdbms_tables list
						changeHeight($scope.metadata.dw_rdbms_tables_edit.listCompId, $scope.metadata.dw_rdbms_tables_edit.listCompHeight);
						//隱藏dw_rdbms_tables edit form
						changeHeight($scope.metadata.dw_rdbms_tables_edit.editCompId, 0);

						//綁定後端回傳的dw_rdbms_fields
						$scope.metadata.dw_rdbms_fields = serviceResultInfo.dw_rdbms_fields;
						//設定dw_rdbms_fields list的高度
						$scope.metadata.dw_rdbms_fields_edit.listCompHeight = 750;
						//設定dw_rdbms_fields edit form的高度
						$scope.metadata.dw_rdbms_fields_edit.editCompHeight = 450;
						//顯示dw_rdbms_fields list
						changeHeight($scope.metadata.dw_rdbms_fields_edit.listCompId, $scope.metadata.dw_rdbms_fields_edit.listCompHeight);
						//隱藏dw_rdbms_fields edit form
						changeHeight($scope.metadata.dw_rdbms_fields_edit.editCompId, 0);

					}
				},
				
				function(serviceResult) { // failure

					controller.setBusy(false);
					//alert(serviceResult.getStatus());
					//$scope.responseInfo.connectMessage = serviceResult.getStatus();
					DWMessage.showWarning("回應異常!");
					
				}
			);
		
		
	}

	/**
	 * 新增dw_rdbms_relations
	 */
	 $scope.addDWRdbmsRelations = function() {

		$scope.metadata.dw_rdbms_relations_edit.status = "add"; 		
		$scope.metadata.dw_rdbms_relations_selected.type = $scope.metadata.dw_rdbms_relations_edit.type[1].value;
		$scope.metadata.dw_rdbms_relations_selected.primary_table_no = $scope.tables.selectedTables[0];
		//取得primary_table_no後，呼叫changePrimaryTableNo，重新產生primary_table_pk的下拉清單
		$scope.changePrimaryTableNo($scope.metadata.dw_rdbms_relations_selected.primary_table_no);		
		$scope.metadata.dw_rdbms_relations_selected.primary_table_pk = "";
		$scope.metadata.dw_rdbms_relations_selected.primary_table_pk0 = null;
		$scope.metadata.dw_rdbms_relations_selected.primary_table_pk1 = null;
		$scope.metadata.dw_rdbms_relations_selected.primary_table_pk2 = null;
		$scope.metadata.dw_rdbms_relations_selected.primary_table_pk3 = null;
		$scope.metadata.dw_rdbms_relations_selected.primary_table_pk4 = null;

		$scope.metadata.dw_rdbms_relations_selected.reference_table_no = $scope.tables.tablesInDb[0];
		//取得reference_table_no後，呼叫changeReferenceTableNo，重新產生reference_table_pk的下拉清單
		$scope.changeReferenceTableNo($scope.metadata.dw_rdbms_relations_selected.reference_table_no);		
		$scope.metadata.dw_rdbms_relations_selected.reference_table_pk = "";
		$scope.metadata.dw_rdbms_relations_selected.reference_table_pk0 = null;
		$scope.metadata.dw_rdbms_relations_selected.reference_table_pk1 = null;
		$scope.metadata.dw_rdbms_relations_selected.reference_table_pk2 = null;
		$scope.metadata.dw_rdbms_relations_selected.reference_table_pk3 = null;
		$scope.metadata.dw_rdbms_relations_selected.reference_table_pk4 = null;
					
		//隱藏dw_rdbms_relations list
		changeHeight($scope.metadata.dw_rdbms_relations_edit.listCompId, 0);
		//顯示dw_rdbms_relations edit form
		changeHeight($scope.metadata.dw_rdbms_relations_edit.editCompId, $scope.metadata.dw_rdbms_relations_edit.editCompHeight);					
	
	 }

	
	/**
	 * 編輯dw_rdbms_relations
	 */
	$scope.editDWRdbmsRelations = function(selectedIndex) {

		$scope.metadata.dw_rdbms_relations_edit.status = "modify"; 
		$scope.metadata.dw_rdbms_relations_selected.index = selectedIndex;
		//$scope.metadata.dw_rdbms_relations_selected = $scope.metadata.dw_rdbms_relations[selectedIndex];
		//alert($scope.metadata.dw_rdbms_relations_selected.primary_table_no);
		//alert($scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_no);
		$scope.metadata.dw_rdbms_relations_selected.type = $scope.metadata.dw_rdbms_relations[selectedIndex].type;	
		
		$scope.metadata.dw_rdbms_relations_selected.primary_table_no = $scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_no;
		//取得primary_table_no後，呼叫changePrimaryTableNo，重新產生primary_table_pk的下拉清單
		$scope.changePrimaryTableNo($scope.metadata.dw_rdbms_relations_selected.primary_table_no);		
		$scope.metadata.dw_rdbms_relations_selected.primary_table_pk = $scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_pk;		
		$scope.metadata.dw_rdbms_relations_selected.primary_table_pk0 = $scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_pk0;
		$scope.metadata.dw_rdbms_relations_selected.primary_table_pk1 = $scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_pk1;
		$scope.metadata.dw_rdbms_relations_selected.primary_table_pk2 = $scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_pk2;
		$scope.metadata.dw_rdbms_relations_selected.primary_table_pk3 = $scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_pk3;
		$scope.metadata.dw_rdbms_relations_selected.primary_table_pk4 = $scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_pk4;

		$scope.metadata.dw_rdbms_relations_selected.reference_table_no = $scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_no;
		//取得reference_table_no後，呼叫changeReferenceTableNo，重新產生reference_table_pk的下拉清單
		$scope.changeReferenceTableNo($scope.metadata.dw_rdbms_relations_selected.reference_table_no);		
		$scope.metadata.dw_rdbms_relations_selected.reference_table_pk = $scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_pk;
		$scope.metadata.dw_rdbms_relations_selected.reference_table_pk0 = $scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_pk0;
		$scope.metadata.dw_rdbms_relations_selected.reference_table_pk1 = $scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_pk1;
		$scope.metadata.dw_rdbms_relations_selected.reference_table_pk2 = $scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_pk2;
		$scope.metadata.dw_rdbms_relations_selected.reference_table_pk3 = $scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_pk3;
		$scope.metadata.dw_rdbms_relations_selected.reference_table_pk4 = $scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_pk4;		
			
		//隱藏dw_rdbms_relations list
		changeHeight($scope.metadata.dw_rdbms_relations_edit.listCompId, 0);
		//顯示dw_rdbms_relations edit form
		changeHeight($scope.metadata.dw_rdbms_relations_edit.editCompId, $scope.metadata.dw_rdbms_relations_edit.editCompHeight);					
	}

	/**
	 * 儲存dw_rdbms_relations
	 */
	$scope.saveDWRdbmsRelations = function() {
		
		//validation
		var primary_table_no_value = $scope.metadata.dw_rdbms_relations_selected.primary_table_no;
		var reference_table_no_value = $scope.metadata.dw_rdbms_relations_selected.reference_table_no;
		if(primary_table_no_value == reference_table_no_value){
			alert('主表與關係表不可設定相同');
			return ;
		}

		var pri_key0_value, pri_key1_value, pri_key2_value, pri_key3_value, pri_key4_value;
		var ref_key0_value, ref_key1_value, ref_key2_value, ref_key3_value, ref_key4_value;
		var pri_key_values = [];
		var ref_key_values = [];

		pri_key0_value = $scope.metadata.dw_rdbms_relations_selected.primary_table_pk0;
		ref_key0_value = $scope.metadata.dw_rdbms_relations_selected.reference_table_pk0;
		pri_key1_value = $scope.metadata.dw_rdbms_relations_selected.primary_table_pk1;
		ref_key1_value = $scope.metadata.dw_rdbms_relations_selected.reference_table_pk1;
		pri_key2_value = $scope.metadata.dw_rdbms_relations_selected.primary_table_pk2;
		ref_key2_value = $scope.metadata.dw_rdbms_relations_selected.reference_table_pk2;
		pri_key3_value = $scope.metadata.dw_rdbms_relations_selected.primary_table_pk3;
		ref_key3_value = $scope.metadata.dw_rdbms_relations_selected.reference_table_pk3;
		pri_key4_value = $scope.metadata.dw_rdbms_relations_selected.primary_table_pk4;
		ref_key4_value = $scope.metadata.dw_rdbms_relations_selected.reference_table_pk4;
		
		if(pri_key0_value == null || pri_key0_value == '' || ref_key0_value == null || ref_key0_value == '' ){
			alert('最少要設定字段1對應關係');
			return ;
		}

		pri_key_values.push(pri_key0_value);
		ref_key_values.push(ref_key0_value);
		
		if(pri_key1_value != null && pri_key1_value != ''){
			pri_key_values.push(pri_key1_value);
			if (ref_key1_value == null || ref_key1_value == ''){
				alert('字段2對應關係設定不正確');
				return ;
			}
		}
		if(ref_key1_value != null && ref_key1_value != ''){
			ref_key_values.push(ref_key1_value);
			if (pri_key1_value == null || pri_key1_value == ''){
				alert('字段2對應關係設定不正確');
				return ;
			}
		}
		
		if(pri_key2_value != null && pri_key2_value != ''){
			pri_key_values.push(pri_key2_value);
			if (ref_key2_value == null || ref_key2_value == ''){
				alert('字段3對應關係設定不正確');
				return ;
			}
		}
		if(ref_key2_value != null && ref_key2_value != ''){
			ref_key_values.push(ref_key2_value);
			if (pri_key2_value == null || pri_key2_value == ''){
				alert('字段3對應關係設定不正確');
				return ;
			}
		}
		
		if(pri_key3_value != null && pri_key3_value != ''){
			pri_key_values.push(pri_key3_value);
			if (ref_key3_value == null || ref_key3_value == ''){
				alert('字段4對應關係設定不正確');
				return ;
			}
		}
		if(ref_key3_value != null && ref_key3_value != ''){
			ref_key_values.push(ref_key3_value);
			if (pri_key3_value == null || pri_key3_value == ''){
				alert('字段4對應關係設定不正確');
				return ;
			}
		}

		if(pri_key4_value != null && pri_key4_value != ''){
			pri_key_values.push(pri_key4_value);
			if (ref_key4_value == null || ref_key4_value == ''){
				alert('字段5對應關係設定不正確');
				return ;
			}
		}
		if(ref_key4_value != null && ref_key4_value != ''){
			ref_key_values.push(ref_key4_value);
			if (pri_key4_value == null || pri_key4_value == ''){
				alert('字段5對應關係設定不正確');
				return ;
			}
		}

		for(i = 0; i < pri_key_values.length - 1; i++){
			for(j = i + 1; j < pri_key_values.length; j++){
				var pri_left = pri_key_values[i];
				var pri_right = pri_key_values[j];
				if(pri_left == pri_right){
					//alert(i);
					//alert(j);
					//alert(pri_left);
					//alert(pri_right);
					alert('主表字段不可設定重覆');
					return ;
				}
				var ref_left = ref_key_values[i];
				var ref_right = ref_key_values[j];
				if(ref_left == ref_right){
					alert('關係表字段不可設定重覆');
					return ;
				}
			}
		}

		var newPrimaryTablePk = "";
		var newReferenceTablePk = "";
		for(i = 0; i < pri_key_values.length; i++){
			//alert((i == (pri_key_values - 1)));
			if(i == (pri_key_values.length - 1)){
				newPrimaryTablePk = newPrimaryTablePk + pri_key_values[i];
				newReferenceTablePk = newReferenceTablePk + ref_key_values[i];
			}
			else{
				newPrimaryTablePk = newPrimaryTablePk + pri_key_values[i] + ",";
				newReferenceTablePk = newReferenceTablePk + ref_key_values[i] + ",";
			}
		}
		
		if($scope.metadata.dw_rdbms_relations_edit.status == "modify"){
			var selectedIndex = $scope.metadata.dw_rdbms_relations_selected.index;
			$scope.metadata.dw_rdbms_relations[selectedIndex].type = $scope.metadata.dw_rdbms_relations_selected.type;
			$scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_no = $scope.metadata.dw_rdbms_relations_selected.primary_table_no;
			$scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_no = $scope.metadata.dw_rdbms_relations_selected.reference_table_no;						
			$scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_pk = newPrimaryTablePk;
			$scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_pk0 = pri_key0_value;
			$scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_pk1 = pri_key1_value;
			$scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_pk2 = pri_key2_value;
			$scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_pk3 = pri_key3_value;
			$scope.metadata.dw_rdbms_relations[selectedIndex].primary_table_pk4 = pri_key4_value;
			//alert(newPrimaryTablePk);			
			$scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_pk = newReferenceTablePk;
			$scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_pk0 = ref_key0_value;
			$scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_pk1 = ref_key1_value;
			$scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_pk2 = ref_key2_value;
			$scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_pk3 = ref_key3_value;
			$scope.metadata.dw_rdbms_relations[selectedIndex].reference_table_pk4 = ref_key4_value;
			$scope.metadata.dw_rdbms_relations[selectedIndex].data_row_state = "modified";
			$scope.metadata.dw_rdbms_relations[selectedIndex].data_row_state_desc = "修改";
			$scope.metadata.dw_rdbms_relations[selectedIndex].selected = true;
		}

		if($scope.metadata.dw_rdbms_relations_edit.status == "add"){
			var new_dw_rdbms_relations = {};
			new_dw_rdbms_relations.type = $scope.metadata.dw_rdbms_relations_selected.type;
			new_dw_rdbms_relations.primary_table_no = $scope.metadata.dw_rdbms_relations_selected.primary_table_no;
			new_dw_rdbms_relations.reference_table_no = $scope.metadata.dw_rdbms_relations_selected.reference_table_no;						
			new_dw_rdbms_relations.primary_table_pk = newPrimaryTablePk;
			new_dw_rdbms_relations.primary_table_pk0 = $scope.metadata.dw_rdbms_relations_selected.primary_table_pk0;
			new_dw_rdbms_relations.primary_table_pk1 = $scope.metadata.dw_rdbms_relations_selected.primary_table_pk1;
			new_dw_rdbms_relations.primary_table_pk2 = $scope.metadata.dw_rdbms_relations_selected.primary_table_pk2;
			new_dw_rdbms_relations.primary_table_pk3 = $scope.metadata.dw_rdbms_relations_selected.primary_table_pk3;
			new_dw_rdbms_relations.primary_table_pk4 = $scope.metadata.dw_rdbms_relations_selected.primary_table_pk4;
			new_dw_rdbms_relations.reference_table_pk = newReferenceTablePk;
			new_dw_rdbms_relations.reference_table_pk0 = $scope.metadata.dw_rdbms_relations_selected.reference_table_pk0;
			new_dw_rdbms_relations.reference_table_pk1 = $scope.metadata.dw_rdbms_relations_selected.reference_table_pk1;
			new_dw_rdbms_relations.reference_table_pk2 = $scope.metadata.dw_rdbms_relations_selected.reference_table_pk2;
			new_dw_rdbms_relations.reference_table_pk3 = $scope.metadata.dw_rdbms_relations_selected.reference_table_pk3;
			new_dw_rdbms_relations.reference_table_pk4 = $scope.metadata.dw_rdbms_relations_selected.reference_table_pk4;
			new_dw_rdbms_relations.data_row_state = "new";
			new_dw_rdbms_relations.data_row_state_desc = "新增";
			new_dw_rdbms_relations.selected = true;
			$scope.metadata.dw_rdbms_relations.push(new_dw_rdbms_relations);
		}

		

		//顯示dw_rdbms_relations list
		changeHeight($scope.metadata.dw_rdbms_relations_edit.listCompId, $scope.metadata.dw_rdbms_relations_edit.listCompHeight);
		//隱藏dw_rdbms_relations edit form
		changeHeight($scope.metadata.dw_rdbms_relations_edit.editCompId, 0);
	}

	/**
	 * 取消dw_rdbms_relations
	 */
	$scope.cancelDWRdbmsRelations = function(selectedIndex) {				
		//顯示dw_rdbms_relations list
		changeHeight($scope.metadata.dw_rdbms_relations_edit.listCompId, $scope.metadata.dw_rdbms_relations_edit.listCompHeight);
		//隱藏dw_rdbms_relations edit form
		changeHeight($scope.metadata.dw_rdbms_relations_edit.editCompId, 0);
	}

	/**
	 * 新增dw_rdbms_tables(先不支持)
	 */
	/*$scope.addDWRdbmsTables = function() {

	}*/

	
	/**
	 * 編輯dw_rdbms_tables
	 */
	$scope.editDWRdbmsTables = function(selectedIndex) {

		$scope.metadata.dw_rdbms_tables_edit.status = "modify"; 
		$scope.metadata.dw_rdbms_tables_selected.index = selectedIndex;		
		$scope.metadata.dw_rdbms_tables_selected.table_name = $scope.metadata.dw_rdbms_tables[selectedIndex].table_name;		
		//取得table_name後，呼叫changeTableName，重新產生hint_field的下拉清單
		$scope.changeTableName($scope.metadata.dw_rdbms_tables_selected.table_name);		
		$scope.metadata.dw_rdbms_tables_selected.table_display_name = $scope.metadata.dw_rdbms_tables[selectedIndex].table_display_name;
		$scope.metadata.dw_rdbms_tables_selected.table_description = $scope.metadata.dw_rdbms_tables[selectedIndex].table_description;
		$scope.metadata.dw_rdbms_tables_selected.delete_constraint = $scope.metadata.dw_rdbms_tables[selectedIndex].delete_constraint;
		$scope.metadata.dw_rdbms_tables_selected.hint_field = $scope.metadata.dw_rdbms_tables[selectedIndex].hint_field;

		//隱藏dw_rdbms_tables list
		changeHeight($scope.metadata.dw_rdbms_tables_edit.listCompId, 0);
		//顯示dw_rdbms_tables edit form
		changeHeight($scope.metadata.dw_rdbms_tables_edit.editCompId, $scope.metadata.dw_rdbms_tables_edit.editCompHeight);					
	}

	/**
	 * 儲存dw_rdbms_tables
	 */
	$scope.saveDWRdbmsTables = function() {
		
		if($scope.metadata.dw_rdbms_tables_edit.status == "modify"){			
			var selectedIndex = $scope.metadata.dw_rdbms_tables_selected.index;
			$scope.metadata.dw_rdbms_tables[selectedIndex].table_display_name = $scope.metadata.dw_rdbms_tables_selected.table_display_name;
			$scope.metadata.dw_rdbms_tables[selectedIndex].table_description = $scope.metadata.dw_rdbms_tables_selected.table_description;
			$scope.metadata.dw_rdbms_tables[selectedIndex].delete_constraint = $scope.metadata.dw_rdbms_tables_selected.delete_constraint;
			$scope.metadata.dw_rdbms_tables[selectedIndex].hint_field = $scope.metadata.dw_rdbms_tables_selected.hint_field;
			if($scope.metadata.dw_rdbms_tables[selectedIndex].data_row_state == "no_modified"){
				$scope.metadata.dw_rdbms_tables[selectedIndex].data_row_state = "modified";
				$scope.metadata.dw_rdbms_tables[selectedIndex].data_row_state_desc = "修改";
			}
			$scope.metadata.dw_rdbms_tables[selectedIndex].selected = true;
		}

		
		//顯示dw_rdbms_tables list
		changeHeight($scope.metadata.dw_rdbms_tables_edit.listCompId, $scope.metadata.dw_rdbms_tables_edit.listCompHeight);
		//隱藏dw_rdbms_tables edit form
		changeHeight($scope.metadata.dw_rdbms_tables_edit.editCompId, 0);
	}

	/**
	 * 取消dw_rdbms_tables
	 */
	$scope.cancelDWRdbmsTables = function(selectedIndex) {				
		//顯示dw_rdbms_tables list
		changeHeight($scope.metadata.dw_rdbms_tables_edit.listCompId, $scope.metadata.dw_rdbms_tables_edit.listCompHeight);
		//隱藏dw_rdbms_tables edit form
		changeHeight($scope.metadata.dw_rdbms_tables_edit.editCompId, 0);
	}

		/**
	 * 新增dw_rdbms_fields(先不支持)
	 */
	/*$scope.addDWRdbmsFields = function() {

	}*/

	
	/**
	 * 編輯dw_rdbms_fields
	 */
	 $scope.editDWRdbmsFields = function(selectedIndex) {

		$scope.metadata.dw_rdbms_fields_edit.status = "modify"; 
		$scope.metadata.dw_rdbms_fields_selected.index = selectedIndex;		
		$scope.metadata.dw_rdbms_fields_selected.table_name = $scope.metadata.dw_rdbms_fields[selectedIndex].table_name;
		$scope.metadata.dw_rdbms_fields_selected.seq = $scope.metadata.dw_rdbms_fields[selectedIndex].seq;
		$scope.metadata.dw_rdbms_fields_selected.field_name = $scope.metadata.dw_rdbms_fields[selectedIndex].field_name;
		$scope.metadata.dw_rdbms_fields_selected.is_key = $scope.metadata.dw_rdbms_fields[selectedIndex].is_key;
		$scope.metadata.dw_rdbms_fields_selected.nullable = $scope.metadata.dw_rdbms_fields[selectedIndex].nullable;
		$scope.metadata.dw_rdbms_fields_selected.field_type = $scope.metadata.dw_rdbms_fields[selectedIndex].field_type;
		$scope.metadata.dw_rdbms_fields_selected.size = $scope.metadata.dw_rdbms_fields[selectedIndex].size;
		$scope.metadata.dw_rdbms_fields_selected.scale = $scope.metadata.dw_rdbms_fields[selectedIndex].scale;
		$scope.metadata.dw_rdbms_fields_selected.default_value = $scope.metadata.dw_rdbms_fields[selectedIndex].default_value;
		$scope.metadata.dw_rdbms_fields_selected.field_display_name = $scope.metadata.dw_rdbms_fields[selectedIndex].field_display_name;
		$scope.metadata.dw_rdbms_fields_selected.is_version = $scope.metadata.dw_rdbms_fields[selectedIndex].is_version;
		$scope.metadata.dw_rdbms_fields_selected.is_auto_increment = $scope.metadata.dw_rdbms_fields[selectedIndex].is_auto_increment;
		$scope.metadata.dw_rdbms_fields_selected.status_code = $scope.metadata.dw_rdbms_fields[selectedIndex].status_code;
		

		//隱藏dw_rdbms_fields list
		changeHeight($scope.metadata.dw_rdbms_fields_edit.listCompId, 0);
		//顯示dw_rdbms_fields edit form
		changeHeight($scope.metadata.dw_rdbms_fields_edit.editCompId, $scope.metadata.dw_rdbms_fields_edit.editCompHeight);					
	}

	/**
	 * 儲存dw_rdbms_fields
	 */
	$scope.saveDWRdbmsFields = function() {
		
		if($scope.metadata.dw_rdbms_fields_edit.status == "modify"){			
			var selectedIndex = $scope.metadata.dw_rdbms_fields_selected.index;
			$scope.metadata.dw_rdbms_fields[selectedIndex].is_key = $scope.metadata.dw_rdbms_fields_selected.is_key;
			$scope.metadata.dw_rdbms_fields[selectedIndex].nullable = $scope.metadata.dw_rdbms_fields_selected.nullable;
			$scope.metadata.dw_rdbms_fields[selectedIndex].field_type = $scope.metadata.dw_rdbms_fields_selected.field_type;
			$scope.metadata.dw_rdbms_fields[selectedIndex].size = $scope.metadata.dw_rdbms_fields_selected.size;
			$scope.metadata.dw_rdbms_fields[selectedIndex].scale = $scope.metadata.dw_rdbms_fields_selected.scale;
			$scope.metadata.dw_rdbms_fields[selectedIndex].default_value = $scope.metadata.dw_rdbms_fields_selected.default_value;
			$scope.metadata.dw_rdbms_fields[selectedIndex].field_display_name = $scope.metadata.dw_rdbms_fields_selected.field_display_name;
			$scope.metadata.dw_rdbms_fields[selectedIndex].is_version = $scope.metadata.dw_rdbms_fields_selected.is_version;
			$scope.metadata.dw_rdbms_fields[selectedIndex].is_auto_increment = $scope.metadata.dw_rdbms_fields_selected.is_auto_increment;
			$scope.metadata.dw_rdbms_fields[selectedIndex].status_code = $scope.metadata.dw_rdbms_fields_selected.status_code;
			
			if($scope.metadata.dw_rdbms_fields[selectedIndex].data_row_state == "no_modified"){
				$scope.metadata.dw_rdbms_fields[selectedIndex].data_row_state = "modified";
				$scope.metadata.dw_rdbms_fields[selectedIndex].data_row_state_desc = "修改";
			}
			$scope.metadata.dw_rdbms_fields[selectedIndex].selected = true;
		}

		
		//顯示dw_rdbms_fields list
		changeHeight($scope.metadata.dw_rdbms_fields_edit.listCompId, $scope.metadata.dw_rdbms_fields_edit.listCompHeight);
		//隱藏dw_rdbms_fields edit form
		changeHeight($scope.metadata.dw_rdbms_fields_edit.editCompId, 0);
	}

	/**
	 * 取消dw_rdbms_fields
	 */
	$scope.cancelDWRdbmsFields = function(selectedIndex) {				
		//顯示dw_rdbms_fields list
		changeHeight($scope.metadata.dw_rdbms_fields_edit.listCompId, $scope.metadata.dw_rdbms_fields_edit.listCompHeight);
		//隱藏dw_rdbms_fields edit form
		changeHeight($scope.metadata.dw_rdbms_fields_edit.editCompId, 0);
	}

	/**
	 * 
	 * @param {產生sql} 
	 */	       
	$scope.generateSQLs = function() {				
		var controller = this;
		//alert('test');			
		controller.setBusy(true);

		var metadatas = {};
		metadatas.dw_rdbms_relations = [];
		metadatas.dw_rdbms_relations = $scope.metadata.dw_rdbms_relations;
		metadatas.dw_rdbms_tables = [];
		metadatas.dw_rdbms_tables = $scope.metadata.dw_rdbms_tables;
		metadatas.dw_rdbms_fields = [];
		metadatas.dw_rdbms_fields = $scope.metadata.dw_rdbms_fields;
		
		metadataService.generateSQLs(metadatas).then(
				function(serviceResult) { // success
					
					//alert(serviceResult);
					controller.setBusy(false);
					var serviceResultInfo = serviceResult.getResult();
					//alert(serviceResultInfo.success);
					//alert(serviceResultInfo.message);
					//$scope.responseInfo.connectMessage = serviceResultInfo.message;
					DWMessage.showInfo("回應成功!");
					if(serviceResultInfo.success === true){

						//綁定後端回傳的dw_rdbms_reations
						//$scope.metadata.dw_rdbms_relations = serviceResultInfo.dw_rdbms_relations;
						//alert(serviceResultInfo.sqls);
						$scope.sqlResult = serviceResultInfo.sqls;
					}
				},
				
				function(serviceResult) { // failure

					controller.setBusy(false);
					//alert(serviceResult.getStatus());
					//$scope.responseInfo.connectMessage = serviceResult.getStatus();
					DWMessage.showWarning("回應異常!");
					
				}
			);	
	}

	$scope.executeSQLs = function() {				
		var controller = this;		
		$scope.responseInfo.executeSQLMessage = null;		
		controller.setBusy(true);
		
		metadataService.executeSQLs($scope.sqlResult).then(
				function(serviceResult) { // success
										
					controller.setBusy(false);
					var serviceResultInfo = serviceResult.getResult();					
					$scope.responseInfo.executeSQLMessage = serviceResultInfo.message;					
					DWMessage.showInfo("回應成功!");
					if(serviceResultInfo.success === true){

					}
				},
				
				function(serviceResult) { // failure

					controller.setBusy(false);
					//alert(serviceResult.getStatus());
					$scope.responseInfo.executeSQLMessage = serviceResult.getStatus();
					DWMessage.showWarning("回應異常!");
					
				}
			);	
	}
	
	
	$scope.changePrimaryTableNo = function(value){
		//alert(value);
		var controller = this;
					
		controller.setBusy(true);
		metadataService.getColumnNames(value).then(
				function(serviceResult) { // success
					
					controller.setBusy(false);
					var serviceResultInfo = serviceResult.getResult();					
					DWMessage.showInfo("回應成功!");
					if(serviceResultInfo.success === true){
						
						$scope.metadata.dw_rdbms_relations_edit.primary_table_pk = serviceResultInfo.column_names;

					}
				},
				
				function(serviceResult) { // failure

					//controller.setBusy(false);
					//alert(serviceResult.getStatus());
					//$scope.responseInfo.connectMessage = serviceResult.getStatus();
					DWMessage.showWarning("回應異常!");
					
				}
			);
	}

	$scope.changeReferenceTableNo = function(value){
		//alert(value);
		var controller = this;
					
		controller.setBusy(true);
		metadataService.getColumnNames(value).then(
				function(serviceResult) { // success
					
					controller.setBusy(false);
					var serviceResultInfo = serviceResult.getResult();					
					DWMessage.showInfo("回應成功!");
					if(serviceResultInfo.success === true){
						
						$scope.metadata.dw_rdbms_relations_edit.reference_table_pk = serviceResultInfo.column_names;

					}
				},
				
				function(serviceResult) { // failure

					controller.setBusy(false);
					//alert(serviceResult.getStatus());
					//$scope.responseInfo.connectMessage = serviceResult.getStatus();
					DWMessage.showWarning("回應異常!");
					
				}
			);
	}

	$scope.changeTableName = function(value){
		//alert(value);
		var controller = this;
					
		controller.setBusy(true);
		metadataService.getColumnNames(value).then(
				function(serviceResult) { // success
					
					controller.setBusy(false);
					var serviceResultInfo = serviceResult.getResult();					
					DWMessage.showInfo("回應成功!");
					if(serviceResultInfo.success === true){
						$scope.metadata.dw_rdbms_tables_edit.hint_field = serviceResultInfo.column_names;						
					}
				},
				
				function(serviceResult) { // failure

					//controller.setBusy(false);
					//alert(serviceResult.getStatus());
					//$scope.responseInfo.connectMessage = serviceResult.getStatus();
					DWMessage.showWarning("回應異常!");
					
				}
			);
	}
		
	$scope.onTabSelected = function(tab) {
		
		// 2018--5-27 falcon event 順序問題 ($viewContentLoaded 還抓不到 viewer container
		/*if (this.tempData.resultViewer) {
			
			var viewerContainer = document.querySelector("#dwRedisUtilResultViewerContainer");
			if (viewerContainer != this.tempData.resultViewer.parentElement) {
			
				this.attachJsonViewer(this.tempData.resultViewer);
				this.reloadHistoryTabs();
			}
		}*/
	}	
});

function changeTab(tab1Id, tab2Id, tab3Id){	
	document.getElementById(tab1Id).classList.add("active");
	document.getElementById(tab1Id + "Content").classList.add("active");
	
	document.getElementById(tab2Id).classList.remove("active");
	document.getElementById(tab2Id + "Content").classList.remove("active");
	
	document.getElementById(tab3Id).classList.remove("active");
	document.getElementById(tab3Id + "Content").classList.remove("active");
}

function changeHeight(targetId, height){
	var target = document.getElementById(targetId);
	//alert(targetId);
	//alert(height);
	target.style.height = height + 'px';
}