var app = angular.module('app');

app.controller('RapDataController', 
		['$scope', '$mdDialog', '$http', 'DWService', 'settingService', 'parameterStorage', '$timeout', 
		 function($scope, $mdDialog, $http, DWService, settingService, parameterStorage, $timeout) {

	
	$scope.rapDatasDeveloperView = [];
	$scope.createDateStr;
	$scope.version;
	$scope.responseData;
	
	$scope.rapIpPort = '';
	$scope.rapProjectId = '';
	
	$scope.getRapDatas = function(responseData) {

		if(!responseData) {
			return;
		}
		
		var modelJSON = JSON.parse(responseData.modelJSON.split("\\'").join("'"));
		
		$scope.createDateStr = modelJSON.createDateStr;
		$scope.version = modelJSON.version;
		
		var moduleList = modelJSON.moduleList;
		
		moduleList.forEach(function(module) {
		    
			var name = module.name;
		    var pageList = module.pageList;
		    
		    pageList.forEach(function(page) {
			    
			    var actionList = page.actionList;
			    
			    actionList.forEach(function(action) {
			    	
			    	var rapData = {};
			    	var serviceInformations = [];
			    	var serviceInformation = {};
			    	var methodInformations = [];
			    	var methodInformation = {};
			    	
			    	var requestUrl = action.requestUrl.split("/");
			    	
			    	// 有相同模組名取出舊資料
			    	$scope.rapDatasDeveloperView.forEach(function(rapData) {
			    		if(rapData.module==requestUrl[0]) {
			    			serviceInformations = rapData.serviceInformations;
			    			
			    			var index = $scope.rapDatasDeveloperView.indexOf(rapData);
			    			$scope.rapDatasDeveloperView.splice(index, 1);
			    		}
			    	});

			    	// 有相同服務名取出舊資料
			    	serviceInformations.forEach(function(serviceInformation) {
			    		if(serviceInformation.service==requestUrl[1]) {
			    			methodInformations = serviceInformation.methodInformations;
			    			
			    			var index = serviceInformations.indexOf(serviceInformation);
			    			serviceInformations.splice(index, 1);
			    		}
			    	});
			    	
				    var requestParameters = [];
				    var responseParameters = [];
				    
				    var requestParameterList = action.requestParameterList;
				    
				    requestParameterList.forEach(function(requestParameter) {
				    	var methodInformationParameter = {};
				    	methodInformationParameter.identifier = requestParameter.identifier;
				    	methodInformationParameter.name = requestParameter.name;
				    	methodInformationParameter.dataType = requestParameter.dataType; 
				    	methodInformationParameter.remark = requestParameter.remark;
				    	
				    	// 有無子參數
				    	if(requestParameter.parameterList.length>0) {
				    		methodInformationParameter.hasNext = true;
				    		methodInformationParameter.parameterList = $scope.parseParameterList(requestParameter.parameterList);
				    	} else {
				    		methodInformationParameter.hasNext = false;
				    	}
				    	
				    	requestParameters.push(methodInformationParameter);
				    	methodInformation.requestParameters = requestParameters;
					});
				    
				    var responseParameterList = action.responseParameterList;
				    
				    responseParameterList.forEach(function(responseParameter) {
				    	var methodInformationParameter = {};
				    	methodInformationParameter.identifier = responseParameter.identifier;
				    	methodInformationParameter.name = responseParameter.name;
				    	methodInformationParameter.dataType = responseParameter.dataType; 
				    	methodInformationParameter.remark = responseParameter.remark;
				    	
				    	if(responseParameter.parameterList.length>0) {
				    		methodInformationParameter.hasNext = true;
				    		methodInformationParameter.parameterList = $scope.parseParameterList(responseParameter.parameterList);
				    	} else {
				    		methodInformationParameter.hasNext = false;
				    	}
				    	
				    	responseParameters.push(methodInformationParameter);
				    	methodInformation.responseParameters = responseParameters;
					});
				    
				    // 產生methodInformation
	    			methodInformation.name = action.name;
	    			methodInformation.description = action.description;
			    	methodInformation.method = requestUrl[2];
			    	// 加入methodInformations
			    	methodInformations.push(methodInformation);
			    	
			    	// 產生serviceInformation
			    	serviceInformation.methodInformations = methodInformations;
			    	serviceInformation.service = requestUrl[1];
			    	// 加入serviceInformations
			    	serviceInformations.push(serviceInformation);
			    	
			    	rapData.serviceInformations = serviceInformations;
			    	rapData.module = requestUrl[0];
			    	rapData.name = name;
				    $scope.rapDatasDeveloperView.push(rapData);
				});
			});
		});
	}	
	
	$scope.parseParameterList = function(parameterList) {
		
		var subParameters = [];
		
		parameterList.forEach(function(parameter) {
	    	var methodInformationParameter = {};
	    	methodInformationParameter.identifier = parameter.identifier;
	    	methodInformationParameter.name = parameter.name;
	    	methodInformationParameter.dataType = parameter.dataType; 
	    	methodInformationParameter.remark = parameter.remark;
	    	
	    	if(parameter.parameterList.length>0) {
	    		methodInformationParameter.hasNext = true;
	    		subParameters.push(methodInformationParameter);
	    		methodInformationParameter.parameterList = $scope.parseParameterList(parameter.parameterList);
	    	} else {
	    		methodInformationParameter.hasNext = false;
	    		subParameters.push(methodInformationParameter);
	    	}
		});
		
		return subParameters;
	}
	
	$scope.loadDataFromRapServer = function() {
		settingService.loadSetting(function() {
			DWService.initDWModuleInfoList();
			
			if(settingService.setting.unitTest) {
				$scope.rapIpPort = settingService.setting.unitTest.rapIpPort;
				$scope.rapProjectId = settingService.setting.unitTest.rapProjectId;
				
				DWService.invokeRapService($scope.rapIpPort, $scope.rapProjectId)
				.then(function successCallback(response) {
					$scope.responseData = response.data;
					$scope.getRapDatas($scope.responseData);
				}, function errorCallback(response) {
				});
			}
		});
	}
	
	$scope.onPanelClick = function(id) {
		
		var element = angular.element(document.querySelector('#' + id));
		
		if(element.hasClass('glyphicon-chevron-right')) {
			element.addClass('glyphicon-chevron-down');
			element.removeClass('glyphicon-chevron-right');
		} else {
			element.addClass('glyphicon-chevron-right');
			element.removeClass('glyphicon-chevron-down');
		} 
	}
	
	$scope.onRefreshClick = function() {
		$scope.rapDatasDeveloperView = [];
		$scope.loadDataFromRapServer();
	}
	
	/**
	 * 初始化
	 */
	$scope.initialize = function() {
		
		var parameters = parameterStorage.getData('rapDataController');

		if(parameters) {
			$scope.responseData = parameters.responseData;
			$scope.getRapDatas($scope.responseData);
			$scope.rapIpPort = parameters.rapIpPort;
			$scope.rapProjectId = parameters.rapProjectId;
		} else {
			$scope.loadDataFromRapServer();
		}
	}
	
	// 初始化
	$scope.initialize();
	
	$timeout(function () {
		
		var parameters = parameterStorage.getData('rapDataController');
		
		if(parameters && parameters.collapseInIdArray) {
			var collapseInIdArray = parameters.collapseInIdArray;
			
			collapseInIdArray.forEach(function(id) {
				var element = angular.element(document.querySelector('#' + id));
				element.addClass('in');
				$scope.onPanelClick(id + 'Arrow');
			});
		}
		
		if(parameters && parameters.glyphiconMinusIdArray) {
			var glyphiconMinusIdArray = parameters.glyphiconMinusIdArray;
			
			glyphiconMinusIdArray.forEach(function(id) {
				$scope.onParameterTablePlusClick(id);
				
				var parentGlyphiconId = document.getElementById(id).getAttribute('parent') + '.glyphicon';
				var parentGlyphicon = document.getElementById(parentGlyphiconId);

				// 若上一層沒展開這層也不展開
				if(parentGlyphicon) {
					if(parentGlyphicon.className=='glyphicon glyphicon-plus') {
						$scope.hideParameterTableRow(id);
					} else if(parentGlyphicon.className=='glyphicon glyphicon-minus') {
						$scope.showParameterTableRow(id);
					}
				}
			});
		}
	}, 300);
	
	$scope.$on('$destroy', function(event) {
		
		var collapseInIdArray = [];
		var collapseIn = document.getElementsByClassName("collapse in");
		for(var i=0; i<collapseIn.length; i++) {
			collapseInIdArray.push(collapseIn[i].id); 
		}
		
		var glyphiconMinusIdArray = [];
		var glyphiconMinus = document.getElementsByClassName("glyphicon glyphicon-minus");
		for(var i=0; i<glyphiconMinus.length; i++) {
			var id = glyphiconMinus[i].id;
			id = id.substring(0, id.lastIndexOf('.'));
			glyphiconMinusIdArray.push(id); 
		}
		
		var parameters = {};
		parameters.rapIpPort = $scope.rapIpPort;
		parameters.rapProjectId = $scope.rapProjectId;
		parameters.responseData = $scope.responseData;
		parameters.collapseInIdArray = collapseInIdArray;
		parameters.glyphiconMinusIdArray = glyphiconMinusIdArray;
		parameterStorage.setData('rapDataController', parameters);
	});
	
	$scope.onParameterTablePlusClick = function(parentId) {
		
		var parentAttribute = '[parent="{{parent}}"]'.replace('{{parent}}', parentId);
		var elements = angular.element(document.querySelectorAll(parentAttribute));
		
		// 同一層的tr
		for(i=0; i<elements.length; i++) {
			
			var glyphicon = document.getElementById(parentId + '.glyphicon');
			
			if(elements[i].style.display=='none') {
				elements[i].style.display = '';
				glyphicon.className = 'glyphicon glyphicon-minus';
				
				if(elements[i].getAttribute('hasNext')=='true') {
					$scope.showParameterTableRow(elements[i].getAttribute('id'));
				}
				
			} else {
				elements[i].style.display = 'none';
				glyphicon.className = 'glyphicon glyphicon-plus';
				
				if(elements[i].getAttribute('hasNext')=='true') {
					$scope.hideParameterTableRow(elements[i].getAttribute('id'));
				}
			}
		}
	}
	
	$scope.showParameterTableRow = function(parentId) {
		
		var parentAttribute = '[parent="{{parent}}"]'.replace('{{parent}}', parentId);
		var elements = document.querySelectorAll(parentAttribute);
		
		elements.forEach(function(element) {
			
			var glyphicon = document.getElementById(parentId + '.glyphicon');
			
			if(glyphicon.className=='glyphicon glyphicon-minus') {
				element.style.display = '';
			}
			
			if(element.getAttribute('hasNext')=='true') {
				$scope.showParameterTableRow(element.getAttribute('id'));
			}
		});
	}	
	
	$scope.hideParameterTableRow = function(parentId) {
		
		var parentAttribute = '[parent="{{parent}}"]'.replace('{{parent}}', parentId);
		var elements = document.querySelectorAll(parentAttribute);
		
		elements.forEach(function(element) {
			element.style.display = 'none';
			if(element.getAttribute('hasNext')=='true') {
				$scope.hideParameterTableRow(element.getAttribute('id'));
			}
		});
	}

	$scope.baseTableTemplate = 
		'<tr id="{{id}}" style="display:{{display}};" parent={{parent}} hasNext={{hasNext}}>' +
			'{{td}}' +
			'<td class="col-md-3">{{parameter.identifier}}</td>' +
			'<td class="col-md-3">{{parameter.name}}</td>' +
			'<td class="col-md-3">{{parameter.dataType}}</td>' +
			'<td class="col-md-2">{{parameter.remark}}</td>' +
		'</tr>';
	
	$scope.tdTemplate = 
		'<td class="col-md-1"></td>';
	
	$scope.subParameterTdTemplate = 
		'<td class="col-md-1" ng-click="onParameterTablePlusClick(\'{{id}}\');">' +
			'<span id="{{id}}.glyphicon" class="glyphicon glyphicon-plus"></span>' +
		'</td>';
	
	$scope.createParameterTable = function(parameterList, layer, parentId) {
		
		var display = 'none';
		if(layer==0) {
			display = '';
		}
		
		var space = '';
		for(i=0; i<layer; i++) { 
			space = space + '&nbsp;&nbsp;&nbsp;&nbsp;'
		}

		var html;
        parameterList.forEach(function(parameter) {
        	
        	var id = parentId + '.' + $scope.escapeHtml(parameter.identifier)
        	
        	html = html + $scope.baseTableTemplate
    					  .replace(new RegExp('{{id}}', 'g'), id)
    					  .replace('{{parent}}', parentId)
    					  .replace('{{display}}', display)
    					  .replace('{{hasNext}}', parameter.hasNext)
				  		  .replace('{{parameter.identifier}}', space + $scope.escapeHtml(parameter.identifier))
				  		  .replace('{{parameter.name}}', $scope.escapeHtml(parameter.name))
				  		  .replace('{{parameter.dataType}}', $scope.escapeHtml(parameter.dataType))
				  		  .replace('{{parameter.remark}}', $scope.escapeHtml(parameter.remark));
        	
    		if(parameter.hasNext) {
    	
    			var td = $scope.subParameterTdTemplate.replace(new RegExp('{{id}}', 'g'), id);
    			html = html.replace('{{td}}', td);
    			html = html + $scope.createParameterTable(parameter.parameterList, ++layer, id);
    		} else {
    			
    			var td = $scope.tdTemplate;
    			html = html.replace('{{td}}', td);
    		}
		});
		
		return html;
	}
	
	$scope.escapeHtml = function(unsafe) {
		return unsafe.replace(/&/g, "&amp;")
					 .replace(/</g, "&lt;")
					 .replace(/>/g, "&gt;")
					 .replace(/"/g, "&quot;")
					 .replace(/'/g, "&#039;");
	 }
}]);

app.directive('dynamic', function ($compile) {
	return {
		restrict: 'A',
		replace: true,
		link: function (scope, element, attrs) {
			scope.$watch(attrs.dynamic, function(html) {
				
		        var html;
				
		        var id = scope.$eval(attrs.dwservice);
				var parameterList = scope.$eval(attrs.list);
				if(parameterList) {
			        html = scope.createParameterTable(parameterList, 0, id);
				}
				
				element.html(html);
				$compile(element.contents())(scope);
			});
		}
	};
});