﻿angular.module('app')
.service('DWMessage', ["$http", "$q", '$filter', '$mdToast', function($http, $q, $filter, $mdToast) {
	
	this.$http = $http;
	this.$q = $q;

	/**
	 * 顯示提示信息 - 2016-12-4 falcon 有時間再改 code 了 (tips 改 info, info 改 success)
	 */
	this.showTips = function(message) {

		this.showMessage(message, 'info');
	}
	this.showInfo = function(message) {
		
		this.showMessage(message, 'success');
	}
	this.showWarning = function(message) {
		
		this.showMessage(message, 'warning');
	}
	this.showError = function(message) {
		
		this.showMessage(message, 'danger');
	}
	
	// toastr testing url -> http://codeseven.github.io/toastr/demo.html
    toastr.options = {
	  "closeButton": true,
	  "debug": false,
	  "newestOnTop": true,
	  "progressBar": false,
	  "positionClass": "toast-top-right",
	  "preventDuplicates": false,
	  "onclick": null,
	  "showDuration": "300",
	  "hideDuration": "1000",
	  "timeOut": "5000",
	  "extendedTimeOut": "5000",
	  "showEasing": "swing",
	  "hideEasing": "linear",
	  "showMethod": "fadeIn",
	  "hideMethod": "fadeOut"
  	};
	this.showMessage = function (message, messageType) {
		
		var timeInfo = $filter('date')(new Date(), 'HH:mm:ss');
		var displayMessage = "[" + timeInfo + "] " + message;
		
		if (!messageType) {
			
			messageType = "success";
		}
		
		// bootstrapGrowl show message
		// 搭配 index.xml 用 jquery 1.11.1
//        $.bootstrapGrowl(displayMessage, {
//        	allow_dismiss: false,
//        	url_target: '_blank',
//            type: messageType,
//            delay: 20000,
//        });
        
        // toastr show message (type error is 'error' not 'danger')
        toastr[messageType == 'danger' ? 'error': messageType](displayMessage);

        // $mdToast show message
//		$mdToast.show(
//	            $mdToast.simple()
//	               .textContent(displayMessage)
//	               .hideDelay(1000)
//	         );
	}
	
}]);