﻿angular.module('app')
.service('DWService', ["$http", "$q", "DWMessage", "settingService", 'testcenterClientService',
                       function($http, $q, DWMessage, settingService, testcenterClientService) {
	
	this.$http = $http;
	this.$q = $q;
	this.currentServiceMode = 0;
	this.serverInfo = null;
	
	// methods
	
	/**
	 * 2017-10-3 falcon
	 * 切換服務模式 
	 */
	this.switchServiceMode = function(owner, serviceMode) {
		
		if (serviceMode === 0) {

			this.dwModuleInfoList = this.moduleInfoStorage["DWService"];
		}
		else if (serviceMode === 1) {
			
			this.dwModuleInfoList = this.moduleInfoStorage["DWService.ResourceMapping"];
		}
		else if (serviceMode === 2) {
			
			this.dwModuleInfoList = this.moduleInfoStorage["DWService.StandardRestful"];
		}
		else if (serviceMode === 3) {
			
			this.dwModuleInfoList = this.moduleInfoStorage["DWService.EAI"];
		}
		
		owner.currentModule = null;
		owner.currentService = null;
		owner.currentMethod = null;
		
		this.currentServiceMode = serviceMode;
	}
	
	/**
	 * 取得當前的服務模式
	 */
	this.getCurrentServiceMode = function() {
		
		return this.currentServiceMode;
	}
	
	/**
	 * 2016-11-29 falcon 調用 rap 服務查詢 mock 資料
	 * @param rapIpPort RAP IP & Port
	 * @param rapProjectId RAP 專案編號
	 */
	this.invokeRapService = function(rapIpPort, projectId) {
		
		var url;
		
		if (rapIpPort) {
			
			url = rapIpPort;
		}
		else {
			url = "http://10.40.41.222:8081/";
		}
		
		var queryPath = "api/queryRAPModel.do";
		var queryString = "?projectId=";
		
		if (projectId) {
			
			queryString += projectId;
		}

		queryString += "&callback=JSON_CALLBACK";
		
		var finalUrl = url + queryPath + queryString;
		
		return $http.jsonp(finalUrl);
		
		// 要加上 callback=JSON_CALLBACK 才會進入到成功區會
		//return $http.jsonp("http://10.40.41.222:8081/api/queryRAPModel.do?projectId=4&callback=JSON_CALLBACK");
	}
	
	/**
	 * 取得 RAP Mock 數據
	 * @param serviceCommand 服務命令
	 */
	this.retrieveRapMockData = function(serviceCommand) {
		// ex.
		// http://10.40.41.222:8081/MOCKJS/4/FEG/IHelloService/sayHello
		
		var rapIpPort = settingService.setting.unitTest.rapIpPort;
		var rapProjectId = settingService.setting.unitTest.rapProjectId;
		
		var moduleName = serviceCommand.moduleName;
		var serviceName = serviceCommand.serviceName;
		var methodName = serviceCommand.methodName;
		
		var url = rapIpPort + "MOCKJSDATA" +
			"/" + rapProjectId +
			"/" + moduleName +
			"/" + serviceName +
			"/" + methodName;

		var def = this.$q.defer();
		var queryString = "";//"&callback=JSON_CALLBACK";
		var finalUrl = url + queryString;
		
		$http.get(finalUrl).then(
			function(response) {
				
				var wrapper = new RapMockDataServiceResultWrapper(response);
				if (wrapper.isNotFound()) {
					
					def.reject(wrapper);
				}
				else {

					def.resolve(wrapper);
				}
			},
			function(response) {
				
				var wrapper = new RapMockDataServiceResultWrapper(response);
				def.reject(wrapper);
			}
		);

		return def.promise;
	}
	
	// 2018-7-24 falcon 取消請求功能
	this.cancellationRequestIdMap = {};
	this.cancelInvoke = function (requestUuid) {

		if (!requestUuid) return;

		this.cancellationRequestIdMap[requestUuid] = true;
	}
	
	this.invokeViaServer = function(serviceInfo) {
		
		this.$http.defaults.headers.post["Accept"] = "*/*";
		this.$http.defaults.headers.post["Content-Type"] = "application/json";

		var httpMethod = "POST";
		
		var port = testcenterClientService.getServerPort();
		var proxyUrl = "http://localhost:" + port + "/testcenter/proxy/";

		var request = {method: httpMethod,
					   url: proxyUrl,
					   data: JSON.stringify(serviceInfo)};

		var def = $q.defer();
		
		$http(request).then(
			function(response) { // successs
				
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);

				def.resolve(dwServiceResultWrapper);
			},
			
			function(response) { // failure
				
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);
				if (dwServiceResultWrapper.isConnectionError()) {
					
					DWMessage.showError("無法連接服務器!");
				}
				
				def.reject(dwServiceResultWrapper);
			}
		);
		
		return def.promise;
	}
	
	/**
	 * 調用服務
	 * @param serviceInfo 服務信息
	 */
	this.invoke = function (serviceInfo) {
		
		// 2019-2-27 falcon 關閉檢查 hostname, 傳至 java 端調用
		if (settingService.setting.security && settingService.setting.security.disableHostnameChecking) {
			
			return this.invokeViaServer(serviceInfo);
		}

		this.$http.defaults.headers.post["Accept"] = "*/*";
		this.$http.defaults.headers.post["Content-Type"] = "application/json";

		var httpMethod = serviceInfo.httpMethod;
		var serviceUrl = serviceInfo.url;
		var parameterObject = this.getParameterObject(serviceInfo);
		
		if (httpMethod && httpMethod.toLowerCase() === "get") {
			
			var queryString = this.getQueryString(serviceInfo);
			if (queryString != null) {
				
				serviceUrl += "?" + queryString;
			}
		}
	
		var isFormData = parameterObject instanceof FormData;
		if (isFormData) {

			return this.invokeWithFormData(serviceUrl, serviceInfo.headers, parameterObject);
		}
		
		var headerObject = this.convertToObject(serviceInfo.headers);
		
		var def = this.$q.defer();
		
		var service = this;
		var requestUuid = serviceInfo.requestUuid;

		this.$http({
			url: serviceUrl,
			method: httpMethod,
			headers : headerObject,
			data: JSON.stringify(parameterObject) //angular.element.param(parameter)
		}).then(
			function(response) { // successs
				
				// 2018-7-24 falcon 取消請求功能
				if (requestUuid && service.cancellationRequestIdMap[requestUuid]) {
					
					delete service.cancellationRequestIdMap[requestUuid];
					return;
				}

				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);

				def.resolve(dwServiceResultWrapper);
			},
			
			function(response) { // failure
				
				// 2018-7-24 falcon 取消請求功能
				if (requestUuid && service.cancellationRequestIdMap[requestUuid]) {
					
					delete service.cancellationRequestIdMap[requestUuid];
					return;
				}
				
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);
				if (dwServiceResultWrapper.isConnectionError()) {
					
					DWMessage.showError("無法連接服務器!");
				}
				
				def.reject(dwServiceResultWrapper);
			}
		);
		
		return def.promise;
	}
	
	/**
	 * 使用 FormData 進行調用
	 * @param serviceUrl 服務 URL
	 * @param headers Header 清單
	 * @param formData 表單資料
	 */
	this.invokeWithFormData = function(serviceUrl, headers, formData) {
		
		var def = this.$q.defer();
		
		var controller = this;
		var xhr = new XMLHttpRequest();
		xhr.open("post", serviceUrl, true);
		
		var header;
		for (var headerIndex in headers) {
			
			header = headers[headerIndex];
			xhr.setRequestHeader(header.name, header.value);
		}
            
		// send
		xhr.onload = function (response) {

			var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);
			if (xhr.status === 200) {
				
				def.resolve(dwServiceResultWrapper);
			} else {

				def.reject(dwServiceResultWrapper);
			}
		};

		xhr.send(formData);
	
		/*		$http.post(
			this.sendingInfo.serviceUrl,
			parameterObject,
			{
				transformRequest: angular.identity,
				headers: {'Content-Type': 'multipart/form-data'}
			})
			.success(function(response){
				alert('done!');
			})
			.error(function(response){
				alert('failed!');
			});*/
		
		return def.promise;
	}
	
	/**
	 * 2018-5-21 falcon 調用資源服務
	 * @param resourceInfo 資源信息
	 */
	this.invokeResourceService = function(resourceInfo) {
		
		this.$http.defaults.headers.post["Accept"] = "*/*";
		this.$http.defaults.headers.post["Content-Type"] = "application/json";

		var httpMethod = "POST";
		
		var port = testcenterClientService.getServerPort();
		var resourceUrl = "http://localhost:" + port + "/testcenter/rs/" + resourceInfo.name;
		var parameterObject = this.getParameterObject(resourceInfo);
		var headerObject = this.convertToObject(resourceInfo.headers);

		var request = {method: httpMethod,
					   url: resourceUrl,
					   headers: headerObject,
					   data: JSON.stringify(parameterObject)};

		var def = $q.defer();
		
		$http(request).then(
			function(response) { // successs
				
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);

				def.resolve(dwServiceResultWrapper);
			},
			
			function(response) { // failure
				
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);
				if (dwServiceResultWrapper.isConnectionError()) {
					
					DWMessage.showError("無法連接服務器!");
				}
				
				def.reject(dwServiceResultWrapper);
			}
		);
		
		return def.promise;
	}
	
	/**
	 * 轉換為物件
	 * @parameterList 參數清單
	 */
	this.convertToObject = function(parameterList) {
		
		var propertyOwner = {};
		var name, value;
		for (var i in parameterList) {
			name = parameterList[i].name
			value = parameterList[i].value;
				
			propertyOwner[name] = value;
		}
		
		return propertyOwner;
	}
	
	/**
	 * 處理參數物件
	 */
	this.getParameterObject = function(serviceInfo) {
			
		// upload files
		if (serviceInfo.uploadFiles && serviceInfo.uploadFiles.length > 0) {

			var formData = new FormData();
			
			// 2016-1-5 falcon 其他非上傳檔案的參數統一放置在 $parameters key 中 (後端處理也做對應修改)
			var parametersObject = this.convertToObject(serviceInfo.parameters);
			
			// 2019-5-7 falcon 臨時解法, 新版 DAP 沒有去掉 $parameters, 此處判斷沒參數就不傳 $parameters
			if (serviceInfo.parameters.length > 0) {

				var stringifyValue = JSON.stringify(parametersObject);
				formData.append("$parameters", stringifyValue);
			}
			
			var filesObject = this.convertToObject(serviceInfo.uploadFiles);
			for (var propertyName in filesObject) {
				formData.append(propertyName, filesObject[propertyName]);
			}

			return formData;
		}
		else {
			// normal parameters
			return this.convertToObject(serviceInfo.parameters);
		}
	}
	
	this.getQueryString = function(serviceInfo) {
		
		var queryString = serviceInfo.parameters.length > 0 ? "" : null;
		var parameter;
		for (var idx in serviceInfo.parameters) {
			
			parameter = serviceInfo.parameters[idx];

			if (idx > 0) {
				
				queryString += "&";
			}
			
			queryString += encodeURIComponent(parameter.name);
			queryString += "=";
			
			var stringValue = encodeURIComponent(parameter.value);

			queryString += stringValue;
		}

		return queryString;
	}

	// 取得模組信息相關 API
	/**
	 * Digiwin 模組信息清單是否已經初始化
	 */
	this.dwModuleInfoInitialized = false;
	
	/**
	 * Digiwin 模組信息清單
	 */
	this.dwModuleInfoList = [];

	/**
	 * 2017-10-3 falcon
	 * 模組信息儲存所
	 */
	this.moduleInfoStorage = {};

	/**
	 * 取得模組清單服務 URL
	 */
	this.getModuleListServiceUrl = function() {
		
		//getModuleListServiceUrl(); // global function in serviceList.js
		
		// get from user data
		
		var finalModuleListServiceUrl = "";
		
		if ($.isArray(settingService.setting.dwgatewayUrls) && settingService.setting.dwgatewayUrls.length > 0) {

			var defaultDwgatewayUrl = settingService.defaultDwgatewayUrl;
			
			if (settingService.setting.moduleListServiceUrl)
				finalModuleListServiceUrl = defaultDwgatewayUrl + settingService.setting.moduleListServiceUrl;
		}
		
		return finalModuleListServiceUrl;
	}

	/**
	 * 2021-5-26 falcon
	 * 初始化服務模式信息
	 * @param serviceInfoList 服務信息清單, RequestHelper ModuleInfoService getModuleInfos 方法返回的　List<ModuleInfo>
	 */
	this.initServiceModeInfo = function(serviceInfoList) {
		
		var moduleInfo;
		var dwserviceList = [];
		var standardRestfulList = [];
		var eaiList = [];
		for (moduleIdx in serviceInfoList) {
			
			moduleInfo = serviceInfoList[moduleIdx];
			if (moduleInfo.type === '2') {
				
				standardRestfulList.push(moduleInfo);
			}
			else if (moduleInfo.type === '3') {
				
				eaiList.push(moduleInfo);
			}
			else {
				
				dwserviceList.push(moduleInfo);
			}
		}
		
		// 放置儲存所
		this.moduleInfoStorage["DWService"] = dwserviceList;
		this.moduleInfoStorage["DWService.StandardRestful"] = standardRestfulList;
		this.moduleInfoStorage["DWService.EAI"] = eaiList;
	}
	
	/**
	 * 2018-5-17 falcon
	 * 初始化資源映射信息
	 */
	this.initResourceMappingInfo = function() {
		
		try {

			// 2019-5-15 falcon 服務信息統計資料
			var serviceStatistics = {};
			this.moduleInfoStorage["DWService.Statistics"]
			serviceStatistics.modules = [];
			
			var resourceMappingInfoList = [];
			var moduleInfo, serviceInfo;
			var rmModuleInfo, resourceInfo;
			for (moduleIdx in this.dwModuleInfoList) {
				
				moduleInfo = this.dwModuleInfoList[moduleIdx];
				rmModuleInfo = {};
				rmModuleInfo.name = moduleInfo.name;
				rmModuleInfo.serviceList = [];
				
				// 紀錄每一個模組的服務總數
				serviceStatistics.modules[rmModuleInfo.name] = {};
				serviceStatistics.modules[rmModuleInfo.name].services = moduleInfo.serviceList.length;
				serviceStatistics.modules[rmModuleInfo.name].methods = 0;
				serviceStatistics.modules[rmModuleInfo.name].invalidMethodList = [];
				serviceStatistics.modules[rmModuleInfo.name].invalidMethodCount = 0; // 不符合 restful 操作的方法總數
				serviceStatistics.modules[rmModuleInfo.name].prsCount = 0;	// 主資源數量
				serviceStatistics.modules[rmModuleInfo.name].prsWithNoAnyActionCount = 0;
				
				for (srvIdx in moduleInfo.serviceList) {
					
					serviceInfo = moduleInfo.serviceList[srvIdx];
					this.buildResourceMappingInfo(rmModuleInfo, serviceInfo);
					
					// 加總模組的方法總數
					serviceStatistics.modules[rmModuleInfo.name].methods += serviceInfo.methodList.length;
				}
				
				// 紀錄資源總數
				serviceStatistics.modules[rmModuleInfo.name].resources = rmModuleInfo.serviceList.length;
				
				// 計算沒有任何操作的主資源總數
				var prsCount = 0;
				var prsWithNoAnyActionCount = 0; // prs = primary resource
				var rsInfo;
				for (rsIndex in rmModuleInfo.serviceList) {
					
					rsInfo = rmModuleInfo.serviceList[rsIndex];
					if (rsInfo.name.indexOf("/") == -1) { // 主資源名稱中不會有斜線
						prsCount++;
						
						// 只有主資源才有不合法的方法數量
						serviceStatistics.modules[rmModuleInfo.name].invalidMethodCount += rsInfo.invalidMethodList.length;
						serviceStatistics.modules[rmModuleInfo.name].invalidMethodList =
								serviceStatistics.modules[rmModuleInfo.name].invalidMethodList.concat(rsInfo.invalidMethodList);
					}
					if (rsInfo.methodList.length == 0) prsWithNoAnyActionCount++;
				}
				serviceStatistics.modules[rmModuleInfo.name].prsCount += prsCount;
				serviceStatistics.modules[rmModuleInfo.name].prsWithNoAnyActionCount += prsWithNoAnyActionCount;
				
				resourceMappingInfoList.push(rmModuleInfo);
			}
			
			// 放置儲存所
			this.moduleInfoStorage["DWService.ResourceMapping"] = resourceMappingInfoList;
		}
		catch(e) {
			
			DWMessage.showError("解析模組信息明細清單失敗!");
		}
	}
	
	/**
	 * 2018-5-17 falcon 建置資源映射信息
	 * @param rmModuleInfo 資源映射模組信息
	 * @param serviceInfo 服務信息
	 * @return 資源信息
	 */
	this.buildResourceMappingInfo = function(rmModuleInfo, serviceInfo) {
		
		if (!serviceInfo) return null;
		
		var name = serviceInfo.name;
		var resourceName;
		var resourceInfo = {};
		if (name.startsWith("I") && name.endsWith("Service")) {
			
			resourceName = name.substring(1, name.length - 7);
			resourceInfo.name = resourceName;
			
			this.buildResourceInfo(rmModuleInfo, resourceInfo, serviceInfo);
		}
		
		return null;
	}
	
	/**
	 * 建置資源信息
	 * @param rmModuleInfo 資源映射模組信息
	 * @param resourceInfo 資源信息
	 * @param serviceInfo 服務信息
	 */
	this.buildResourceInfo = function(rmModuleInfo, resourceInfo, serviceInfo) {
		
		var method, methodName;
		var httpMethodName, httpMethodInfo;
		var subResourceName, subResourceInfo;
		var subResourceQualifiedName;
		var targetResourceInfo;
		
		resourceInfo.methodList = [];
		resourceInfo.invalidMethodList = [];
		resourceInfo.subResourceList = [];
		var subResourceInfoList = [];
		
		rmModuleInfo.serviceList.push(resourceInfo);
		
		for (methodIdx in serviceInfo.methodList) {
			
			method = serviceInfo.methodList[methodIdx];
			methodName = method.name;
			
			if (methodName.startsWith("put")) {
				
				httpMethodName = "put";
			}
			else if (methodName.startsWith("post")) {
				
				httpMethodName = "post";
			}
			else if (methodName.startsWith("delete")) {
	
				httpMethodName = "delete";
			}
			else if (methodName.startsWith("get")) {
	
				httpMethodName = "get";
			}
			else {
				
				httpMethodName = null;
				
				// 紀錄不符合 restful 動作的方法
				resourceInfo.invalidMethodList.push(serviceInfo.name + "." + methodName);
			}
			
			if (httpMethodName != null) {
				
				if (methodName.length > httpMethodName.length) {
			
					targetResourceInfo = null;
					subResourceName = methodName.substring(httpMethodName.length);
					subResourceQualifiedName = resourceInfo.name + "/" + subResourceName;
					for (var subResourceInfoIdx in subResourceInfoList) {
						
						if (subResourceInfoList[subResourceInfoIdx].name == subResourceQualifiedName) {
							
							targetResourceInfo = subResourceInfoList[subResourceInfoIdx];
							break;
						}
					}
					
					if (targetResourceInfo == null) {

						targetResourceInfo = {};
						targetResourceInfo.name = subResourceQualifiedName;
						targetResourceInfo.methodList = [];
					
						rmModuleInfo.serviceList.push(targetResourceInfo);
						subResourceInfoList.push(targetResourceInfo);
					}
				}
				else {
					
					targetResourceInfo = resourceInfo;
				}

				httpMethodInfo = this.cloneResourceHttpMethodInfo(method, httpMethodName);
				targetResourceInfo.methodList.push(httpMethodInfo);
			}
		}
	}
	
	/**
	 * 2018-5-17 falcon
	 * 克隆資源 HTTP 方法信息
	 * @param method 服務方法
	 * @param httpMethodName HTTP 方法名稱
	 * @return 資源方法
	 */
	this.cloneResourceHttpMethodInfo = function(method, httpMethodName) {
		
		var httpMethod = {};
		
		for (var property in method) {

			httpMethod[property] = method[property];
		}
		
		httpMethod.name = httpMethodName;
		httpMethod.method = httpMethodName;
		httpMethod.displayName = httpMethodName;
		
		return httpMethod;
	}
	
	/**
	 * 取得 Digiwin 模組信息清單
	 * @param refresh 強制刷新
	 */
	this.initDWModuleInfoList = function(refresh) {
		
		if (!refresh && this.dwModuleInfoInitialized) return;
		
		this.dwModuleInfoInitialized = true;
		
		var service = this;

		var moduleInfoServiceUrl = this.getModuleListServiceUrl();
		if (moduleInfoServiceUrl) {

			var queryModuleServiceInfo = {};
			queryModuleServiceInfo.url = moduleInfoServiceUrl;
			queryModuleServiceInfo.httpMethod = "POST";

			// 2020-11-24 falcon router key
			if (settingService.setting.routerKey) {
				
				var routerKey = { "name":"routerKey", "value":settingService.setting.routerKey };
				queryModuleServiceInfo.headers = [];
				queryModuleServiceInfo.headers[0] = routerKey;
			}
			
			this.invoke(queryModuleServiceInfo).then(
				
				function(serviceResult) { // success
					
					var moduleInfoResult;
					var responseResult = serviceResult.getResult();
					
					if (Array.isArray(responseResult)) {
					
						moduleInfoResult = responseResult;
						service.serverInfo = {};
						service.serverInfo.version = "Unknown!";
					}
					else {
						
						moduleInfoResult = responseResult.data;
						service.serverInfo = responseResult.infos;
					}
					
					service.initServiceModeInfo(moduleInfoResult);
					
					// update ui modeule info list
					service.dwModuleInfoList = service.moduleInfoStorage["DWService"];
					
					DWMessage.showInfo("載入模組信息.");
					
					// 2018/5/17 falcon 初始化資源映射信息
					service.initResourceMappingInfo();
				},
				function(serviceResult) { // failure

					DWMessage.showWarning("查詢模組信息失敗!");
					if (serviceResult.isServiceNotFound()) {
						
						DWMessage.showWarning("請檢查模組微服務的設定是否正確!");
					}
				}
			);
		}
		else {
			
			DWMessage.showWarning("尚未設定模組信息微服務.");
			
			// 2016-12-3 是否支持讀本地設定? 因為目標 DWGateway 可能沒佈署 模組信息微服務?
			// solution 可先連至測試機(有此微服務) 匯出 module info data, 存於本地.
			// this.dwModuleInfoList = getModuleObjects();
		}
	}
	
	// 2016-11-29 falcon 調用 RAP 查詢接口信息
//	var controller = this;
//	this.invokeRapService().then(
//			function(response) {
//				
//				var wrapper = new DWRapModelWrapper(response);
//				controller.dwModuleInfoList = wrapper.dwModuleInfoList;
//			}
//	);
	
	/**
	 * 模組名稱改變事件
	 * @param owner 擁有者
	 * @param newModuleName 新的值(模組名稱)
	 */
	this.onModuleNameChanged = function(owner, newModuleName) {
			
		owner.currentModule = null;
		for (moduleIdx in this.dwModuleInfoList) {
			
			if (this.dwModuleInfoList[moduleIdx].name === newModuleName) {
				owner.currentModule = this.dwModuleInfoList[moduleIdx];
				break;
			}
		}
	}
	
	/**
	 * 服務名稱改變事件
	 * @param owner 擁有者
	 * @param newServiceName 新的值(服務名稱)
	 */
	this.onServiceNameChanged = function(owner, newServiceName) {
		
		if (owner.currentModule == null) {
			
			return;
		}

		owner.currentService = { "methodList" : [] };
		for (srvIdx in owner.currentModule.serviceList) {
			
			if (owner.currentModule.serviceList[srvIdx].name === newServiceName) {
				owner.currentService = owner.currentModule.serviceList[srvIdx];
				break;
			}
		}
	}
	
	/**
	 * 方法名稱改變事件
	 * @param owner 擁有者
	 * @param newMethodName 新的值(方法名稱)
	 */
	this.onMethodNameChanged = function(owner, newMethodName) {
		
		if (owner.currentService == null) {
			
			return;
		}
		
		owner.currentMethod = null;
		for (methodIdx in owner.currentService.methodList) {
				
			if (owner.currentService.methodList[methodIdx].method === newMethodName) {

				owner.currentMethod = owner.currentService.methodList[methodIdx];
				break;
			}
		}
	}

	this.jsonViewers = [];
	/***** jquery.json-viewer.js 套件 *****/
	this.jsonViewers[0] = {};
	this.jsonViewers[0].name = "jquery.json-viewer";
	this.jsonViewers[0].render = function(id, jsonObject, options) {

		if (!options) {
			
			options = {
					collapsed: true,
					withQuotes: false,
					showPropertySeq: true
			};
		}
		
		var viewerObject = $('<div id="' + id + '"></div>')
		render(viewerObject[0], jsonObject, options);

		return viewerObject[0];
	};
	
	this.jsonViewers[0].collapse = function(baseDomId) {
		$("#" + baseDomId).find("a:not(.collapsed)").click();
	};
	this.jsonViewers[0].expand = function(baseDomId) {
		$("#" + baseDomId).find("a.json-toggle.collapsed").click();
	};
	this.jsonViewers[0].firstLayerExpand = function(baseDom) {
		
		var targetList = $(baseDom).children("a.json-toggle.collapsed");
		targetList.click();
		
		return targetList;
	}
	this.jsonViewers[0].layerExpand = function(baseDom, layer) {
		
		if (layer == 0) return;
		if (layer == 1) {
		
			this.firstLayerExpand(baseDom);
		}
		else {
			
			var currentLayer = 2;
			this.firstLayerExpand(baseDom);
			var currentLayerTargetList = $(baseDom).children("a.json-toggle");
			var currentLayerCollapsedTargetList;
			
			while (currentLayer <= layer) {

				// 未展開的清單
				currentLayerCollapsedTargetList = currentLayerTargetList.parents().children("ul,ol").children("li").children("a.json-toggle.collapsed");
				currentLayerCollapsedTargetList.click();
				
				// 全部的清單
				currentLayerTargetList = currentLayerTargetList.parents().children("ul,ol").children("li").children("a.json-toggle");
				
				if (currentLayerTargetList.length == 0) break;
				
				currentLayer++;
			}
		}
	}
	
	/***** json-formatter.js 套件 *****/
	this.jsonViewers[1] = {};
	this.jsonViewers[1].name = "json-formatter";
	this.jsonViewers[1].render = function(id, jsonObject, options) {

		// 把 animateOpen 設定為 false, 否則全部展開在遞迴時, 子項目還來不及建立出來
		var config = {
			    hoverPreviewEnabled: false,
			    hoverPreviewArrayCount: 100,
			    hoverPreviewFieldCount: 5,
			    animateOpen: false,
			    animateClose: true,
			    theme: null
			};
		var open = 0;
		var formatter = new JSONFormatter(jsonObject, open, config);

		var jsonViewer = formatter.render();
		jsonViewer.id = id;
		
		return jsonViewer;
	};
	this.jsonViewers[1].collapse = function(baseDomId) {
		var baseDom = $("#" + baseDomId);
		if (baseDom.length == 0) return;
		
		$(baseDom[0].parentElement).find("div.json-formatter-open>a>span.json-formatter-toggler").click();
	};
	this.jsonViewers[1].expand = function(baseDomId) {
		var baseDom = $("#" + baseDomId);
		if (baseDom.length == 0) return;
		
		// 此控件收起後,就已經移除子節點. 所以必須要循環點擊下去
		// $(baseDom[0].parentElement).find("div:not(.json-formatter-open)>a>span.json-formatter-toggler").click();
		
		this.loopExpand(baseDom[0]);
	};
	this.jsonViewers[1].loopExpand = function(singleDom) {
		
		var list = $(singleDom.parentElement).find("div:not(.json-formatter-open)>a>span.json-formatter-toggler");
		list.click();
		
		for (var i = 0; i < list.length; i++) {
			
			this.loopExpand(list[i].parentElement);
		}
	}
	this.jsonViewers[1].firstLayerExpand = function(baseDom) {
		
		// TODO 待實現
		var isOpen = $(baseDom).attr('class').split(/\s+/).includes("json-formatter-open");
		
		if (!isOpen) {
		
			$(baseDom).children("a.json-formatter-toggler-link").children("span.json-formatter-toggler").click();
		}
	}
	this.jsonViewers[1].layerExpand = function(baseDom, layer) {
		
		if (layer == 0) return;
		if (layer == 1) {
		
			this.firstLayerExpand(baseDom);
		}
		else {
			
			var currentLayer = 2;
			this.firstLayerExpand(baseDom);
			var currentLayerTargetList = $(baseDom).children("div.json-formatter-children").children("div.json-formatter-row");
			var currentLayerCollapsedTargetList;
			
			while (currentLayer <= layer) {

				// 未展開的清單
				currentLayerCollapsedTargetList = currentLayerTargetList.parents()
					.children("div:not(.json-formatter-open)")
					.children("a.json-formatter-toggler-link")
					.children("span.json-formatter-toggler");
				
				currentLayerCollapsedTargetList.click();
				
				// 全部的清單
				currentLayerTargetList = currentLayerTargetList.children("div.json-formatter-children").children("div.json-formatter-row");
				
				if (currentLayerTargetList.length == 0) break;
				
				currentLayer++;
			}
		}
	}
	
	this.jsonViewerAgent = {};
	
	var providerIndex = 0;
	this.jsonViewerAgent.provider = this.jsonViewers[0];

	this.jsonViewerAgent.render = function (id, jsonObject, options) {
		
		if (!options) {
			
			options = {
					collapsed: true,
					withQuotes: false,
					showPropertySeq: true
			};
		}

		var dom = this.provider.render(id, jsonObject, options);
		
		// 展開第一階
		var autoExpandLayer = 0;
		try {
			
			autoExpandLayer = parseInt(settingService.setting.jsonviewer.autoExpandLayer);
			this.provider.layerExpand(dom, autoExpandLayer);
		}
		catch (e) {
			
			// do nothing
		}

		return dom;
	}
	this.jsonViewerAgent.collapse = function(baseDomId) {
		this.provider.collapse(baseDomId);
	}
	this.jsonViewerAgent.expand = function(baseDomId) {
		this.provider.expand(baseDomId);
	}

	this.settingAfterLoadedlistener = function() {

		try {

			var type = settingService.setting.jsonviewer.type;
			this.jsonViewerAgent.provider = this.jsonViewers[type];
		}
		catch (e) {
			
			// do nothing
		}
	}
	
	// 2018-9-21 falcon MD5 method
	this.MD5 = function(d){result = M(V(Y(X(d),8*d.length)));return result.toLowerCase()};function M(d){for(var _,m="0123456789ABCDEF",f="",r=0;r<d.length;r++)_=d.charCodeAt(r),f+=m.charAt(_>>>4&15)+m.charAt(15&_);return f}function X(d){for(var _=Array(d.length>>2),m=0;m<_.length;m++)_[m]=0;for(m=0;m<8*d.length;m+=8)_[m>>5]|=(255&d.charCodeAt(m/8))<<m%32;return _}function V(d){for(var _="",m=0;m<32*d.length;m+=8)_+=String.fromCharCode(d[m>>5]>>>m%32&255);return _}function Y(d,_){d[_>>5]|=128<<_%32,d[14+(_+64>>>9<<4)]=_;for(var m=1732584193,f=-271733879,r=-1732584194,i=271733878,n=0;n<d.length;n+=16){var h=m,t=f,g=r,e=i;f=md5_ii(f=md5_ii(f=md5_ii(f=md5_ii(f=md5_hh(f=md5_hh(f=md5_hh(f=md5_hh(f=md5_gg(f=md5_gg(f=md5_gg(f=md5_gg(f=md5_ff(f=md5_ff(f=md5_ff(f=md5_ff(f,r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+0],7,-680876936),f,r,d[n+1],12,-389564586),m,f,d[n+2],17,606105819),i,m,d[n+3],22,-1044525330),r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+4],7,-176418897),f,r,d[n+5],12,1200080426),m,f,d[n+6],17,-1473231341),i,m,d[n+7],22,-45705983),r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+8],7,1770035416),f,r,d[n+9],12,-1958414417),m,f,d[n+10],17,-42063),i,m,d[n+11],22,-1990404162),r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+12],7,1804603682),f,r,d[n+13],12,-40341101),m,f,d[n+14],17,-1502002290),i,m,d[n+15],22,1236535329),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+1],5,-165796510),f,r,d[n+6],9,-1069501632),m,f,d[n+11],14,643717713),i,m,d[n+0],20,-373897302),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+5],5,-701558691),f,r,d[n+10],9,38016083),m,f,d[n+15],14,-660478335),i,m,d[n+4],20,-405537848),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+9],5,568446438),f,r,d[n+14],9,-1019803690),m,f,d[n+3],14,-187363961),i,m,d[n+8],20,1163531501),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+13],5,-1444681467),f,r,d[n+2],9,-51403784),m,f,d[n+7],14,1735328473),i,m,d[n+12],20,-1926607734),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+5],4,-378558),f,r,d[n+8],11,-2022574463),m,f,d[n+11],16,1839030562),i,m,d[n+14],23,-35309556),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+1],4,-1530992060),f,r,d[n+4],11,1272893353),m,f,d[n+7],16,-155497632),i,m,d[n+10],23,-1094730640),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+13],4,681279174),f,r,d[n+0],11,-358537222),m,f,d[n+3],16,-722521979),i,m,d[n+6],23,76029189),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+9],4,-640364487),f,r,d[n+12],11,-421815835),m,f,d[n+15],16,530742520),i,m,d[n+2],23,-995338651),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+0],6,-198630844),f,r,d[n+7],10,1126891415),m,f,d[n+14],15,-1416354905),i,m,d[n+5],21,-57434055),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+12],6,1700485571),f,r,d[n+3],10,-1894986606),m,f,d[n+10],15,-1051523),i,m,d[n+1],21,-2054922799),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+8],6,1873313359),f,r,d[n+15],10,-30611744),m,f,d[n+6],15,-1560198380),i,m,d[n+13],21,1309151649),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+4],6,-145523070),f,r,d[n+11],10,-1120210379),m,f,d[n+2],15,718787259),i,m,d[n+9],21,-343485551),m=safe_add(m,h),f=safe_add(f,t),r=safe_add(r,g),i=safe_add(i,e)}return Array(m,f,r,i)}function md5_cmn(d,_,m,f,r,i){return safe_add(bit_rol(safe_add(safe_add(_,d),safe_add(f,i)),r),m)}function md5_ff(d,_,m,f,r,i,n){return md5_cmn(_&m|~_&f,d,_,r,i,n)}function md5_gg(d,_,m,f,r,i,n){return md5_cmn(_&f|m&~f,d,_,r,i,n)}function md5_hh(d,_,m,f,r,i,n){return md5_cmn(_^m^f,d,_,r,i,n)}function md5_ii(d,_,m,f,r,i,n){return md5_cmn(m^(_|~f),d,_,r,i,n)}function safe_add(d,_){var m=(65535&d)+(65535&_);return(d>>16)+(_>>16)+(m>>16)<<16|65535&m}function bit_rol(d,_){return d<<_|d>>>32-_}
	
	// 註冊事件監聽設定加載後事件
	settingService.registerOnAfterLoadedListener(this.settingAfterLoadedlistener.bind(this));
}]);