angular.module('app')
.service('metadataService', ["$http", "$q", "DWMessage", function($http, $q, DWMessage) {
		
	this.$http = $http;
	this.$q = $q;
	
	this.connectDatabase = function (connectionInfo) {
		//alert(invokeInfo.url);
		//alert(invokeInfo.id);
		//alert(invokeInfo.password);
		var def = this.$q.defer();
		
		this.$http.defaults.headers.post["Accept"] = "*/*";
		this.$http.defaults.headers.post["Content-Type"] = "application/json";
		
		//var reqData = new FormData();
		//reqData.append("url", connectionInfo.url);
		//reqData.append("id", connectionInfo.id);
		//reqData.append("password", connectionInfo.password);
		//alert(connectionInfo.url);
		//alert(connectionInfo.id);
		//alert(connectionInfo.password);
		this.$http({
			url: "/testcenter/dwrequester/service/metadata/connectDatabase",
			method: "post",			
			data: JSON.stringify(connectionInfo)
		}).then(
			function(response) { // successs
								
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);

				def.resolve(dwServiceResultWrapper);
			},
			
			function(response) { // failure
											
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);							
				def.reject(dwServiceResultWrapper);
			}
		);
						
		return def.promise;
	}
	
	this.generateMetadata = function (selectedTables) {
		var def = this.$q.defer();
		
		this.$http.defaults.headers.post["Accept"] = "*/*";
		this.$http.defaults.headers.post["Content-Type"] = "application/json";
		
		this.$http({
			url: "/testcenter/dwrequester/service/metadata/generateMetadata",
			method: "post",			
			data: JSON.stringify(selectedTables)
		}).then(
			function(response) { // successs
								
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);

				def.resolve(dwServiceResultWrapper);
			},
			
			function(response) { // failure
											
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);							
				def.reject(dwServiceResultWrapper);
			}
		);
						
		return def.promise;
	}
	
	this.getColumnNames = function (tableName) {
		var def = this.$q.defer();
		
		this.$http.defaults.headers.post["Accept"] = "*/*";
		this.$http.defaults.headers.post["Content-Type"] = "application/json";
		
		this.$http({
			url: "/testcenter/dwrequester/service/metadata/getColumnNames",
			method: "post",			
			data: JSON.stringify(tableName)
		}).then(
			function(response) { // successs
								
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);

				def.resolve(dwServiceResultWrapper);
			},
			
			function(response) { // failure
											
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);							
				def.reject(dwServiceResultWrapper);
			}
		);
						
		return def.promise;
	}

	this.generateSQLs = function (metadatas) {
		var def = this.$q.defer();
		
		this.$http.defaults.headers.post["Accept"] = "*/*";
		this.$http.defaults.headers.post["Content-Type"] = "application/json";
		
		this.$http({
			url: "/testcenter/dwrequester/service/metadata/generateSQLs",
			method: "post",			
			data: JSON.stringify(metadatas)
		}).then(
			function(response) { // successs
								
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);

				def.resolve(dwServiceResultWrapper);
			},
			
			function(response) { // failure
											
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);							
				def.reject(dwServiceResultWrapper);
			}
		);
						
		return def.promise;
	}

	this.executeSQLs = function (sqls) {
		var def = this.$q.defer();
		
		this.$http.defaults.headers.post["Accept"] = "*/*";
		this.$http.defaults.headers.post["Content-Type"] = "application/json";
		
		this.$http({
			url: "/testcenter/dwrequester/service/metadata/executeSQLs",
			method: "post",			
			data: JSON.stringify(sqls)
		}).then(
			function(response) { // successs
								
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);

				def.resolve(dwServiceResultWrapper);
			},
			
			function(response) { // failure
											
				var dwServiceResultWrapper = new DWServiceResultWrapper(response, DWMessage);							
				def.reject(dwServiceResultWrapper);
			}
		);
						
		return def.promise;
	}
	
}]);