var app = angular.module('app');
app.service('DWResourceBundleService', function() {

    this.initialized = false;
    this.language = "zh_TW";
    this.defaultLanguage = "zh_TW";
    this.resources = {}

    this.getString = function(baseName, key) {
    	
    	if (!this.initialized) {
    		
    		this.initialized = true;	    	
	    	this.resources.caption = this.getCaptions();
    	}
  
    	var baseResource = this.resources[baseName];
    	if (baseResource == undefined) return "baseName [" + baseName + "] not found!";
    	
    	var i18nResource = baseResource[this.language];
    	if (i18nResource == undefined) {
    		
    		i18nResource = baseResource[this.defaultLanguage];
    		if (i18nResource == undefined) return "baseName [" + baseName + "][" + this.language + " ] not found!";
    	}
    	
    	var value = i18nResource[key];
    	if (value == undefined) return "key [" + key + "] not found!";
    	
    	return value;
    }
    
    this.getCaptions = function() {
    	
    	var captions ={};
    	
    	// zh_TW
    	var rs = captions["zh_TW"] = {};
    	rs.appName = "鼎捷 測試中心";
    	rs.pageRequest = "HTTP請求";
    	
    	
    	// zh_CN
    	rs = captions["zh_CN"] = {};
    	rs.appName = "鼎捷 测试中心";
    	rs.pageRequest = "HTTP请求";
    	
    	return captions;
    }
});