﻿/*{ "moduleName":"FEG", "serviceName":"IFarEastToneTelecomService", "methodName":"getDemoReportDataSource", "parameters":{ "parameters":null } }*/
/*{ "moduleName":"FEG", "serviceName":"IFarEastToneTelecomService", "methodName":"getCallDetailsReport", "parameters":null } */
var app = angular.module('app');

app.controller('DWUnitTesterCtrl', 
		function($scope,    $filter,          $mdDialog, 
				 $mdToast,  parameterStorage, DWMessage, 
				 DWService, DWSaveService,    settingService, 
				 testcenterClientService, loginService) {
	
	// unit tester ======================================================================================
	
	$scope.rapMockDataService = DWService;
	
	$scope.$on('$viewContentLoaded', function() {
		
		var pageData = parameterStorage.getData($scope.name);
		if(pageData) {

			$scope.setCurrentProject(pageData.currentProject);
			$scope.tempData = pageData.tempData;
		}
	});
  
	$scope.$on('$destroy', function() {

		var pageData = {};
		pageData.currentProject = $scope.currentProject;
		pageData.tempData = $scope.tempData;

		parameterStorage.setData($scope.name, pageData);
	});
	
	/**
	 * UI 綁定使用 (內部直接用 DWService)
	 */
	$scope.moduleRepository = DWService;
	
	$scope.currentProject = null;
	
	$scope.tempData = {};
	
	// 單元測試登錄信息
	$scope.tempData.loginInfo = {};
	$scope.tempData.loginInfo.login = false;
	$scope.tempData.loginInfo.userId = loginService.getUserId();
	$scope.tempData.loginInfo.userName = loginService.getUserName();
	$scope.tempData.loginInfo.password = null;
	
	// 2017-3-16 falcon 以後再想看看如何整合 ad login 再次驗證
	if ($scope.tempData.loginInfo.userId && $scope.tempData.loginInfo.userName) {
		
		$scope.tempData.loginInfo.login = true;
	} 

	// assertType list
	$scope.assertTypes = [];
	
	var assertType = {};
	assertType.script = "new DWScriptAssert()";
	assertType.name = DWScriptAssert.prototype.typeName;
	$scope.assertTypes.push(assertType);
	
	assertType = {};
	assertType.script = "new DWOutputAssert()";
	assertType.name = DWOutputAssert.prototype.typeName;
	$scope.assertTypes.push(assertType);
	
	assertType = {};
	assertType.script = "new DWRapDefaultOutputAssert()";
	assertType.name = DWRapDefaultOutputAssert.prototype.typeName;
	$scope.assertTypes.push(assertType);
	
	$scope.executor = new DWUnitTestExecutor();
	
	/**
	 * TODO 放這兒有點奇怪
	 * 登錄單元測試控制者
	 * @param DWService
	 * @param parentController 父控制者
	 * @param submitInfo 提交信息
	 */
	function showLoginUnitTestController($scope, $mdDialog, DWService, parentController, submitInfo) {
		
		// clone login info
		$scope.loginInfo = $.extend(true, {}, parentController.tempData.loginInfo);
		
		// 使用者沒有更改過就使用默認的設定值
		if (!$scope.loginInfo.userId && settingService.setting.unitTest.userId) {
			
			$scope.loginInfo.userId = settingService.setting.unitTest.userId;
		}

	    /**
	     * 取消事件
	     */
	    $scope.cancel = function() {

	    	$mdDialog.cancel();
	    };

	    /**
	     * 確認事件
	     */
	    $scope.ok = function() {

	    	var unitTestLoginServiceInfo = {};
	    	unitTestLoginServiceInfo.url = settingService.tempData.unitTest.unitTestLoginServiceUrl;
	    	
	    	var parameterList = [];
	    	parameterList[0] = { "name":"userId", "value": $scope.loginInfo.userId };
	    	parameterList[1] = { "name":"password", "value": $scope.loginInfo.password };
	    	
	    	unitTestLoginServiceInfo.parameters = parameterList;

	    	DWService.invoke(unitTestLoginServiceInfo).then(
	    		function(serviceResult) { // success
	    			
	    			var userData = serviceResult.getResult();
	    			if (!userData) {
	    				
	    				DWMessage.showError("輸入帳號或密碼不正確!");
	    			}
	    			else {

	    				$scope.loginInfo.userName = userData.name ? userData.name : userData.id;
	    				$scope.loginInfo.login = true; // 登錄成功
	    				
	    				$mdDialog.hide($scope.loginInfo);
	    			}
	    		},
	    		function(serviceResult) { // failure
	    			
	    			if (serviceResult.isServiceNotFound()) {
	    				
	    				DWMessage.showError("內建的單元測試登錄微服務信息有誤, 請聯絡管理員!");
	    			}
	    			else if (serviceResult.isConnectionError()) {
	    				
	    				DWMessage.showError("無法連接默認的 Dwgateway 伺服器!");
	    			}
	    			else {
	    				
	    				var data = serviceResult.getResult();
	    				var alert = $mdDialog.alert()
	    						.title('錯誤')
	    						.content(data)
	    						.ok('確定');
	    				
	    				$mdDialog.show(alert).then(
	    					function() { // ok
	    						
	    						// 調用 parent 再次彈出登錄框 ($mdDialog 不支持巢狀顯示)
	    						parentController.showLoginUnitTestDialog(submitInfo);
	    					}
	    				).finally(
	    					function() {

	    						alert = undefined;
	    					}
	    				);
	    			}
	    		}
	    	);
	    };
	}
	
	/**
	 * 顯示登錄單元測試對話框
	 */
	$scope.showLoginUnitTestDialog = function(uiEventOrSubmitRequired) {

		// 2017-3-16 falcon
		if (testcenterClientService.getServerType() == "web") {
			
			return;
		}
		
		var submitInfo = null;
		var forSubmit = false;
		var uiEvent = null;
		if (uiEventOrSubmitRequired && uiEventOrSubmitRequired.isSubmitRequired) {
			
			forSubmit = true;
			submitInfo = uiEventOrSubmitRequired;
		} 
		else {
			uiEvent = uiEventOrSubmitRequired;
		}

		var controller = this;

		var url = '/testcenter/views/dwrequester/html/dw-unit-test/loginUnitTestUserDialog.html';
		var templateUrl = testcenterClientService.convertUrl(url);

		$mdDialog.show(
			{
				controller: showLoginUnitTestController,
				templateUrl: templateUrl,
				parent: angular.element(document.body),
				targetEvent: uiEvent,
				clickOutsideToClose:true,
				fullscreen: true, // Only for -xs, -sm breakpoints.
				locals: {
					'parentController' : controller,
					'submitInfo' : submitInfo
				}
		    }).then(
		    	function(loginInfo) { // ok

		    	    setTimeout(function () {
		    	        $scope.$apply(function () {

		    	            $scope.tempData.loginInfo = loginInfo;
		    	            if (forSubmit) {

		    	    			$scope.submitTestReports(uiEventOrSubmitRequired.onlySelectedTestCase);
		    	            }
		    	        });
		    	    });
		    	},
		    	function() { // cancel
		    	}
		    );
	}
	
	/**
	 * TODO 放這兒有點奇怪
	 * 選取單元測試專案控制者
	 */
	function selectUnitTestProjectController($scope, $mdDialog, projects) {
		
		$scope.projects = projects;
		$scope.selectedProjectInfo = null;
		
		/**
		 * 選取事件
		 * @param projectInfo 專案信息
		 */
		$scope.onSelect = function(projectInfo) {

			$scope.selectedProjectInfo = projectInfo;
	    };

	    /**
	     * 取消事件
	     */
	    $scope.cancel = function() {

	    	$mdDialog.cancel();
	    };

	    /**
	     * 確認事件
	     */
	    $scope.ok = function() {

	    	if (!$scope.selectedProjectInfo) {
	    		
	    		return;
	    	}

	    	$mdDialog.hide($scope.selectedProjectInfo.name);
	    };
	}
	
	/**
	 * 顯示選取專案對話框
	 */
	$scope.showSelectProjectDialog = function(uiEvent) {
		
		var group = "unitTestProject";
		var extensionName = "utproj";
		var queryString = "extensionQuery=1";
		
		var controller = this;
		DWSaveService.getData(group, extensionName, queryString).then(
			function(userDataModel) {

				var project;
				var projectInfo;
				var projectInfoList = [];
				var projectList = userDataModel.getResult().datas;
				
				if (projectList.length == 0) {
				
					DWMessage.showWarning("沒有儲存的專案可以選擇!");
					return;
				}
				
				for (projectIdx in projectList) {
					
					project = projectList[projectIdx];
					projectInfo = {};
					projectInfo.name = project.name;
					projectInfo.description = project.description;
					
					projectInfoList[projectInfoList.length] = projectInfo;
				}
				
				var url = '/testcenter/views/dwrequester/html/dw-unit-test/selectUnitTestProjectDialog.html';
				var templateUrl = testcenterClientService.convertUrl(url);
				
				$mdDialog.show(
					{
						controller: selectUnitTestProjectController,
						templateUrl: templateUrl,
						parent: angular.element(document.body),
						targetEvent: uiEvent,
						clickOutsideToClose:true,
						fullscreen: true, // Only for -xs, -sm breakpoints.
						locals: {
							projects: projectInfoList
						}
				    }).then(
				    	function(selectedProjectName) { // ok

				    		controller.loadProject(selectedProjectName);
				    	},
				    	function() { // cancel
				    		// DO NOTHING
				    	}
				    );

			},
			function(userDataModel) {
			
				DWMessage.showError("開啟專案清單失敗!");
			}
		);
	}
	
	/**
	 * TODO 放這兒有點奇怪
	 * 編輯單元測試專案服務參數控制者
	 */
	function editTestCaseParameterController($scope, $mdDialog, parameterInfo) {
		
		$scope.parameterInfo = parameterInfo;
		$scope.checkBeforeOk = true;
		$scope.validJSONString = true;
		$scope.failedReason = null;

	    /**
	     * 取消事件
	     */
	    $scope.cancel = function() {

	    	$mdDialog.cancel();
	    };

	    /**
	     * 確認事件
	     */
	    $scope.ok = function() {
	    	
	    	if ($scope.checkBeforeOk) {
	    		
	    		$scope.validJSONString = $scope.checkJSONFormat();
	    		if (!$scope.validJSONString) return;
	    	}

	    	$mdDialog.hide($scope.parameterInfo.value);
	    };
	    
	    /**
	     * 檢查 JSON 格式
	     */
	    $scope.checkJSONFormat = function() {
	    	
	    	try {
	    		
	    		if ($scope.parameterInfo.value) {

	    			var jsonObject= JSON.parse($scope.parameterInfo.value);
	    		}
	    	}
	    	catch (e) {
	    		
	    		$scope.failedReason = e.message;
	    		return false;
	    	}
	    	
	    	return true;
	    }
	    
	    $scope.onRebuildJSON = function() {

    		var parameters = {};
	    	if (this.parameterInfo.methodInfo) {

	    		var parameterName;
	    		for (var idx in this.parameterInfo.methodInfo.parameters) {
	    			
	    			parameterName = this.parameterInfo.methodInfo.parameters[idx];
	    			parameters[parameterName] = null;
	    		}
	    	}
	    	
	    	var jsonString = JSON.stringify(parameters, null, "\t");
	    	
    		$scope.parameterInfo.value = jsonString;
	    }
	    
	    $scope.onKeydown = function(uiEvent) {

	    	if (uiEvent.keyCode && uiEvent.keyCode == 9) { // press tab 
	
	    		uiEvent.preventDefault();
	    		
	    		var target = uiEvent.target;
			    var start = target.selectionStart;
			    var end = target.selectionEnd;

			    // set textarea value to: text before caret + tab + text after caret
			    $(target).val($(target).val().substring(0, start)
			                + "\t"
			                + $(target).val().substring(end));

			    // put caret at right position again
			    target.selectionStart = start + 1;
			    target.selectionEnd = target.selectionStart;
	    	}
	    }
	}
	
	/**
	 * 顯示參數編輯框
	 * @param testCase 測試案例
	 */
	$scope.showParameterEditDialog = function(uiEvent, testCase) {
		
		var parameterInfo = {};
		parameterInfo.value = testCase.serviceCommand.parameters;
		parameterInfo.methodInfo = testCase.tempData.currentMethod;

		var url = '/testcenter/views/dwrequester/html/dw-unit-test/editTestCaseParameterDialog.html';
		var templateUrl = testcenterClientService.convertUrl(url);
		
		$mdDialog.show(
			{
				controller: editTestCaseParameterController,
				templateUrl: templateUrl,
				parent: angular.element(document.body),
				targetEvent: uiEvent,
				clickOutsideToClose:true,
				fullscreen: true, // Only for -xs, -sm breakpoints.
				locals: {
					'parameterInfo' : parameterInfo
				}
		    }).then(
		    	function(editResult) { // ok

		    		testCase.serviceCommand.parameters = editResult;
		    	},
		    	function() { // cancel
		    		// DO NOTHING
		    	}
		    );
	}
	
	/**
	 * TODO 放這兒有點奇怪
	 * 顯示 JSON 物件展示控制者
	 */
	function showJSONObjectDisplayController($scope, $mdDialog, DWService, jsonString) {
		
		$scope.jsonInfo = { 'value' : jsonString };

		$scope.initViewer = function() {
			try {

				var jsonViewer = DWService.jsonViewerAgent.render("jsonViewer", jsonString)
				jsonViewer.id = "jsonViewer";
				
				// 將 json viewer 加入到 container 中
				angular.element(document.querySelector('#jsonViewerContainer'))[0].appendChild(jsonViewer);
			}
			catch (ex) {
				
				alert('ex');
			}
		}
		
	    /**
	     * 取消事件
	     */
	    $scope.close = function() {

	    	$mdDialog.cancel();
	    };
	}
	
	/**
	 * 顯示 JSON 物件結構展示對話框
	 * @uiEvent UI 事件
	 * @testCase 測試案例
	 */
	$scope.showJSONObjectDisplayDialog = function(uiEvent, testCase) {

		var parameterInfo = {};
		parameterInfo.value = testCase.serviceCommand.parameters;
		parameterInfo.methodInfo = testCase.tempData.currentMethod;

		var jsonResult = testCase.testingResult.testingResult;

		var url = '/testcenter/views/dwrequester/html/dw-unit-test/jsonObjectDisplayDialog.html';
		var templateUrl = testcenterClientService.convertUrl(url);
		
		$mdDialog.show(
			{
				controller: showJSONObjectDisplayController,
				templateUrl: templateUrl,
				flex: '80',
				'flex-height': '80',
				parent: angular.element(document.body),
				targetEvent: uiEvent,
				clickOutsideToClose:true,
				fullscreen: true, // Only for -xs, -sm breakpoints.
				locals: {
					'jsonString' : jsonResult
				},
				
				onComplete : function(scope, element) {
					
					debugger;
					scope.initViewer();
				}
		    });
	}
	
	/**
	 * 讀取專案
	 * @param projectName = 專案名稱
	 */
	$scope.loadProject = function(projectName) {

		var group = "unitTestProject";
		var id = projectName + ".utproj";
		
		var controller = this;
		DWSaveService.getData(group, id).then(
			function(userDataModel) { //success
				
				try {
					var targetProject = userDataModel.getResult();
					
					// 還原繼承 DWUnitTestProject 和 DWTestCase !!!
					var projectClassInstance = new DWUnitTestProject();
					projectClassInstance.copy(targetProject);
					
					// 2017-1-4 falcon 重建上傳檔案選取器 dom
					controller.rebuildUploadFileSelectorDoms(projectClassInstance);
					
					// 設定為當前的專案
					var success = controller.setCurrentProject(projectClassInstance);
					if (success) {
						
						DWMessage.showInfo("專案 [ " + projectName + " ] 載入完畢.");
					}
				}
				catch (e) {
					
					var reason = "unknown.";
					if (e && e.message) {
						
						reason = e.message;
					}
					
					var errMsg = "讀取專案 [ " + projectName + " ] 失敗!" + "\r\n" +
						"原因: " + reason;
					
					DWMessage.showError(errMsg);
				}
			},
			function(userDataModel) { // failure
				
				if (userDataModel.isNotFound()) {
				
					DWMessage.showError("找不到專案 [ " + projectName + " ]!");
				}
				else {
					
					DWMessage.showError("讀取專案 [ " + projectName + " ] 失敗!");
				}
			}
		);
	}
	
	/**
	 * 校驗
	 * @return 成功或失敗
	 */
	$scope.validation = function() {
		
		if (!this.currentProject.name) {
			
			DWMessage.showError("專案名稱不可為空!");
			return false;
		}
		
		return true;
	}
	
	/**
	 * 保存專案
	 */
	$scope.saveProject = function() {
		
		if (!this.validation()) {
			
			DWMessage.showError("無法進行保存.");
			return;
		}

		var project = this.currentProject;
		
		var group = "unitTestProject";
		var id = project.name + ".utproj";

		// 複製初欲儲存的專案
		var cloneProject = $.extend(true, {}, project);
		var cloneTestCase;
		for (var testCaseIndex in cloneProject.testCases) {
			
			// 刪除測試案例的暫存資料
			cloneTestCase = cloneProject.testCases[testCaseIndex]
			delete cloneTestCase.tempData;
			
			// 只是要刪除 tempData 下的數據, 所以要把 tempData 加回去
			cloneTestCase.tempData = {};
		}

		DWSaveService.putData(group, id, cloneProject).then(
			function(result) {
				
				DWMessage.showInfo("專案 [ " + cloneProject.name + " ] 保存成功!");
			},
			function(error) {

				DWMessage.showError("專案 [ " + cloneProject.name + " ] 保存失敗!");
			}
		);
	}
	
	/**
	 * 產生金鑰
	 * @param event UI 事件
	 * @param testCase 測試案例
	 */
	$scope.generateToken = function(event, testCase) {
		
		// 固定金鑰
		if (this.currentProject.tokenInfo.fixedToken) {
			
			testCase.token = this.currentProject.tokenInfo.fixedToken;
			DWMessage.showTips("刷新完成");
			
			return;
		}
		
		var controller = this;
		DWService.invoke(this.currentProject.tokenInfo.serviceInfo).then(
			function(serviceResult) { // success;
				
				var token = serviceResult.getResult().token;

				// 更新測試案例的金鑰
				testCase.token = token;
				DWMessage.showTips("刷新完成");
			},
			function(serviceResult) { // failure;

				DWMessage.showError('取得金鑰失敗, 請檢查金鑰服務的正確性!');
			}
		);
	}
	
	/**
	 * 執行測試專案
	 */
	$scope.runTestProject = function() {

		this.executor.execute(this);

		var controller = this;
		
		// 固定金鑰
		if (this.currentProject.tokenInfo.fixedToken) {
			
			this.runTestProjectAfterGetToken(this.currentProject.tokenInfo.fixedToken);
		}
		// 查詢金鑰
		else {
			DWService.invoke(this.currentProject.tokenInfo.serviceInfo).then(
				function(serviceResult) { // success;
					
					var token = serviceResult.getResult().token;
					controller.runTestProjectAfterGetToken(token);
				},
				function(serviceResult) { // failure;

					DWMessage.showError('取得金鑰失敗, 請檢查金鑰服務的正確性!');
				}
			);
		}
	}
	
	/**
	 * 在取得金鑰後執行測試專案
	 * @param token 金鑰
	 */
	$scope.runTestProjectAfterGetToken = function(token) {

		for (var testCaseIndex in this.currentProject.testCases) {
			
			// 更新測試案例的金鑰
			this.currentProject.testCases[testCaseIndex].setTokenIfEmpty(token);
		}
		
		// 從第零個測試案例開始執行
		this.runTestCase(0);
	}

	/**
	 * 執行單元測試案例
	 * @param testCaseIndex 測試案例的索引值
	 */
	$scope.runTestCase = function(testCaseIndex) {

		var controller = this;
		
		var testCase = this.currentProject.testCases[testCaseIndex];
		var testCaseServiceInfo = testCase.toDWUnitTestServiceInfo();
		testCaseServiceInfo.url = settingService.tempData.unitTest.unitTestRunServiceUrl;
		
		var headers = [];
		
		if (testCase.tokenInfo && testCase.tokenInfo.pass) {
			headers.push({ "name":"token", "value": testCase.token });
		}
		
		testCaseServiceInfo.headers = headers;
		
		// 2016-1-7 falcon 清除上一次的結果
		testCase.clearResult();
		
		testCase.running = true;
		DWService.invoke(testCaseServiceInfo).then(
			function(serviceResult) { // success;
				
				controller.afterRunTestCase(serviceResult, testCaseIndex);
			},
			function(serviceResult) { // failure;

				controller.afterRunTestCase(serviceResult, testCaseIndex);
			}
		);
	}

	/**
	 * 執行測試案例之後
	 * @param serviceResult 服務調用結果
	 * @testCaseIndex 執行的測試案例索引值
	 */
	$scope.afterRunTestCase = function(serviceResult, testCaseIndex) {
		
		var testCase = this.currentProject.testCases[testCaseIndex];
		
		try {
			var testCaseResult = null;
			// 取出測試報告中的第零筆
			if (serviceResult.isSuccess()) { // 成功
				
				var testReport = serviceResult.getResult();
				testCaseResult = testReport._results[0];
			}
			else if (serviceResult.isConnectionError()) { // 無法連結
				
				testCaseResult = { "exception": "無法連接微服務伺服器" }
				testCaseResult.state = 2;
			}
			else { // 發生異常
				
				testCaseResult = { "exception": serviceResult.getFailedReason() }
				testCaseResult.state = 2;
			}

			testCase.setResult(testCaseResult); // 此方法會產生報表 Model
		}
		finally {
			testCase.running = false;
		}
		
		// 檢查斷言
		this.checkAssert(serviceResult, testCase);

		// 檢查是否有下一個測試案例
		var nextIndex = testCaseIndex + 1;
		if (this.currentProject.testCases.length > nextIndex) {
			
			// 執行下一個單元測試
			this.runTestCase(nextIndex);
		}
	}
	
	/**
	 * 斷言上下文
	 */
	$scope.assertContext = null;
	/**
	 * 2017-1-18 falcon 檢查斷言
	 * @param serviceResult 服務調用結果
	 * @param testCase 測試案例
	 */
	$scope.checkAssert = function(serviceResult, testCase) {
		
		// 2017-1-17 falcon 檢查斷言
		if (testCase.assertInfo) {
			
			if (!$.isArray(testCase.assertInfo.items)) {
				
				return;
			}
			
			// 清除前一次的檢查結果
			var assert;
			for (var idx in testCase.assertInfo.items) {
				
				assert = testCase.assertInfo.items[idx];
				assert.resultInfo = null;
			}
			
			// 2017-2-6 falcon 連接錯誤不檢查
			if (serviceResult.isConnectionError()) {
				
				//return;
			}
			
			if (testCase.assertInfo.check) {
			
				if (!this.assertContext) {
					
					this.assertContext = {};
					this.assertContext.scope = this;
					this.assertContext.testCase = testCase;
				}
				var resultWrapper = new DWTestingResultWrapper(serviceResult);
				
				try {
					var assert, check;
					for (var idx in testCase.assertInfo.items) {
						
						assert = testCase.assertInfo.items[idx];
						assert.resultInfo = {};
						
						try {
							check = assert.check(resultWrapper, this.assertContext);
						}
						catch (innerE) {
							
							if (innerE && innerE.checkedException) { // 檢查失敗的異常
								
								assert.resultInfo.exception = innerE.message ? innerE.message : "Unknown";
								check = false;
							}
							else {
								
								throw innerE;
							}
						}
						
						assert.resultInfo.state = check ? 1 : 2; // 1 成功, 2 失敗
					}
				}
				catch (e) {
					
					assert.resultInfo.state = 3; // exception
					
					if (e && e.message) {
						assert.resultInfo.exception = e.message;
					}
					else {
						assert.resultInfo.exception = "Unknown";
					}
				}

				var assertFailed = false;
				for (var idx in testCase.assertInfo.items) {
					
					if (testCase.assertInfo.items[idx].resultInfo.state != 1) {

						assertFailed = true;
						break;
					}
				}
				
				// 更改 測試案例狀態
				if (assertFailed) {
					
					testCase.setState(3);
				}
				else if (testCase.assertInfo.items.length > 0) {
					
					// 有可能拋出異常, 但是 assert 預期有異常, 所以改為成功
					testCase.setState(1);
				}
			}
		}
	}
	
	/**
	 * 建立新的測試專案
	 */
	$scope.createNewTestProject = function(projectName) {
		
		if (!this.closeCurrentProject()) return null;
		
		if (!projectName) {
			projectName = "New Test Project";
		}
		
		var tokenServiceInfo = this.getTokenServiceInfo();
		var newProject = new DWUnitTestProject(projectName, tokenServiceInfo);
		
		if (!this.setCurrentProject(newProject)) {
			// TODO SHOW 無法建立新專案
		}

		return newProject;
	}
	
	/**
	 * 刷新當前專案的金鑰服務信息
	 */
	$scope.refreshTokenServiceInfo = function() {
		
		if (this.currentProject) {
			
			var tokenServiceInfo = this.getTokenServiceInfo();
			this.currentProject.setTokenServiceInfo(tokenServiceInfo);
			
			DWMessage.showTips("專案金鑰服務信息刷新完成.");
		}
	}
	
	/**
	 * 取得金鑰服務信息
	 * @return 金鑰服務信息
	 */
	$scope.getTokenServiceInfo = function() {
		
		return settingService.tokenServiceInfo;
	}
	
	/**
	 * 設定當前的專案
	 * @param project 專案
	 */
	$scope.setCurrentProject = function(project) {
		
		if (!this.closeCurrentProject()) return false;
			
		this.currentProject = project;
		this.afterSetCurrentProject();
		
		return true;
	}
	
	/**
	 * 設定當前專案之後
	 */
	$scope.afterSetCurrentProject = function() {

		if (this.currentProject) {
			
			// 更新測試案例暫存資料
			var testCase;
			for (var itemIndex in this.currentProject.testCases) {
				
				testCase = this.currentProject.testCases[itemIndex];
				this.initTestCaseTempData(testCase);
				this.rebindingTestCaseTempData(testCase);
			}
		}
	}
	
	/**
	 * 2016-11-26 falcon 重新綁定測試案例的測試資料
	 * @param testCase 測試案例
	 */
	$scope.rebindingTestCaseTempData = function(testCase) {
		
		this.onModuleNameChanged(testCase);
		this.onServiceNameChanged(testCase);
		this.onMethodNameChanged(testCase);
	}
	
	/**
	 * 關閉當前專案
	 */
	$scope.closeCurrentProject = function() {

		// TODO 確認是否已經保存
		this.currentProject = null;

		return true;
	}
	
	/**
	 * 加入新的測試案例
	 */
	$scope.addNewTestCase = function() {

		var newTestCase = this.currentProject.addNewTestCase();
		this.initTestCaseTempData(newTestCase);
	}
	
	/**
	 * 初始化單元測試暫存資料
	 * @param testCase 測試案例
	 */
	$scope.initTestCaseTempData = function(testCase) {
		
		if (testCase) {
			
			testCase.tempData.currentModule = { "serviceList": [] };
			testCase.tempData.currentService = { "methodList": [] };	
		}
	}
	
	/**
	 * 移除選取的測試案例
	 */
	$scope.removeSelectedTestCases = function() {
		
		this.currentProject.deleteSelectedTestCases();
	}
	
	/**
	 * 提交測試報告
	 * @param onlySelectedTestCase 只取選取的測試案例測試結果
	 */
	$scope.submitTestReports = function(onlySelectedTestCase) {
		
		var standardTestingReport = this.currentProject.getStandardFormatTestingReport(onlySelectedTestCase);
		
		if (!this.tempData.loginInfo.login) {

			var submitInfo = { 'isSubmitRequired' : true, 'onlySelectedTestCase' : onlySelectedTestCase };
			$scope.showLoginUnitTestDialog(submitInfo);
			
			return;
		}
		
		this.invokeSubmitTestReportService(standardTestingReport);
	}

	/**
	 * 調用題較單元測試報表的服務
	 * @param testReports 測試報表清單
	 */
	$scope.invokeSubmitTestReportService = function(standardTestingReport) {
		
		var controller = this;
		
		var token = loginService.getToken();
		var submitServiceInfo = this.currentProject.toDWUnitTestrReportSumbitServiceInfo(token, standardTestingReport);
		submitServiceInfo.url = settingService.tempData.unitTest.unitTestSubmitResultServiceUrl;
		
		
		DWService.invoke(submitServiceInfo).then(
			function(serviceResult) { // success

				DWMessage.showInfo('提交成功!');
			},
			
			function(serviceResult) { // failure

				DWMessage.showError('提交失敗!');
			}
		);
	}
	
	/**
	 * 模組名稱改變事件
	 * @param testCaseIndexOrInstance 測試案例索引值或實例
	 */
	$scope.onModuleNameChanged = function(testCaseIndexOrInstance) {
		
		var testCase = typeof testCaseIndexOrInstance === "object" ? testCaseIndexOrInstance : this.currentProject.testCases[testCaseIndexOrInstance];		
		DWService.onModuleNameChanged(testCase.tempData, testCase.serviceCommand.moduleName);
	}
	
	/**
	 * 服務名稱改變事件
	 * @param testCaseIndexOrInstance 測試案例索引值或實例
	 */
	$scope.onServiceNameChanged = function(testCaseIndexOrInstance) {

		var testCase = typeof testCaseIndexOrInstance === "object" ? testCaseIndexOrInstance : this.currentProject.testCases[testCaseIndexOrInstance];		
		DWService.onServiceNameChanged(testCase.tempData, testCase.serviceCommand.serviceName);
	}
	
	/**
	 * 方法名稱改變事件
	 * @param testCaseIndexOrInstance 測試案例索引值或實例
	 */
	$scope.onMethodNameChanged = function(testCaseIndexOrInstance) {
		
		var testCase = typeof testCaseIndexOrInstance === "object" ? testCaseIndexOrInstance : this.currentProject.testCases[testCaseIndexOrInstance];		
		DWService.onMethodNameChanged(testCase.tempData, testCase.serviceCommand.methodName);
	}

	/**
	 * 使用者點擊 傳入 金鑰 核取框事件
	 * @param event UI 事件
	 * @param testCase 測試案例
	 */
	$scope.onUserClcikPassToken = function(event, testCase) {
		
		// 2016-12-26 falcon click 事件發生時, model 還沒有更新值
		var oldPass = testCase.tokenInfo && testCase.tokenInfo.pass;
		
		// 在不 pass 的情況下 click (表示使用者要傳冪等性編號) 
		if (!oldPass) {
			
			if (!testCase.token) {
				
				// 舊的 req 沒有  tokenInfo, 所以必須先建立  tokenInfo
				testCase.tokenInfo = {};
				this.generateToken(event, testCase);
			}
			else if (!testCase.token) {
				
				// 使用者決定要傳冪等性編號, 但是目前的編號為空
				this.generateToken(event, testCase);
			}
		}
	}
	
	/**
	 * 使用者點擊 傳入 冪等性編號的 核取框事件
	 * @param event UI 事件
	 * @param testCase 測試案例
	 */
	$scope.onUserClcikPassIdempotencyId = function(event, testCase) {
		
		// 2016-12-26 falcon click 事件發生時, model 還沒有更新值
		var oldPass = testCase.idempotencyInfo && testCase.idempotencyInfo.pass;
		
		// 在不 pass 的情況下 click (表示使用者要傳冪等性編號) 
		if (!oldPass) {
			
			if (!testCase.idempotencyInfo) {
				
				// 舊的 req 沒有  idempotencyInfo, 所以必須先建立 idempotencyInfo
				testCase.idempotencyInfo = {};
				this.generateIdempotentId(event, testCase);
			}
			else if (!testCase.idempotencyInfo.value) {
				
				// 使用者決定要傳冪等性編號, 但是目前的編號為空
				this.generateIdempotentId(event, testCase);
			}
		}
	}
	
	/**
	 * 產生冪等性編號
	 * @param event UI 事件
	 * @param testCase 測試案例
	 */
	$scope.generateIdempotentId = function(event, testCase) {

		var uuid = DWUnitTestProject.prototype.generateGuid();
		
		if (!testCase.idempotencyInfo) {
			
			testCase.idempotencyInfo = {};
		}

		testCase.idempotencyInfo.value = uuid; 
	}
	
	/**
	 * 依據簽名加入上傳檔案
	 * @param testCase 測試案例
	 */
	$scope.onRebuildUploadFiles = function(testCase) {
		
		if (testCase.uploadFiles) {
			
			// 2016-1-7 falcon 先移除現有的上傳檔案
			var currentSize = testCase.uploadFiles.length;
			for (var i = 0; i < currentSize; i++) {
				
				this.deleteUploadFile(testCase, 0);
			}
		}
		
		if (testCase.tempData.currentMethod) {
			
			for (idx in testCase.tempData.currentMethod.files) {
				
				newParameter = this.addUploadFile(testCase);
				newParameter.name = testCase.tempData.currentMethod.files[idx];
			}
		}
	}
	
	/**
	 * 加入上傳檔案
	 * @param testCase 測試案例
	 * @return 上傳檔案
	 */
	$scope.addUploadFile = function(testCase) {
		
		if (!testCase.uploadFiles) {
			
			testCase.uploadFiles = [];
		}
		
		var uploadFile = { "name":null, "value":null };
		testCase.uploadFiles.push(uploadFile);
		
		// 建置 selector dom
		this.buildUploadFileSelectordom(uploadFile);
		
		return uploadFile;
	}
	
	/**
	 * 刪除上傳檔案
	 * @param testCase 測試案例
	 * @param index 上傳檔案索引值
	 */
	$scope.deleteUploadFile = function(testCase, index) {
		var uploadFileParameter = testCase.uploadFiles[index];
		
		// 銷毀 selector dom
		this.destroyUploadFileSelectorDom(uploadFileParameter);
		
		testCase.uploadFiles.splice(index, 1);
	}
	
	/**
	 * 建立上傳檔案的選取 dom
	 * @param uploadFileParameter 上傳檔案的參數
	 */
	$scope.buildUploadFileSelectordom = function(uploadFileParameter) {
		
		var selectorDom = $("<input type='file' onchange='angular.element(this).scope().onSelectUploadFile(this)' />")[0];
		$("#fileUploadSelectorContainer").append(selectorDom);
		
		uploadFileParameter.filePath = null;
		uploadFileParameter.value = null;
		
		uploadFileParameter.selectorDom = selectorDom;
	}
	
	/**
	 * 銷毀上傳檔案的選取 dom
	 * @param uploadFileParameter 上傳檔案的參數
	 */
	$scope.destroyUploadFileSelectorDom = function(uploadFileParameter) {

		uploadFileParameter.filePath = null;
		uploadFileParameter.value = null;
		
		// 移除 selector dom
		$(uploadFileParameter.selectorDom).remove();
	}
	
	/**
	 * 重建上傳檔案的選取 dom (載入請求時調用)
	 * @param project 專案
	 */
	$scope.rebuildUploadFileSelectorDoms = function(project) {
		
		var selectorContainer = $("#fileUploadSelectorContainer");
		
		// 移除所有的 selector
		selectorContainer.empty();
		
		var uploadFileParameter;
		var targetCase;
		for (var idx in project.testCases) {
			
			targetCase = project.testCases[idx];
			if (!targetCase.uploadFiles) continue;
			
			for (var uploadFileIdx in targetCase.uploadFiles) {
				
				uploadFileParameter = targetCase.uploadFiles[uploadFileIdx];
				this.buildUploadFileSelectordom(uploadFileParameter);
			}
		}
	}

	/**
	 * 2016-2-28 falcon
	 * 開啟檔案選取對話框
	 * @param testCase 測試案例
	 * @param index 上傳檔案索引值
	 */
	$scope.openFileDialog = function(testCase, index) {

		var uploadFileSelector = $(testCase.uploadFiles[index].selectorDom);
		uploadFileSelector.attr("targetIndex", index);
		uploadFileSelector.trigger('click'); 
	}
	
	/**
	 * 選取 upload file 之後
	 * @param target 目標 dom
	 */
	$scope.onSelectUploadFile = function(target) {
		
		var targetIndex = $(target).attr("targetIndex");
	
		var targetTestCase = null;
		for (var idx in this.currentProject.testCases) {
			
			targetTestCase = this.currentProject.testCases[idx];

			// 沒有對應上傳檔案索引值的測試案例
			if (!targetTestCase.uploadFiles) continue;
			if (targetTestCase.uploadFiles.length < targetIndex) continue;
			
			if (targetTestCase.uploadFiles[targetIndex].selectorDom == target) {
				
				break;
			}
			else {
				
				targetTestCase = null;
			}
		}
		
		if (targetTestCase == null) return;

		var file = null;
		var filePath = null;
		if (target.files.length > 0) {
			file = target.files[0];
			filePath = target.value;
		} 
		
	    setTimeout(function () {
	        $scope.$apply(function () {

	        	targetTestCase.uploadFiles[targetIndex].value = file;
	        	targetTestCase.uploadFiles[targetIndex].filePath = filePath; 
	        });
	    });
	}
	
	/**
	 * 加入 Assert
	 * @param testCase 測試案例
	 */
	$scope.addAssert = function(testCase) {

		if (!testCase.selectedAssertType) {

			testCase.selectedAssertType = this.assertTypes[0].script;
		}

		var assert = eval(testCase.selectedAssertType);
		this.addAssertToTestCase(testCase, assert);
	}
	
	/**
	 * 加入 RAP Assert
	 * @param testCase 測試案例
	 */
	$scope.addRapAssert = function(testCase) {

		if (this.rapMockDataService) {

			var controller = this;
			var serviceCommand = testCase.serviceCommand;
			this.rapMockDataService.retrieveRapMockData(serviceCommand)
				.then(
					function(response) { // success

						var outputObject = response.getResult();
						var rapOutputAssert = new DWOutputAssert(outputObject);
						controller.addAssertToTestCase(testCase, rapOutputAssert);
					},
					function(response) { // failure

						var errMsg;
						if (response.isNotFound()) {
							
							errMsg = "沒有對應的 Mock 數據!";
						}
						else if (response.isConnectionError()) {
							
							errMsg = "無法連接 RAP 服務器!";
						}
						else {
							
							errMsg = "Unknown Error!";
						}
						
						DWMessage.showError(errMsg);
					}
				);
		}
	}
	/**
	 * 將 Assert 加入到測試案例中
	 * @param testCase 測試案例
	 * @param assert 斷言
	 */
	$scope.addAssertToTestCase = function(testCase, assert) {
		
		if (!testCase.assertInfo) {
			
			testCase.assertInfo = {};
		}
		if (!testCase.assertInfo.items) {
			
			testCase.assertInfo.items = [];
		}
		
		testCase.assertInfo.items.push(assert);
	}
	
	/**
	 * 刪除斷言
	 * @param testCase 測試案例
	 * @param index 斷言索引值
	 */
	$scope.deleteAssert = function(testCase, index) {

		testCase.assertInfo.items.splice(index, 1);
	}
	
	$scope.isEditableAssert = function(assert) {
		
		return assert.isEditable;
	}
	
	/**
	 * TODO 放這兒有點奇怪
	 * 編輯斷言輸出控制者
	 */
	function editAssertOutputController($scope, $mdDialog, DWMessage, DWService, editInfo) {
		
		$scope.editInfo = editInfo;
		$scope.checkBeforeOk = true;
		$scope.validJSONString = true;
		$scope.failedReason = null;

	    /**
	     * 取消事件
	     */
	    $scope.cancel = function() {

	    	$mdDialog.cancel();
	    };

	    /**
	     * 確認事件
	     */
	    $scope.ok = function() {
	    	
	    	if ($scope.checkBeforeOk) {
	    		
	    		$scope.validJSONString = $scope.checkJSONFormat();
	    		if (!$scope.validJSONString) return;
	    	}

	    	$mdDialog.hide($scope.editInfo.value);
	    };
	    
	    /**
	     * 檢查 JSON 格式
	     */
	    $scope.checkJSONFormat = function() {
	    	
	    	try {
	    		
	    		if ($scope.editInfo.value) {

	    			var jsonObject= JSON.parse($scope.editInfo.value);
	    		}
	    	}
	    	catch (e) {
	    		
	    		$scope.failedReason = e.message;
	    		return false;
	    	}
	    	
	    	return true;
	    }
	    
	    $scope.onReloadRapOutput = function() {

	    	if (DWService) {

				var controller = this;
				var serviceCommand = this.editInfo.testCase.serviceCommand;
				DWService.retrieveRapMockData(serviceCommand)
					.then(
						function(response) { // success

							var outputObject = response.getResult();
							controller.editInfo.value = JSON.stringify(outputObject, null, "\t");
						},
						function(response) { // failure

							var errMsg;
							if (response.isNotFound()) {
								
								errMsg = "沒有對應的 Mock 數據!";
							}
							else if (response.isConnectionError()) {
								
								errMsg = "無法連接 RAP 服務器!";
							}
							else {
								
								errMsg = "Unknown Error!";
							}
							
							DWMessage.showError(errMsg);
						}
					);
			}
	    }
	    
	    $scope.onKeydown = function(uiEvent) {

	    	if (uiEvent.keyCode && uiEvent.keyCode == 9) { // press tab 
	
	    		uiEvent.preventDefault();
	    		
	    		var target = uiEvent.target;
			    var start = target.selectionStart;
			    var end = target.selectionEnd;

			    // set textarea value to: text before caret + tab + text after caret
			    $(target).val($(target).val().substring(0, start)
			                + "\t"
			                + $(target).val().substring(end));

			    // put caret at right position again
			    target.selectionStart = start + 1;
			    target.selectionEnd = target.selectionStart;
	    	}
	    }
	}
	
	/**
	 * 顯示 斷言編輯對話框
	 * @param testCase 測試案例
	 * @param assert 斷言
	 * @param uiEvent UI 事件
	 */
	$scope.showAssertEditDialog = function(testCase, assert, uiEvent) {
		
		var editInfo = {};
		editInfo.testCase = testCase;
		editInfo.value = assert[assert.editInfo.targetProperty];

		var url = '/testcenter/views/dwrequester/html/dw-unit-test/editAssertOutputDialog.html';
		var templateUrl = testcenterClientService.convertUrl(url);
		
		$mdDialog.show(
			{
				controller: editAssertOutputController,
				templateUrl: templateUrl,
				parent: angular.element(document.body),
				targetEvent: uiEvent,
				clickOutsideToClose:true,
				fullscreen: true, // Only for -xs, -sm breakpoints.
				locals: {
					'editInfo' : editInfo
				}
		    }).then(
		    	function(editResult) { // ok

		    		assert[assert.editInfo.targetProperty] = editResult;
		    	},
		    	function() { // cancel
		    		// DO NOTHING
		    	}
		    );
	}

	// unit tester ======================================================================================
	
});