var app = angular.module('app');

app.controller('dwRedisUtilController',
	function($scope, $http, $mdDialog, DWMessage, DWService, settingService,
			parameterStorage, DWSaveService, configService, testcenterClientService) {
	
	$scope.serverType = testcenterClientService.getServerType();
	
	$scope.$on('$viewContentLoaded', function() {
		if(parameterStorage.getData('dwRedisUtilController')) {
			var parameters = parameterStorage.getData('dwRedisUtilController');

			$scope.tempData = parameters.tempData;
			
			// 2016-12-9 falcon 還原 result Viewer
			if ($scope.tempData.resultViewer) {
				
				$scope.attachJsonViewer($scope.tempData.resultViewer);
			}
			
			$scope.initHistoryTabs();
		}
	});
  
	$scope.$on('$destroy', function() {
		var parameters = {};
		parameters.tempData = $scope.tempData;
		
		parameterStorage.setData('dwRedisUtilController', parameters);
	});

	$scope.tempData = {};
	$scope.tempData.param = {};
	$scope.tempData.param.queryMode = "0";
	$scope.tempData.param.redisPort = "22623";
	$scope.tempData.param.filePath = null;
	$scope.tempData.param.targetStartNumber = 1;
	$scope.tempData.searchNoResponseThread = false;
	$scope.tempData.result = null;
	$scope.tempData.resultJsonString = null;
	$scope.tempData.selectedIndex = 0;
	
	$scope.tempData.param.searchTextInfo = {};
	$scope.tempData.param.searchTextInfo.pageSize = 100;
	$scope.tempData.param.searchTextInfo.pageNumber = 1;

	$scope.tempData.param.searchRangeInfo = {};
	$scope.tempData.param.searchRangeInfo.targetLine = 1;
	$scope.tempData.param.searchRangeInfo.rangeSize = 50;
	
	/**
	 * 設定 busy
	 * @param busy 是否忙錄
	 */
	$scope.setBusy = function (busy) {
		
		this.tempData.busy = busy ? "1" : "0";
	}
	
	$scope.onTabSelected = function(tab) {
		
		// 2018--5-27 falcon event 順序問題 ($viewContentLoaded 還抓不到 viewer container
		if (this.tempData.resultViewer) {
			
			var viewerContainer = document.querySelector("#dwRedisUtilResultViewerContainer");
			if (viewerContainer != this.tempData.resultViewer.parentElement) {
			
				this.attachJsonViewer(this.tempData.resultViewer);
				this.reloadHistoryTabs();
			}
		}
	}
	
	/**
	 * 2016-2-28 falcon
	 * 開啟檔案選取對話框
	 * @index 索引值
	 */
	$scope.openFileDialog = function(index) {
		
		var uploadFileSelector = $("#realOpenFileInput");

		uploadFileSelector.trigger('click'); 
	}
	
	/**
	 * 選取 upload file 之後
	 */
	$scope.onSelectFile = function(target) {

		var file = null;
		var filePath = null;
		if (target.files.length > 0) {
			file = target.files[0];
			filePath = target.value;
		} 
		
	    setTimeout(function () {
	        $scope.$apply(function () {

	        	$scope.param.filePath = filePath; 
	        });
	    });
	}
	
	$scope.chartZoomOut = function() {
		
		var ctx = document.getElementById("myChart");
		
		var width = $(ctx).width();
		if ($.isNumeric(width)) {
			
			width = 100;
		}
		
		if (width > 10) {
			
			width -= 10;
		}
		
		$(ctx).width(width + "%");
	}
	$scope.chartZoomIn = function() {
		
		var ctx = document.getElementById("myChart");

		var width = $(ctx).width();
		if ($.isNumeric(width)) {
			
			width = 100;
		}
		
		if (width < 200) {
			
			width += 10;
		}
		
		$(ctx).width(width + "%");
	}
	$scope.chartFitScreen = function() {
		
		var ctx = document.getElementById("myChart");
		$(ctx).width("100%");
	}
	
	$scope.showChart = function() {
		
		this.showServiceTopNInvocationCountChart(25);
	}
	
	$scope.showServiceTopNInvocationCountChart = function(showTopN) {
		
		try {

			if (this.tempData.result && this.tempData.result.result
					&& this.tempData.result.result.statistics
					&& this.tempData.result.result.statistics.serviceCountInfo) {
				
				var serviceCountInfo = this.tempData.result.result.statistics.serviceCountInfo;
				
				var serviceKeys = [];
				for(var key in serviceCountInfo) {
					      
					serviceKeys.push(key);
				}
				
				if (serviceKeys.length < showTopN) {
					
					showTopN = serviceKeys.length;
				}
				
				var xLabels = [];
				var datas = [];
				var srvKey;
				for (var i = 0; i < showTopN; i++) {
				
					srvKey = serviceKeys[i];
					xLabels.push(srvKey);
					datas.push(serviceCountInfo[srvKey].total);
				}

				var ctx = document.getElementById("myChart");
				var myChart = new Chart(ctx, {
				    type: 'bar',
				    data: {
				        labels: xLabels,
				        datasets: [{
				            label: '# of Service Invocation Count',
				            data: datas,
				            borderWidth: 1
				        }]
				    },
				    options: {
				        scales: {
				            yAxes: [{
				                ticks: {
				                    beginAtZero:true
				                }
				            }]
				        },
				        title: {
				        	display: true,
				        	text: '- Digiwin Micro Service -'
				        }
				    }
				});
			}
		}
		catch (e) {
			
			DWMessage.showError("繪製圖表失敗!");
		}
	}
	
	$scope.testChart = function() {
		
		var ctx = document.getElementById("myChart");
		var myChart = new Chart(ctx, {
		    type: 'bar',
		    data: {
		        labels: ["Red werqwrqwerqwerqwerqwer", "Blue", "Yellow", "Green", "Purple", "Orange"],
		        datasets: [{
		            label: '# of Votes',
		            data: [12, 19, 3, 5, 2, 3],
//		            backgroundColor: [
//		                'rgba(255, 99, 132, 0.2)',
//		                'rgba(54, 162, 235, 0.2)',
//		                'rgba(255, 206, 86, 0.2)',
//		                'rgba(75, 192, 192, 0.2)',
//		                'rgba(153, 102, 255, 0.2)',
//		                'rgba(255, 159, 64, 0.2)'
//		            ],
//		            borderColor: [
//		                'rgba(255,99,132,1)',
//		                'rgba(54, 162, 235, 1)',
//		                'rgba(255, 206, 86, 1)',
//		                'rgba(75, 192, 192, 1)',
//		                'rgba(153, 102, 255, 1)',
//		                'rgba(255, 159, 64, 1)'
//		            ],
		            borderWidth: 1
		        }]
		    },
		    options: {
		        scales: {
		            yAxes: [{
		                ticks: {
		                    beginAtZero:true
		                }
		            }]
		        }
		    }
		});
	}

	/**
	 * 查詢
	 */
	$scope.query = function() {

		var resourceInfo = {};
		resourceInfo.name = "dwredis/query";
		
		resourceInfo.headers = [];
		resourceInfo.parameters = [];
		
		for (var propertyName in this.tempData.param) {
			
			resourceInfo.parameters.push( { "name" : propertyName, "value": this.tempData.param[propertyName] } );
		}
		
		this.tempData.param.listStartTimesOnly = this.tempData.param.queryMode == "0";
		
		var controller =  this;
		this.setBusy(true);
		DWService.invokeResourceService(resourceInfo).then(
				function(serviceResult) { // success

					controller.tempData.result = serviceResult.getResult();
					controller.tempData.resultJsonString = JSON.stringify(controller.tempData.result);

					try {
						
						controller.createResponseJsonViewers(serviceResult);
					} finally {
					
						controller.setBusy(false);
					}
					DWMessage.showTips("分析完成");
					
					controller.tempData.selectedIndex = 0;
					
					controller.showChart();
				},
				function(response) {

					controller.setBusy(false);
					DWMessage.showError("分析失敗");
					
					controller.tempData.resultJsonString = response.response.data;
				}
		);
	}
	
	/**
	 * 2016-12-22 falcon
	 * 建立回應的所有 JSON Viewer
	 * @param serviceResult 服務調用後的結果 
	 */
	$scope.createResponseJsonViewers = function(serviceResult) {

		// 建立 result viewer
		var result = serviceResult.getResult();
		var resultViewer = this.createJsonViewer("dwRedisUtilResultViewer", result);

		// 2016-12-9 falcon 保存  viewers (切回 Request 頁時使用)
		this.tempData.resultViewer = resultViewer;
		
		// 將 json viewer 加入到 container 中
		var oldViewer = this.attachJsonViewer(resultViewer);

		this.refreshHistoryTabs(oldViewer);
	}
	
	/**
	 * 2016-12-22 falcon 建立 Json Viewer DOM Element
	 * @param id json viewer 編號
	 * @param jsonObject 物件
	 * @return viewer dom element
	 */
	$scope.createJsonViewer = function(id, jsonObject) {
		
		return DWService.jsonViewerAgent.render(id, jsonObject);
	
		var formatter = new JSONFormatter(jsonObject);

		var jsonViewer = formatter.render();
		jsonViewer.id = id;
		
		return jsonViewer;
	}
	
	/**
	 * 附加 JSON Viewer
	 * @param jsonViewer JSON Viewer
	 */
	$scope.attachJsonViewer = function(jsonViewer) {

		var viewerId = jsonViewer.id;
		var oldViewer = this.detachJsonViewer(viewerId);

		var viewerContainerSelector = "#" + viewerId + "Container";
		
		var viewerContainer = document.querySelector(viewerContainerSelector);
		
		if (viewerContainer == null) return ; // not ready
		
		// attach
		viewerContainer.appendChild(jsonViewer);
		
		return oldViewer;
	}
	
	$scope.initHistoryTabs = function() {
		
		if ($scope.tempData.historyResults) return;

		$scope.tempData.historyResults = [];
		for (var i = 0; i < 5; i++) {
			
			var historyItem = {};
			historyItem.label = "History" + (i + 1);
			historyItem.id = "tabHistory" + i;
			historyItem.viewerContainerId = "dwRedisUtilHistoryViewerContainer" + i;
			historyItem.viewer = null;

			$scope.tempData.historyResults.push(historyItem);
		}
	}
	
	$scope.initHistoryTabs();
	
	$scope.reloadHistoryTabs = function() {
		
		var historyItem;
		var currentContainer;
		for (var idx in this.tempData.historyResults) {
			
			historyItem = this.tempData.historyResults[idx];
			if (historyItem.viewer != null) {
			
				currentContainer = document.querySelector("#" + historyItem.viewerContainerId);
				currentContainer.appendChild(historyItem.viewer);
			}
		}
	}
	
	$scope.refreshHistoryTabs = function(oldViewer) {
		
		if (oldViewer == null) return;

		var historyItem;
		var previousHistoryItem;
		var currentContainer;
		var currentViewer;
		var previousContainer;
		var previousViewer;
		var historyViewerContainerSelector;
		for (var i = this.tempData.historyResults.length - 1; i >= 1; i--) {
		
			historyItem = this.tempData.historyResults[i];
			previousHistoryItem = this.tempData.historyResults[i - 1];
			
			if (historyItem.viewer != null) {
				
				historyItem.viewer.remove();
				historyItem.viewer = null;
			}
			if (previousHistoryItem.viewer != null) {
				
				previousHistoryItem.viewer.remove();
				
				currentContainer = document.querySelector("#" + historyItem.viewerContainerId);
				currentContainer.appendChild(previousHistoryItem.viewer);
				historyItem.viewer = previousHistoryItem.viewer;
				
				previousHistoryItem.viewer = null;
			}
		}
		
		this.tempData.historyResults[0].viewer = oldViewer;
		document.querySelector("#" + this.tempData.historyResults[0].viewerContainerId).appendChild(oldViewer);
	}
	
	/**
	 * 分離 JSON Viewer
	 * @param id Viewer 編號
	 */
	$scope.detachJsonViewer = function(viewerId) {
		
		var viewerSelector = "#" + viewerId;
		
		var element = angular.element(document.querySelector(viewerSelector));
		var viewer = null;

		if (element.length > 0) {
			
			viewer = element[0];
			viewer.id = "removed";
			viewer.remove();
		}

		return viewer;
	}
	
	$scope.jsonViewerCollapse = function() {
	
		var tabIndex = this.tempData.selectedIndex;
		var baseDomId = tabIndex == 0 ? "dwRedisUtilResultViewer" : "dwRedisUtilHistoryViewerContainer" + (tabIndex - 1);
		
		DWService.jsonViewerAgent.collapse(baseDomId);
	}

	$scope.jsonViewerExpand = function() {
		
		var tabIndex = this.tempData.selectedIndex;
		var baseDomId = tabIndex == 0 ? "dwRedisUtilResultViewer" : "dwRedisUtilHistoryViewerContainer" + (tabIndex - 1);

		DWService.jsonViewerAgent.expand(baseDomId);
	}

});
