var app = angular.module('app');

app.controller('LoginController', 
		 function($scope, testcenterClientService, loginService, DWMessage) {
			
    $scope.userid = "";
    $scope.password = "";

    $scope.doLogin = function() {

    	if(!$scope.userid || !$scope.password) {
    		DWMessage.showWarning("請輸入電子表單帳號密碼!");
    		return;
    	}
    	
		loginService.doLogin($scope.userid, $scope.password)
		.then(function successCallback(response) {
			var data = response.data;

			var result = data.result;
	
			if('success'==result) {
				var token = data.token;
				
				var expireDate = new Date();
				expireDate.setHours(expireDate.getHours() + 24);
				
				loginService.setToken(token, expireDate);
				loginService.setUserId($scope.userid, expireDate);
				
				var username = data.username;
				loginService.setUserName(username, expireDate);
				
				var request = {method: "GET", 
							   headers: {'token': token},
							   url: "/testcenter/dwrequester/view/mainpage"};

				testcenterClientService.apiRequest(request)
				.then(function successCallback(response) {
					
					var html = response.data;
						
					var indexController = angular.element(document.getElementById("indexController"));
					indexController.scope().setHtml(html);
				}, function errorCallback(response) {
				});
				
			} else if('failed'==result) {
				var message = data.message;
				DWMessage.showError(message);
			}
			
		}, function errorCallback(response) {
		});    	
    	
    }
});
