var app = angular.module('app');

app.controller('MainPageController',
		['$scope', '$location', 'DWResourceBundleService', 'testcenterClientService', 'loginService', 'configService', 'settingService', 'DWService',
		 function($scope, $location, rsService, testcenterClientService, loginService, configService, settingService, DWService) {
	
	$scope.serverType = testcenterClientService.getServerType();
	$scope.rsService = rsService;
	
	$scope.view = '/request';
	
	$scope.version = '';
	
	$scope.edition = testcenterClientService.isServerEdition() ? "服務器版" : "單機版";
	
	$scope.username = loginService.getUserName();
	
	$scope.changeView = function(view) {
		$scope.view = view;
	}
	
	$scope.doLogout = function() {
		
		loginService.doLogout();
		
		var request = {method: "GET", 
				 	   url: "/testcenter/dwrequester/view/login"};

		testcenterClientService.apiRequest(request)
		.then(function successCallback(response) {
			
			var html = response.data;
				
			var indexController = angular.element(document.getElementById("indexController"));
			indexController.scope().setHtml(html);
		}, function errorCallback(response) {
		});
	}
	
	/**
	 * 初始化
	 */
	$scope.initialize = function() {
		
		configService.getConfig('version')
		.then(function successCallback(response) {
			$scope.version = response.data;
		}, function errorCallback(response) {
		});
		
		var anchor = $location.path();

		if(anchor && anchor!='/') {
			$scope.view = anchor;
		}
		
		// 下列順序不可變更, 2 依賴 1 先加載
		// 1.Load User DWGateway Setting Data
		settingService.loadSetting(function() { // callback
			
			// 2.Load Module Info
			DWService.initDWModuleInfoList();
		});
	}
	
	// 初始化
	$scope.initialize();
}]);
