var app = angular.module('app');
app.controller('RequestController', 
		 function($scope, testcenterClientService, $mdDialog, DWService, DWMessage, 
				 DWSaveService, parameterStorage, settingService) {
	
	$scope.serverType = testcenterClientService.getServerType();
	
	$scope.$on('$viewContentLoaded', function() {
		if(parameterStorage.getData('requestController')) {
			var parameters = parameterStorage.getData('requestController');
			$scope.requestSetting = parameters.requestSetting;
			$scope.responseInfo = parameters.responseInfo;
			$scope.tempData = parameters.tempData;
			
			// 2016-12-9 falcon 還原 result Viewer
			if ($scope.tempData.resultViewer) {
				
				$scope.attachJsonViewer($scope.tempData.resultViewer);
			}
			// 2016-12-22 falcon 還原 systemInfo Viewer
			if ($scope.tempData.systemInfoViewer) {
				
				$scope.attachJsonViewer($scope.tempData.systemInfoViewer);
			}
		}
		else { // 第一次執行

			$scope.requestSetting.urlInfo.basicUrl = settingService.defaultDwgatewayUrl;
		}
	});
  
	$scope.$on('$destroy', function() {
		var parameters = {};
		parameters.requestSetting = $scope.requestSetting;
		parameters.responseInfo = $scope.responseInfo;
		parameters.tempData = $scope.tempData;
		parameterStorage.setData('requestController', parameters);
	});
	
	/**
	 * UI 綁定使用
	 */
	$scope.settingRepository = settingService;
	
	/**
	 * UI 綁定使用 (內部直接用 DWService)
	 */
	$scope.moduleRepository = DWService;
	$scope.jsonViewerAgent = DWService.jsonViewerAgent;
	// 記錄選取的方法所使用的 temp data
	$scope.tempData = {};
	$scope.tempData.autoGenerateToken = true;
	$scope.tempData.currentModule = { "serviceList": [] };
	$scope.tempData.currentService = { "methodList": [] };
	
	// 2018-7-16 falcon JSON viewer options
	$scope.tempData.jsonviewer = {};
	$scope.tempData.jsonviewer.showPropertySeq = true;
	
	$scope.serviceMode = 0;   // 0 - 面向服務 mapping - post method, 1- 面向資源 mapping - restful
	
	$scope.isBusy = "0";
	
	// model - 請求設定
	$scope.requestSetting = {};
	
	// 2018-7-4 falcon 新增參數模式
	$scope.requestSetting.parameterMode = 0;  // 0 - 清單, 1- JSON
	
	// model - 請求設定 - URL 信息
	$scope.requestSetting.urlInfo = {};
	$scope.requestSetting.urlInfo.basicUrl = null;
	
	// 2018-11-29 falcon completedUrl path variables;
	$scope.requestSetting.urlInfo.pathVariables = [];
	
	// model - 請求設定 - 冪等性 信息
	$scope.requestSetting.idempotencyInfo = {};
	$scope.requestSetting.idempotencyInfo.pass = true;
	$scope.requestSetting.idempotencyInfo.value = DWUnitTestProject.prototype.generateGuid();
	$scope.requestSetting.passRouterKey = true;
	
	// model - 請求設定 - 參數
	$scope.requestSetting.headers = [];
	$scope.requestSetting.parameters = [];
	$scope.requestSetting.uploadFiles = [];
	
	// model - 回應消息
	/**
	 * 初始化回應信息
	 */
	$scope.initResponseInfo = function() {
		
		if (!this.responseInfo) {
			
			this.responseInfo = {};
		}
		
		this.responseInfo.url = null; // 實際請求的 url
		this.responseInfo.data = null; // 實際返回的數據
		this.responseInfo.fileLinks = []; // 實際返回數據中的文件連結
		
		delete this.responseInfo.tokenGettingFailedReason;
		delete this.responseInfo.status;
		delete this.responseInfo.success;
	}
	$scope.initResponseInfo();

	$scope.historyParameterValuesList = getHistoryParameterValues();
	
	var dwgatewayUrls = settingService.dwgatewayUrls;
	if (dwgatewayUrls && dwgatewayUrls.length > 0) {
		$scope.requestSetting.urlInfo.basicUrl = dwgatewayUrls[0];
	}
	
	/**
	 * 清除方法
	 */
	$scope.clearCurrentMethod = function() {
		
		this.requestSetting.urlInfo.methodName = null;
		this.tempData.currentMethod = null;
	}
	
	/**
	 * TODO 放這兒有點奇怪
	 * 編輯單元測試專案服務參數控制者
	 */
	function editRequestParameterController($scope, $mdDialog, parameterInfo) {
		
		$scope.parameterInfo = parameterInfo;		
		
	    /**
	     * 取消事件
	     */
	    $scope.cancel = function() {

	    	$mdDialog.cancel();
	    };

	    /**
	     * 確認事件
	     */
	    $scope.ok = function() {

	    	$mdDialog.hide($scope.parameterInfo.value);
	    };
	    
	    $scope.onKeydown = function(uiEvent) {

	    	if (uiEvent.keyCode && uiEvent.keyCode == 9) { // press tab 
	
	    		uiEvent.preventDefault();
	    		
	    		var target = uiEvent.target;
			    var start = target.selectionStart;
			    var end = target.selectionEnd;

			    // set textarea value to: text before caret + tab + text after caret
			    $(target).val($(target).val().substring(0, start)
			                + "\t"
			                + $(target).val().substring(end));

			    // put caret at right position again
			    target.selectionStart = start + 1;
			    target.selectionEnd = target.selectionStart;
	    	}
	    }
	}
	
	/**
	 * 顯示參數編輯框
	 * @param targetParameter 目標參數
	 */
	$scope.showParameterEditDialog = function(uiEvent, targetParameter) {

		var parameterInfo = {};
		parameterInfo.name = targetParameter.name;
		parameterInfo.value = targetParameter.value;
		if (targetParameter.dialog) {
			
			parameterInfo.dialog = targetParameter.dialog;
		}
		
		var url = '/testcenter/views/dwrequester/html/request/editRequestParameterDialog.html';
		var templateUrl = testcenterClientService.convertUrl(url);
		
		$mdDialog.show(
			{
				controller: editRequestParameterController,
				templateUrl: templateUrl,
				parent: angular.element(document.body),
				targetEvent: uiEvent,
				clickOutsideToClose:true,
				fullscreen: true, // Only for -xs, -sm breakpoints.
				locals: {
					'parameterInfo' : parameterInfo
				}
		    }).then(
		    	function(editResult) { // ok

		    		targetParameter.value = editResult;
		    	},
		    	function() { // cancel
		    		// DO NOTHING
		    	}
		    );
	}
	
	
	/**
	 * 自動產生服務參數
	 */
	$scope.autoGenerateParameters = function() {
		
		if (this.serviceMode === 3) {
			
			this.requestSetting.headers.length = 0;
			this.requestSetting.parameters.length = 0;
			this.requestSetting.uploadFiles.length = 0;
			
			// eai header 產生規則
			if (this.requestSetting.urlInfo.moduleName === "EAI General Service") {
				
				newParameter = this.addHeader();
				newParameter.name = "digi-token";
				
				newParameter = this.addHeader();
				newParameter.name = "digi-service";
				newParameter.value = JSON.stringify({ "name": this.requestSetting.urlInfo.serviceName });
			}
			else {
				
				newParameter = this.addHeader();
				newParameter.name = "digi-callback-token";
				
				newParameter = this.addHeader();
				newParameter.name = "digi-callback-callback";
				newParameter.value = this.requestSetting.urlInfo.serviceName;
			}
			
			if (this.tempData.autoGenerateToken) {
				this.generateTokenHeader();
			}
		}
		else if (this.tempData.currentMethod) {
			
				this.requestSetting.headers.length = 0;
				this.requestSetting.parameters.length = 0;
				this.requestSetting.uploadFiles.length = 0;
				
				if (!this.tempData.currentMethod.allowAnonymous) {
					newParameter = this.addHeader();
					newParameter.name = "token";

					if (this.tempData.autoGenerateToken) {
						this.generateTokenHeader();
					}
				}
				
				var newParameter;
				for (idx in this.tempData.currentMethod.parameters) {
					
					newParameter = this.addParameter();
					newParameter.name = this.tempData.currentMethod.parameters[idx];
				}
				for (idx in this.tempData.currentMethod.files) {
					
					newParameter = this.addUploadFile();
					newParameter.name = this.tempData.currentMethod.files[idx];
				}
		}
	}
	
	/**
	 * 使用者點擊 傳入 冪等性編號的 核取框事件
	 */
	$scope.onUserClcikPassIdempotencyId = function() {
		
		// 2016-12-26 falcon click 事件發生時, model 還沒有更新值
		var oldPass = this.requestSetting.idempotencyInfo && this.requestSetting.idempotencyInfo.pass;
		
		// 在不 pass 的情況下 click (表示使用者要傳冪等性編號) 
		if (!oldPass) {
			
			if (!this.requestSetting.idempotencyInfo) {
				
				// 舊的 req 沒有 idempotencyInfo, 所以必須先建立 idempotencyInfo
				this.requestSetting.idempotencyInfo = {};
				this.generateIdempotentId();
			}
			else if (!this.requestSetting.idempotencyInfo.value) {
				
				// 使用者決定要傳冪等性編號, 但是目前的編號為空
				this.generateIdempotentId();
			}
		}
	}
	
	/**
	 * 產生冪等性編號
	 */
	$scope.generateIdempotentId = function() {
		
		var uuid = DWUnitTestProject.prototype.generateGuid();
		this.requestSetting.idempotencyInfo.value = uuid;
	}
	
	$scope.checkMethodSource = function() {
		
		if (!$scope.requestSetting.urlInfo.basicUrl) return true;
		
		if ($scope.serviceMode === 2) {
			
			return $scope.requestSetting.urlInfo.basicUrl == settingService.defaultStandardRestfulGatewayUrl;
		}
		else if ($scope.serviceMode === 3) {
			
			return $scope.requestSetting.urlInfo.basicUrl == settingService.defaultEaiGatewayUrl;
		}
		
		return $scope.requestSetting.urlInfo.basicUrl == settingService.defaultDwgatewayUrl;
	}
	
	/**
	 * 建立新的參數
	 */
	$scope.createNewParameter = function() {
		
		var instance = { "name":null, "value":null };
		return instance;
	}
	
	/**
	 * 增加 Header
	 */
	$scope.addHeader = function() {

		var length = this.requestSetting.headers.length;
		var newHeader = this.createNewParameter();
		this.requestSetting.headers[length] = newHeader;
		
		return newHeader;
	}
	
	/**
	 * 刪除 Header
	 * @index Header 索引值
	 */
	$scope.deleteHeader = function(index) {
		this.requestSetting.headers.splice(index, 1);
	}
	
	/**
	 * 增加 Body 參數
	 */
	$scope.addParameter = function() {

		var length = this.requestSetting.parameters.length;
		var newParameter = this.createNewParameter();
		this.requestSetting.parameters[length] = newParameter;
		
		return newParameter;
	}
	
	/**
	 * 刪除 Body 參數
	 */
	$scope.deleteParameter = function(index) {
		this.requestSetting.parameters.splice(index, 1);
	}
	
	/**
	 * 增加上傳檔案
	 */
	$scope.addUploadFile = function() {
		
		var length = this.requestSetting.uploadFiles.length;
		var newFile = this.createNewParameter();
		this.requestSetting.uploadFiles[length] = newFile;
		
		// 建置 selector dom
		this.buildUploadFileSelectordom(newFile);
		
		return newFile;
	}
	
	/**
	 * 刪除上傳檔案
	 * @param index 檔案索引值
	 */
	$scope.deleteUploadFile = function(index) {
		var uploadFileParameter = this.requestSetting.uploadFiles[index];
		
		// 銷毀 selector dom
		this.destroyUploadFileSelectorDom(uploadFileParameter);
		
		this.requestSetting.uploadFiles.splice(index, 1);
	}
	
	/**
	 * 建立上傳檔案的選取 dom
	 * @param uploadFileParameter 上傳檔案的參數
	 */
	$scope.buildUploadFileSelectordom = function(uploadFileParameter) {
		
		var selectorDom = $("<input type='file' onchange='angular.element(this).scope().onSelectUploadFile(this)' />")[0];
		$("#fileUploadSelectorContainer").append(selectorDom);
		
		uploadFileParameter.filePath = null;
		uploadFileParameter.value = null;
		
		uploadFileParameter.selectorDom = selectorDom;
	}
	
	/**
	 * 銷毀上傳檔案的選取 dom
	 * @param uploadFileParameter 上傳檔案的參數
	 */
	$scope.destroyUploadFileSelectorDom = function(uploadFileParameter) {

		uploadFileParameter.filePath = null;
		uploadFileParameter.value = null;
		
		// 移除 selector dom
		$(uploadFileParameter.selectorDom).remove();
	}
	
	/**
	 * 重建上傳檔案的選取 dom (載入請求時調用)
	 */
	$scope.rebuildUploadFileSelectorDoms = function() {
		
		var selectorContainer = $("#fileUploadSelectorContainer");
		
		// 移除所有的 selector
		selectorContainer.empty();
		
		var uploadFileParameter;
		for (var idx in this.requestSetting.uploadFiles) {
			
			uploadFileParameter = this.requestSetting.uploadFiles[idx];
			this.buildUploadFileSelectordom(uploadFileParameter);
		}
	}
	
	/**
	 * 開啟檔案連結
	 * @param fileLinkInfo 檔案連結信息
	 */
	$scope.openFileLink = function(fileLinkInfo) {
		window.open(fileLinkInfo.link, '_blank', 'fullscreen=yes'); 
		return false;
	}
	
	/**
	 * 建立檔案連結信息
	 * @param linkIndex 連結索引值
	 * @param fileLink 檔案連結
	 */
	$scope.createFileLinkInfo = function(linkIndex, fileLink) {
		
		var fileLinkInfo = new Object();
		
		fileLink = eval(fileLink);  // 移除多的雙引號
		
		var serverPort = settingService.defaultIpPort;
		
		// serverPort.slice(-1) 可取得最後一個字元, 判斷是否為 /
		// fileLink.fileLink.slice(0, 1) 判斷第一個字元 是否為 /
		if (serverPort && "/" === serverPort.slice(-1) &&
				fileLink && "/" === fileLink.slice(0, 1)) {
			
			// 移除多餘的 /
			fileLink = fileLink.substring(1);
		}
		
		fileLinkInfo.link = serverPort + fileLink;
		
		var parts = fileLink.split("/");
		
		fileLinkInfo.displayName = "file " + (linkIndex + 1) + " - " + parts[parts.length - 1];
		
		return fileLinkInfo;
	}

	$scope.	createFastDFSFileLinkInfo = function(linkIndex, fileLink, exportName) {
		
		var fileLinkInfo = new Object();
		
		fileLink = eval(fileLink);  // 移除多的雙引號
		
		var serverPort = settingService.defaultIpPort;
		
		// serverPort.slice(-1) 可取得最後一個字元, 判斷是否為 /
		// fileLink.fileLink.slice(0, 1) 判斷第一個字元 是否為 /
		if (serverPort && "/" === serverPort.slice(-1) &&
				fileLink && "/" === fileLink.slice(0, 1)) {
			
			// 移除多餘的 /
			fileLink = fileLink.substring(1);
		}
		
		fileLinkInfo.link = fileLink;
		
		var parts = fileLink.split("/");
		
		var extension = fileLink.substring(fileLink.lastIndexOf('.'));
		
		fileLinkInfo.displayName = "file " + (linkIndex + 1) + " - " + exportName + extension;
		
		return fileLinkInfo;
	}	
	
	/**
	 * 自動定位 json input 錯誤的位置
	 */
	$scope.autoLocateJsonTxtErrorPosition = function(jsonParsingErrorMessage) {
		
		if (!jsonParsingErrorMessage) return;

		// error message example: Unexpected token s in JSON at position 116
		
		var keyword = "at position ";
		var keywordIndex = jsonParsingErrorMessage.indexOf(keyword);
		if (keywordIndex == -1) return;

		var targetNumberString = jsonParsingErrorMessage.substr(keywordIndex + keyword.length);
		try {
			
			var position = parseInt(targetNumberString);
			
			$(".jsonParameterTxt").prop('selectionEnd', position);
			$(".jsonParameterTxt").focus();
		}
		catch (e) {
			
			// do nothing
		}
	}
	
	/**
	 * 2018-11-29 falcon 取得置換過路徑變量的完整 URL
	 * @param targetString 目標字串
	 */
	$scope.getPathVarReplacedCompletedUrl = function(targetString) {
		
		if (!targetString) return targetString;
		
		var url = targetString;
		if (!this.requestSetting.urlInfo.pathVariables) return url;
		
		var replaceRegexp, pathVariable, name;
		for (var idx in this.requestSetting.urlInfo.pathVariables) {
			
			pathVariable = this.requestSetting.urlInfo.pathVariables[idx];
			
			name = pathVariable.name;
			name = name.replace('{', '\\{');  // {} 是特殊自元, 要加上 \
			name = name.replace('}', '\\}');
			replaceRegexp = new RegExp(name, 'gi');
			url = url.replace(replaceRegexp, pathVariable.value);
		}

		return url;
	}
	
	/**
	 * 取得調用的服務信息
	 * @return 調用的服務信息
	 */
	$scope.getInvocationServiceInfo = function() {
		
		var invocationServiceInfo = { "serviceMode" : this.serviceMode };
		var serviceUrl
		var httpMethod = "POST";
		
		// 2018-7-24 取消請求功能
		var requestUuid = DWUnitTestProject.prototype.generateGuid();
		invocationServiceInfo.requestUuid = requestUuid;
		
		if (this.requestSetting.urlInfo.completedUrl && this.requestSetting.urlInfo.completedUrl.length > 0) {
			
			serviceUrl = this.getPathVarReplacedCompletedUrl(this.requestSetting.urlInfo.completedUrl);
		}
		else {
			
			// 2016-1-7 falcon 使用默認預設的連接
			if (!$scope.requestSetting.urlInfo.basicUrl) {
				
				if (invocationServiceInfo.serviceMode === 2) {
					$scope.requestSetting.urlInfo.basicUrl = settingService.defaultStandardRestfulGatewayUrl;
				}
				else if (invocationServiceInfo.serviceMode === 3) {
					$scope.requestSetting.urlInfo.basicUrl = settingService.defaultEaiGatewayUrl;
				}
				else {
					$scope.requestSetting.urlInfo.basicUrl = settingService.defaultDwgatewayUrl;
				}
			}
			
			var serviceName = this.getPathVarReplacedCompletedUrl($scope.requestSetting.urlInfo.serviceName);
			serviceUrl = $scope.requestSetting.urlInfo.basicUrl;
			if (invocationServiceInfo.serviceMode === 3) {
				
				if ($scope.requestSetting.urlInfo.moduleName === "EAI General Service") {
					
					serviceUrl += "eai";
				}
				else {
					
					serviceUrl += "eai/callback";
				}
			}
			else {
				
				serviceUrl += $scope.requestSetting.urlInfo.moduleName;
				if (!serviceName || (serviceName && !serviceName.startsWith("/"))) {
					
					serviceUrl += "/";
				}
				serviceUrl += serviceName;
				
				if (invocationServiceInfo.serviceMode === 0) {
					
					serviceUrl += "/" + $scope.requestSetting.urlInfo.methodName;
				}
				else {	// 一般和標準資源式
					
					httpMethod = $scope.requestSetting.urlInfo.methodName;
				}
			}
		}
		
		invocationServiceInfo.url = serviceUrl;
		invocationServiceInfo.httpMethod = httpMethod;
		
		if (invocationServiceInfo.serviceMode === 1) {
			
			invocationServiceInfo.httpMethod = $scope.requestSetting.urlInfo.methodName;
		}
		
		// 刷新 UI
		this.responseInfo.url = serviceUrl;
		
		// 2018-7-5 falcon
		invocationServiceInfo.parameterMode = this.requestSetting.parameterMode;
		invocationServiceInfo.jsonParameter = this.requestSetting.jsonParameter;
		
		if (invocationServiceInfo.parameterMode === 1) {
			
			var jsonParamObject = null;
			try {
				
				jsonParamObject = JSON.parse(invocationServiceInfo.jsonParameter);
			}
			catch (e) {
				
				var errorMessage = e.message;
				DWMessage.showError("JSON　參數格式不正確 [ " + errorMessage + " ]!");
				
				this.autoLocateJsonTxtErrorPosition(errorMessage);

				return null;
			}
			
			// convert json parameter object to parameter list
			var newParam;
			var jsonParameters = [];
			for (var propertyName in jsonParamObject) {

				newParam = this.createNewParameter();
				newParam.name = propertyName;
				newParam.value = jsonParamObject[propertyName];
				jsonParameters.push(newParam);
			}
			
			invocationServiceInfo.parameters = jsonParameters.slice();
		}
		else {
			
			invocationServiceInfo.parameters = this.requestSetting.parameters.slice();
		}
		
		// copy array properties
		invocationServiceInfo.headers = this.requestSetting.headers.slice();
		invocationServiceInfo.uploadFiles = this.requestSetting.uploadFiles.slice();
		
		// 加入 冪等性編號 (兼容舊格式, 所以還需判斷 idempotencyInfo 本身)
		if (this.requestSetting.idempotencyInfo && this.requestSetting.idempotencyInfo.pass) {
			
			var idParameter = this.createNewParameter();
			idParameter.name = "$id";
			idParameter.value = this.requestSetting.idempotencyInfo.value;
			
			invocationServiceInfo.parameters.push(idParameter);
		}
		if (this.requestSetting.passRouterKey && this.requestSetting.routerKey) {
			
			if (!invocationServiceInfo.headers) {
				invocationServiceInfo.headers = [];
			}
			var routerKey = this.createNewParameter();
			routerKey.name = "routerKey";
			routerKey.value = this.requestSetting.routerKey;
			invocationServiceInfo.headers.push(routerKey);
		}
		
		return invocationServiceInfo;
	}
	
	/**
	 * 設定 busy
	 * @param busy 是否忙錄
	 */
	$scope.setBusy = function (busy) {
		
		this.tempData.busy = busy ? "1" : "0";
	}
	
	/**
	 * 產生金鑰 Header
	 * @param showMessageAfterDone 刷新之後是否顯示信息
	 * @param parameterIndex 金鑰所在的 index
	 */
	$scope.generateTokenHeader = function(showMessageAfterDone, parameterIndex) {
		
		this.tempData.tokenGettingFailedReason = null;
		var tokenPlugin = getTokenServiceUrl();
		if (tokenPlugin) {
			
			var controller = this;
			this.setBusy(true);
			this.settingRepository.generateToken(DWService).then(
				function(newToken) { // success
					controller.setBusy(false);
					
					var header;
					var foundTokenParameter = false;
					if (angular.isNumber(parameterIndex)) {
						
						header = controller.requestSetting.headers[parameterIndex];
						header.value = newToken;
						foundTokenParameter = true;
					}
					else {

						for (headerIndex in controller.requestSetting.headers) {
							
							header = controller.requestSetting.headers[headerIndex];
							if (header.name === "token" || header.name === "digi-token" || header.name === 'digi-callback-token') {
								
								header.value = newToken;
								foundTokenParameter = true;

								break;
							}
						}
					}

					if (!foundTokenParameter) {
						
						var header = controller.addHeader();
						header.name = "token";
						header.value = newToken;
					}

					if (showMessageAfterDone) {
						DWMessage.showTips("刷新完成");
					}
				},
				function(errorMessage) { // failure
					controller.setBusy(false);

					controller.tempData.tokenGettingFailedReason = errorMessage;
					
					DWMessage.showWarning('取得金鑰失敗, 請檢查金鑰服務的正確性!');
				}
			);
		}
	}
	
	$scope.onKeydown = function(uiEvent) {

    	if (uiEvent.keyCode && uiEvent.keyCode == 9) { // press tab 

    		uiEvent.preventDefault();
    		
    		var target = uiEvent.target;
		    var start = target.selectionStart;
		    var end = target.selectionEnd;

		    // set textarea value to: text before caret + tab + text after caret
		    $(target).val($(target).val().substring(0, start)
		                + "\t"
		                + $(target).val().substring(end));

		    // put caret at right position again
		    target.selectionStart = start + 1;
		    target.selectionEnd = target.selectionStart;
    	}
    }
	
	/**
	 * 2018-11-29 falcon completedUrl 支持變量
	 */
	$scope.onCompletedUrlChanged = function() {
		
		this.buildPathVariables(this.requestSetting.urlInfo.completedUrl);
	}
	
	/**
	 * 2021-5-27 falcon
	 * @param targetString 目標字串
	 * 建置路徑變數
	 */
	$scope.buildPathVariables = function(targetString) {
		
		// 先記錄舊的
		var oldPathVariables = {};
		var variable;
		for (var idx in this.requestSetting.urlInfo.pathVariables) {
			
			variable = this.requestSetting.urlInfo.pathVariables[idx];
			oldPathVariables[variable.name] = variable.value;
		}
		
		this.requestSetting.urlInfo.pathVariables = [];
		if (targetString) {

			var regExp = /\{([^}]+)\}/g;
			var matches = targetString.match(regExp);
			var pathVariable;
			this.requestSetting.urlInfo.pathVariables = [];

			if (matches != null) {
				var name;
				var newPathVariables = {};
				for (var i = 0; i < matches.length; i++) {
					name = matches[i];
	
					// 略過重複的名稱
				    if (newPathVariables.hasOwnProperty(name)) continue;
				    newPathVariables[name] = null;
				    
				    pathVariable = this.createNewParameter();
				    pathVariable.name = name;
				    
				    // 把舊的值 copy 過來
				    if (oldPathVariables[pathVariable.name]) {
				    	
				    	pathVariable.value = oldPathVariables[pathVariable.name];
				    }
	
				    this.requestSetting.urlInfo.pathVariables.push(pathVariable);
				}
			}
		}
	}
	
	/**
	 * 參數模式改變時
	 */
	$scope.onParameterModeChanged = function() {
		
		// do nothing
	}
	
	/**
	 * 服務模組改變時
	 */
	$scope.onServiceModeChanged = function() {
		
		var currentBasicUrlIndex = -1;
		if ($scope.requestSetting.urlInfo.basicUrl) {
			
			var currentServiceMode = this.moduleRepository.getCurrentServiceMode();
			
			var basicUrlIndex;
			if (currentServiceMode === 2) {
				
				currentBasicUrlIndex = $scope.settingRepository.setting.standardRestfulGatewayUrls.indexOf($scope.requestSetting.urlInfo.basicUrl);
			}
			else if (currentServiceMode === 3) {
				
				currentBasicUrlIndex = $scope.settingRepository.setting.eaiGatewayUrls.indexOf($scope.requestSetting.urlInfo.basicUrl);
			}
			else {
		
				currentBasicUrlIndex = $scope.settingRepository.setting.dwgatewayUrls.indexOf($scope.requestSetting.urlInfo.basicUrl);
			} 
		}
		
		this.moduleRepository.switchServiceMode(this.tempData, this.serviceMode);
		
		if (currentBasicUrlIndex != -1) {
			
			var mappingBasicUrl;
			if ($scope.serviceMode === 2) {
				
				mappingBasicUrl = $scope.settingRepository.setting.standardRestfulGatewayUrls[currentBasicUrlIndex];
			}
			else if ($scope.serviceMode === 3) {
				
				mappingBasicUrl = $scope.settingRepository.setting.eaiGatewayUrls[currentBasicUrlIndex];
			}
			else {
		
				mappingBasicUrl = $scope.settingRepository.setting.dwgatewayUrls[currentBasicUrlIndex];
			} 
			
			$scope.requestSetting.urlInfo.basicUrl = mappingBasicUrl;
		}
		
		$scope.requestSetting.urlInfo.moduleName = null;
		$scope.requestSetting.urlInfo.serviceName = null;
		$scope.requestSetting.urlInfo.methodName = null;
	}
	
	/**
	 * 模組名稱改變事件
	 */
	$scope.onModuleNameChanged = function() {
		
		var moduleName = $scope.requestSetting.urlInfo.moduleName;
		DWService.onModuleNameChanged(this.tempData, moduleName);
	}
	
	/**
	 * 服務名稱改變事件
	 */
	$scope.onServiceNameChanged = function() {

		var serviceName = $scope.requestSetting.urlInfo.serviceName;
		DWService.onServiceNameChanged(this.tempData, serviceName);
		
		// 2021-5-27 falcon 建置路徑變數 (Standard Restful 服務支持路徑變數)
		this.buildPathVariables(serviceName);
		
		if ($scope.serviceMode === 3) {
		
			$scope.requestSetting.urlInfo.methodName = "-";
			if (serviceName) {
				
				var virtualEaiMethod = $scope.tempData.currentMethod;
				
				if (!virtualEaiMethod) {
					
					virtualEaiMethod = {};
					virtualEaiMethod.signature = "";
					virtualEaiMethod.description = "";
					virtualEaiMethod.isMock = false;
					
					$scope.tempData.currentMethod = virtualEaiMethod;
				}
			}
			else {
				
				$scope.tempData.currentMethod = null;
			}
		}
	}
	
	/**
	 * 方法名稱改變事件
	 */
	$scope.onMethodNameChanged = function() {
		
		var methodName = $scope.requestSetting.urlInfo.methodName;
		DWService.onMethodNameChanged(this.tempData, methodName);
	}
	
	/**
	 * 分離 JSON Viewer
	 * @param id Viewer 編號
	 */
	$scope.detachJsonViewer = function(viewerId) {
		
		var viewerSelector = "#" + viewerId;
		angular.element(document.querySelector(viewerSelector)).remove();
	}
	/**
	 * 分離所有 JSON Viewer 
	 */
	$scope.detachJsonViewers = function() {
		
		this.detachJsonViewer("systemInfoViewer");
		this.detachJsonViewer("resultViewer");
	}
	
	/**
	 * 附加 JSON Viewer
	 * @param jsonViewer JSON Viewer
	 */
	$scope.attachJsonViewer = function(jsonViewer) {

		var viewerId = jsonViewer.id;
		this.detachJsonViewer(viewerId);

		var viewerContainerSelector = "#" + viewerId + "Container";
		
		// attach
		angular.element(document.querySelector(viewerContainerSelector))[0].appendChild(jsonViewer);
	}
	
	/**
	 * 2016-12-22 falcon 建立 Json Viewer DOM Element
	 * @param id json viewer 編號
	 * @param jsonObject 物件
	 * @return viewer dom element
	 */
	$scope.createJsonViewer = function(id, jsonObject) {
		
		return DWService.jsonViewerAgent.render(id, jsonObject);

		/***** jquery.json-viewer.js 套件 *****/
		// 2018-7-6 falcon 這個套件目前有問題,  從 request 頁切到其他頁之後, 再切回 request 頁時, 如果點擊 收合/展開 會導致整個 request 頁不見
		var options = {
				collapsed: true,
				withQuotes: false,
				showPropertySeq: this.tempData.jsonviewer.showPropertySeq
		};
		// 2018-7-6 falcon 上述 collapsed 的收起設定　在下面生成時機無法取得對象
		// $(jsonViewer).find('a.json-toggle').click(); <--- TODO 全部階層收合方式
		//var viewerObject = $('<pre id="' + id + '"></pre>').jsonViewer(jsonObject, options);
		
		var viewerObject = $('<div id="' + id + '"></div>')
		render(viewerObject[0], jsonObject, options);
		
		return viewerObject[0];

		/***** json-formatter.js 套件 *****/
		var formatter = new JSONFormatter(jsonObject);

		var jsonViewer = formatter.render();
		jsonViewer.id = id;
		
		return jsonViewer;
	}
	
	/**
	 * 2016-12-22 falcon
	 * 建立回應的所有 JSON Viewer
	 * @param serviceResult 服務調用後的結果 
	 */
	$scope.createResponseJsonViewers = function(serviceResult) {
		
		// 建立 system info json viewer
		var systemInfo = serviceResult.getSystemInfo();
		var systemInfoViewer = this.createJsonViewer("systemInfoViewer", systemInfo);
		
		// 建立 result viewer
		var result = serviceResult.getResult();
		var resultViewer = this.createJsonViewer("resultViewer", result);
		
		// 2016-12-9 falcon 保存  viewers (切回 Request 頁時使用)
		this.tempData.resultViewer = resultViewer;
		this.tempData.systemInfoViewer = systemInfoViewer;
		
		// 將 json viewer 加入到 container 中
		this.attachJsonViewer(resultViewer);
		this.attachJsonViewer(systemInfoViewer);
	}
	
	/**
	 * 2018-7-24 falcon 取消請求
	 */
	$scope.cancelRequest = function() {

		DWService.cancelInvoke(this.tempData.requestUuid);
		this.tempData.requestUuid = null;

		this.setBusy(false);
	}
	
	/**
	 * 發送微服務請求
	 */
	$scope.sendDWServiceRequest = function() {
		
		this.responseInfo.data = null;	
		
		// 先移除舊的 jsonViewer
		this.detachJsonViewers();
		
		// 取得 調用的服務信息
		var invocationServiceInfo = this.getInvocationServiceInfo();
		if (invocationServiceInfo == null) return;

		var controller = this;
		
		// 2018-7-24 falcon 取消請求功能
		this.tempData.requestUuid = invocationServiceInfo.requestUuid;
		
		// test repeat send upload file service
		
//		var repeatTimes = 1;
//		for (var i = 0; i < repeatTimes; i++) {
//		
//			console.log("invoke i = " + i);
//			DWService.invoke(invocationServiceInfo);
//		}
//		return;
//		
		// test repeat send upload file service
		
		this.setBusy(true);
		DWService.invoke(invocationServiceInfo).then(
			function(serviceResult) { // success
				
				controller.setBusy(false);
				
				var result = serviceResult.getResult();
				controller.responseInfo.data = JSON.stringify(result);
				controller.responseInfo.status = serviceResult.getStatus();
				controller.responseInfo.success = true;

				// 2017-8-8 falcon 新紀錄的信息
				controller.responseInfo.systemInfo = serviceResult.getSystemInfo();
				
				// 建立回應的所有 JSON Viewer
				controller.createResponseJsonViewers(serviceResult);

				controller.onAfterReceivedDWServiceResponse();
				
				DWMessage.showInfo("回應成功.");
			},
			
			function(serviceResult) { // failure

				controller.setBusy(false);

				DWMessage.showWarning("回應異常!");
				
				var data = serviceResult.getResult();
				controller.responseInfo.data = "failed!";
				controller.responseInfo.status = serviceResult.getStatus();
				controller.responseInfo.success = false;
				
				// 2017-8-8 falcon 新紀錄的信息
				controller.responseInfo.systemInfo = serviceResult.getSystemInfo();

				if (data) {
					controller.responseInfo.data = JSON.stringify(data);
				}

				// 建立回應的所有 JSON Viewer
				controller.createResponseJsonViewers(serviceResult);
				
				controller.onAfterReceivedDWServiceResponse();
				
				// 2017-1-18 falcon 閃動效果
				$("#failedLabel").fadeOut(300).fadeIn(500).fadeOut(300).fadeIn(500);
			}
		);
	}
	
	/**
	 * json-formatter.js 套件使用, jquery.json-viewer 需要重新寫
	 * 收到微服務回應後的事件
	 */
	$scope.onAfterReceivedDWServiceResponse = function() {
		
		this.responseInfo.fileLinks.length = 0;

		var exportName;
		var fileLinkInfo;
		var keyObject, valueObject, innerText, url;
		var keyObjects = document.querySelectorAll(".json-formatter-key");
		for (var keyIdx in keyObjects) {
			
			keyObject = keyObjects[keyIdx];
			innerText = keyObject.innerText;
			
			if(innerText == "exportName:") {
				exportName = keyObject.nextSibling.innerText;
				exportName = eval(exportName);
			}
			
			if (innerText != "partialUrl:" && innerText != "fastDFSUrl:") continue;
			
			valueObject = keyObject.nextSibling;
			if (valueObject && valueObject.className === "json-formatter-string") {
				url = valueObject.innerText;
				fileLinkInfo = this.createFileLinkInfo(this.responseInfo.fileLinks.length, url);
				this.responseInfo.fileLinks[this.responseInfo.fileLinks.length] = fileLinkInfo;
			} else if (valueObject && valueObject.className === "json-formatter-string json-formatter-url") {
				url = valueObject.innerText;
				fileLinkInfo = this.createFastDFSFileLinkInfo(this.responseInfo.fileLinks.length, url, exportName);
				this.responseInfo.fileLinks[this.responseInfo.fileLinks.length] = fileLinkInfo;
			}
		}
	}
	
	/**
	 * 2016-12-26 falcon
	 * 預覽完整參數
	 */
	$scope.previewParameters = function(uiEvent) {
		
		var parameter;
		var jsonObject = {};
		var subJsonObject;
		for (var idx in this.requestSetting.parameters) {
			
			parameter = this.requestSetting.parameters[idx];
			
			try {
			
				subJsonObject = JSON.parse(parameter.value);
				jsonObject[parameter.name] = subJsonObject;
			}
			catch (e) {
				
				// do nothing
				jsonObject[parameter.name] = parameter.value;
			}
		}
		
		var formatDisplay = JSON.stringify(jsonObject, null, "\t");

		var allParameters = {};
		
		allParameters.dialog = {};
		allParameters.dialog.readonly = true;
		allParameters.dialog.title = "發送請求時的最終參數";
		allParameters.name = "最終參數";
		allParameters.value = formatDisplay;		
		this.showParameterEditDialog(uiEvent, allParameters);
	}

	/**
	 * 2016-2-28 falcon
	 * 開啟檔案選取對話框
	 * @index 索引值
	 */
	$scope.openFileDialog = function(index) {
		
		var uploadFileSelector = $("#uploadFileSelector");
		var uploadFileSelectorDom = uploadFileSelector[0];
		
//		uploadFileSelector.attr("targetIndex", index);
//		
//		// 設定為目標上傳檔案的值 (設定路徑)
//		var filePath = this.requestSetting.uploadFiles[index].filePath;
//		//uploadFileSelectorDom.value = filePath ? filePath : "";
//		// 設定檔案物件
//		uploadFileSelectorDom.files.length = 0; // 先清空陣列
//		var file = this.requestSetting.uploadFiles[index].value;
//		if (file) {
//			uploadFileSelectorDom.files[0] = file;
//		}
//		
//		uploadFileSelector.trigger('click'); 
		
		var uploadFileSelector = $(this.requestSetting.uploadFiles[index].selectorDom);
		uploadFileSelector.attr("targetIndex", index);
		uploadFileSelector.trigger('click'); 
	}
	
	$scope.prettyPrintResult = function() {
		
		try {
			
			var content = $("#responseDataTxt").val();
			var jsonObject = JSON.parse(content);
			
			content = JSON.stringify(jsonObject, null, '\t');
			$("#responseDataTxt").val(content);
		}
		catch (e) {
			
			DWMessage.showError("當前結果並非標準 JSON 字符串，無法進行美觀打印操作!");
		}
	}
	
	/**
	 * JSON Viewer 顯示屬性數量 點即時
	 */
	$scope.onJsonViewerDisplayPropertyCountChanged = function() {
		
		onJsonViewerDisplayPropertyCountChanged(this.tempData.jsonviewer, $("#resultViewer"));
	}
	
	$scope.jsonviewerCollapse = function() {

		DWService.jsonViewerAgent.collapse();
		//$("#resultViewer").find("a:not(.collapsed)").click();
	}
	
	$scope.jsonviewerExpand = function() {
		
		DWService.jsonViewerAgent.expand();
		//$("#resultViewer").find("a.json-toggle.collapsed").click();
	}
	
	/**
	 * 選取 upload file 之後
	 */
	$scope.onSelectUploadFile = function(target) {

		var targetIndex = $(target).attr("targetIndex");
		
		var file = null;
		var filePath = null;
		if (target.files.length > 0) {
			file = target.files[0];
			filePath = target.value;
		} 
		
	    setTimeout(function () {
	        $scope.$apply(function () {

	        	$scope.requestSetting.uploadFiles[targetIndex].value = file;
	        	$scope.requestSetting.uploadFiles[targetIndex].filePath = filePath; 
	        });
	    });
	}
	
	$scope.save = function(ev) {

		var confirm = $mdDialog
					  .prompt()
					  .title('儲存HTTP請求')
					  .textContent('請輸入ID')
					  .targetEvent(ev)
					  .ok('儲存')
					  .cancel('取消');

		confirm.initialValue(this.tempData.saveId);
		
		$mdDialog.show(confirm).then(function(id) {

			var value = $scope.requestSetting;

			if ($scope.responseInfo) {
				
				// 2017/8/8 falcon 把  responseInfo 放上 requestSetting 保存出去
				value["responseInfo"] = $scope.responseInfo;
			}
			
			// 2018/5/29 保存模式
			value["serviceMode"] = $scope.serviceMode;
	
			var idWithExtension = id + ".req";
			DWSaveService.postData('request', idWithExtension, value)
			.then(function successCallback(response) {

				// 2017/8/8 刪除附加上去的 responseInfo
				delete $scope.requestSetting.responseInfo;
				
				$scope.tempData.saveId = id;
				DWMessage.showInfo("請求 [ " + id + " ] 保存成功.");
			}, function errorCallback(response) {

				if(response.isConflict()) {
					var confirm = $mdDialog
							   	  .confirm()
							   	  .title('ID重複')
							   	  .textContent('確定儲存?')
							   	  .targetEvent(ev)
							   	  .ok('確定')
							   	  .cancel('取消');

					$mdDialog.show(confirm).then(function() {
						var idWithExtension = id + ".req";
						
						DWSaveService.putData('request', idWithExtension, value)
						.then(function successCallback(response) {
							
							// 2017/8/8 刪除附加上去的 responseInfo
							delete $scope.requestSetting.responseInfo;

							$scope.tempData.saveId = id;
							
							DWMessage.showInfo("請求 [ " + id + " ] 保存成功.");
						}, function errorCallback(response) {
							
							// 2017/8/8 刪除附加上去的 responseInfo
							delete $scope.requestSetting.responseInfo;
							
							DWMessage.showError("請求 [ " + id + " ] 保存失敗!");
						});
					}, function() {
					});
				}
				else {

					// 2017/8/8 刪除附加上去的 responseInfo
					delete $scope.requestSetting.responseInfo;
				}
			});
		}, function() {
		});
	}

	/**
	 * 加載保存的請求
	 */
	$scope.load = function(ev) {
		
		DWSaveService.getDataList('request', false)
		.then(function (userDataModel) {
			
			var url = '/testcenter/views/dwrequester/html/request/load.html';
			var templateUrl = testcenterClientService.convertUrl(url);
			
			$mdDialog.show({
				controller: DialogController,
				templateUrl: templateUrl,
				parent: angular.element(document.body),
				targetEvent: ev,
				clickOutsideToClose:true,
				fullscreen: true, // Only for -xs, -sm breakpoints.
				locals: {
					requestIdList: userDataModel.getResult()
	            }
			}).then(function(requestId) {
				var idWithExtension = requestId + ".req";
				
				DWSaveService.getData('request', idWithExtension)
				.then(function successCallback(userDataModel) {
					
					$scope.requestSetting = userDataModel.getResult();
					$scope.tempData.saveId = requestId;
					
					if ($scope.requestSetting["serviceMode"] != undefined) {
					
						$scope.serviceMode = $scope.requestSetting["serviceMode"];
					}
					if ($scope.requestSetting["parameterMode"] == undefined) {
						
						$scope.requestSetting.parameterMode = 0;
					}

					// 2017-8-8 falcon 讀取回 responseInfo
					if ($scope.requestSetting["responseInfo"]) {

						try {
							$scope.responseInfo = $scope.requestSetting["responseInfo"];
							
							delete $scope.requestSetting.responseInfo;
							
							var systemInfo = $scope.responseInfo["systemInfo"];
							//delete $scope.responseInfo.systemInfo;
							var fakeServiceResult = {};
							
							fakeServiceResult.getSystemInfo = function() { return systemInfo };
							fakeServiceResult.getResult = function() {
								
								if (!$scope.responseInfo.data) return null;
								
								var JSONObject;
								
								try {
									
									JSONObject = JSON.parse($scope.responseInfo.data);
								}
								catch (e) {
									
									JSONObject = $scope.responseInfo.data;
								}
								
								return JSONObject;
							};				
	
							// 建立回應的所有 JSON Viewer
							$scope.createResponseJsonViewers(fakeServiceResult);
							$scope.onAfterReceivedDWServiceResponse();
						}
						catch (e) {

							DWMessage.showInfo("無法加載 [ " + requestId + " ] 回應信息.");
						}
					}
					else {
						$scope.initResponseInfo();
						// 移除舊的 jsonViewer
						$scope.detachJsonViewers();
					}
					
					DWMessage.showInfo("請求檔 [ " + requestId + " ] 載入完畢.");
					
					// 2016-12-9 falcon 刷新 currentMethod
					$scope.onModuleNameChanged();
					$scope.onServiceNameChanged();
					$scope.onMethodNameChanged();
					
					$scope.rebuildUploadFileSelectorDoms();
				}, function errorCallback(userDataModel) {
					
					DWMessage.showError("讀取請求檔 [ " + requestId + " ] 失敗!");
				});
		    }, function() {
		    });
		}, function (response) {
			
			if (response.status == -1) {
				
				DWMessage.showError("無法連接  DWRequester 服務器!");
			}
		});
	}
	
	function DialogController($scope, $mdDialog, requestIdList) {
		
		$scope.requestIdList = requestIdList;
		$scope.requestId;
		$scope.searchText;
		
		$scope.onSelect = function(requestId) {
			$scope.requestId = requestId;
	    };

	    $scope.cancel = function() {
	    	$mdDialog.cancel();
	    };

	    $scope.remove = function(requestId) {
	    	
	    	if(confirm("確定刪除?")) {
	    		var idWithExtension = requestId + ".req";
	    		DWSaveService.deleteData('request', idWithExtension)
	    		.then(function successCallback(response) {
	    			
	    			DWSaveService.getDataList('request', true)
	    			.then(function successCallback(response) {
	    				$scope.requestIdList = response.data;
	    			}, function errorCallback(response) {
	    			});
	    		}, function errorCallback(response) {
	    			console.log(response);
	    		});
	    	}
	    };	    
	    
	    $scope.ok = function() {
	    	$mdDialog.hide($scope.requestId);
	    };
	    
		$scope.onSearch = function() {
			$scope.requestIdList = jLinq.from(requestIdList)
										.ignoreCase()
										.match("documentId", $scope.searchText)
										.select();
		};
		
		$scope.onSearchTextClear = function() {
			$scope.searchText = "";
			$scope.requestIdList = requestIdList;
		};
	}
	
	$scope.downloadRequestData = function(ev) {

		DWSaveService.getDataList('request', true)
		.then(function successCallback(response) {
			
			var url = '/testcenter/views/dwrequester/html/request/downloadDialog.html';
			var templateUrl = testcenterClientService.convertUrl(url);
			
			var requestIdList = [];
			response.data.forEach(function(entry) {
				requestIdList.push(entry.documentId);
			});
			
			$mdDialog.show({
				controller: DownloadDialogController,
				templateUrl: templateUrl,
				parent: angular.element(document.body),
				targetEvent: ev,
				clickOutsideToClose:true,
				fullscreen: true, // Only for -xs, -sm breakpoints.
				locals: {
					requestIdList: requestIdList
	            }
			}).then(function() {
		    }, function() {
		    });
		}, function errorCallback(response) {
		});		
	}

	function DownloadDialogController($scope, $mdDialog, requestIdList) {
		
		$scope.requestIdList = requestIdList;
		
	    $scope.close = function() {
	    	$mdDialog.cancel();
	    };
		
	    var base64ToBlob = function(b64Data, contentType, sliceSize) {
	    	
	        contentType = contentType || '';
	        sliceSize = sliceSize || 512;

	        var byteCharacters = atob(b64Data);
	        var byteArrays = [];

	        for (var offset = 0; offset < byteCharacters.length; offset += sliceSize) {
	          var slice = byteCharacters.slice(offset, offset + sliceSize);

	          var byteNumbers = new Array(slice.length);
	          for (var i = 0; i < slice.length; i++) {
	            byteNumbers[i] = slice.charCodeAt(i);
	          }

	          var byteArray = new Uint8Array(byteNumbers);

	          byteArrays.push(byteArray);
	        }
	        
	        var blob = new Blob(byteArrays, {type: contentType});
	        return blob;
	    };
	    
		$scope.onDownload = function() {
			
			var filenameArray = [];
			
			$scope.selected.forEach(function(entry) {
				filenameArray.push(entry+".req");
			});
			
			if(filenameArray.length==0) {
				DWMessage.showWarning("請選擇下載檔案!");
				return;
			}
			
			DWSaveService.downloadData('request', JSON.stringify(filenameArray))
			.then(function successCallback(response) {
				
				var blob = base64ToBlob(response.data, 'application/zip');
				
				var contentDispositionHeader = response.headers('Content-Disposition');
				var filename = contentDispositionHeader.split(';')[1].trim().split('=')[1].replace(/"/g, '');

		        saveAs(blob, filename);
				
			}, function errorCallback(response) {

			});
		};
		
		$scope.selected = [];
		$scope.toggle = function (item, list) {
			var idx = list.indexOf(item);
			if(idx>-1) {
				list.splice(idx, 1);
		    } else {
		    	list.push(item);
		    }
		};

		$scope.exists = function (item, list) {
			return list.indexOf(item)>-1;
		};

		$scope.isIndeterminate = function() {
			return ($scope.selected.length!==0 &&
					$scope.selected.length!==$scope.requestIdList.length);
		};

		$scope.isChecked = function() {
			return $scope.selected.length === $scope.requestIdList.length;
		};

		$scope.toggleAll = function() {
			if($scope.selected.length===$scope.requestIdList.length) {
				$scope.selected = [];
		    } else if($scope.selected.length===0 || $scope.selected.length>0) {
		    	$scope.selected = $scope.requestIdList.slice(0);
		    }
		};
	}
});

app.directive('fileModel', ['$parse', function ($parse) {
	return {
		restrict: 'A',
        link: function(scope, element, attrs) {
            var model, modelSetter;

            attrs.$observe('fileModel', function(fileModel){
                model = $parse(attrs.fileModel);
                modelSetter = model.assign;
            });

            element.bind('change', function(){
                scope.$apply(function(){
                    modelSetter(scope.$parent, element[0].files[0]);
                });
            });
        }
	};
}]);

app.directive("fileread", [function () {
    return {
        scope: {
            fileread: "="
        },
        link: function (scope, element, attributes) {
            element.bind("change", function (changeEvent) {
                scope.$apply(function () {
                    scope.fileread = changeEvent.target.files[0];
                });
            });
            
            scope.$watch('uploadFile.value', function(newValue, oldValue) {
                if (newValue)
                    console.log("I see a data change!");  // Delete this later
                    scope.ngModel = scope.imageId;
            }, true);
        }
    }
}]);