var app = angular.module('app');

app.controller('sqlutilityController',
	function($scope, $http, $mdDialog, DWMessage, DWService, settingService,
			parameterStorage, DWSaveService, configService, testcenterClientService) {
	
	$scope.serverType = testcenterClientService.getServerType();
	
	$scope.sqlInfo = {};	
	$scope.sqlInfo.sqlPrefix = "Preparing: ";
	$scope.sqlInfo.parameterPrefix = "==> Parameters: ";
	$scope.sqlInfo.parameterSeperator = ", ";
	
	$scope.sqlInfo.parser = [];
	$scope.sqlInfo.parser[0] = {};
	$scope.sqlInfo.parser[0].name = "MyBatis SQL Log Parser";
	$scope.sqlInfo.parser[0].sqlPrefix = "Preparing: ";
	$scope.sqlInfo.parser[0].parameterPrefix = "==> Parameters: ";
	$scope.sqlInfo.parser[0].parameterSeperator = ", ";
	
	$scope.sqlInfo.parser[1] = {};
	$scope.sqlInfo.parser[1].name = "DAP1.0 SQL Log Parser";
	$scope.sqlInfo.parser[1].sqlPrefix = "[SQL.statement]";
	$scope.sqlInfo.parser[1].parameterPrefix = "[SQL.params]";
	$scope.sqlInfo.parser[1].parameterSeperator = ", ";

	$scope.clearParameterInfo = function() {

		this.sqlInfo.parameterInfo = {};
		this.sqlInfo.parameterInfo.items = [];
	}
	
	// 清除參數
	$scope.clearParameterInfo();
	
	/**
	 * 分析日誌
	 */
	$scope.analyze = function(ev) {
		
		this.clearParameterInfo();

		var sqlLog = this.sqlInfo.log;
		if (sqlLog) {
			
			var parser = this.sqlInfo.parser[0];
			for (var idx in this.sqlInfo.parser) {

				if (sqlLog.indexOf(this.sqlInfo.parser[idx].sqlPrefix) != -1) {
					
					parser = this.sqlInfo.parser[idx];
					break;
				}
			}
			
			var sqlPrefixIndex = sqlLog.indexOf(parser.sqlPrefix);
			var sqlPrefixEndIndex = sqlPrefixIndex + parser.sqlPrefix.length;
			
			var parameterPrefixIndex = sqlLog.indexOf(parser.parameterPrefix);
			var parameterPrefixEndIndex = parameterPrefixIndex + parser.parameterPrefix.length;
			
			var sqlLength = parameterPrefixIndex - sqlPrefixEndIndex;
			
			// prepared statement
			this.sqlInfo.preparedStatement = sqlLog.substr(sqlPrefixEndIndex, sqlLength);
			
			// parameter raw data
			this.sqlInfo.parameterInfo.rawData = sqlLog.substr(parameterPrefixEndIndex);
			
			var newParameter;
			var rawParameters = this.sqlInfo.parameterInfo.rawData.split(parser.parameterSeperator);
			for (var idx in rawParameters) {
				
				newParameter = this.addParameter(rawParameters[idx]);
			}
			
			// 分析參數位置和群組
			this.analyzeParameterLocationInfo();
		}
	}
	
	/**
	 * 分析參數所在位置信息
	 */
	$scope.analyzeParameterLocationInfo = function() {

		var sourceSql = this.sqlInfo.preparedStatement;

		var regex = new RegExp("\(\( \? \))", "g");
		var result, targetItem;
		var matchItems = [];
		
		do
		{
			result = regex.exec(sourceSql);
			
			if (result != null) {
				
				targetItem = {};
				targetItem.content = result[0];
				targetItem.index = result.index;
				
				matchItems[matchItems.length] = targetItem;
			}
		}
		while (result != null);
		
		var finished = false;
		var parameter = null;
		var parameterIndex = -1;
		var currentGroupStartIndex;
		var parameterLocationIndex;
		var currentGroupIndex = -1;
		var currentGroup;
		var groupInfo = [];
		this.sqlInfo.parameterInfo.groupInfo = groupInfo;
		
		while (1==1){
			
			parameterLocationIndex = sourceSql.indexOf("?");
			if (parameterLocationIndex == -1) {
				
				break;
			}
			
			parameterIndex++;
			
			for (var current = parameterLocationIndex - 1; current >= 0; current--) {
				
				// 找到 ? 前一個字元為 ( 或是已經到了第 0 個字元 就將群組加 1
				if (sourceSql.charAt(current) == "(" || current == 0) {
					
					if (sourceSql.charAt(current) != "(") {
						
						currentGroupStartIndex = parameterLocationIndex;
					}
					else {
					
						currentGroupStartIndex = current;
					}

					break;
				}
			}
			
			if (!currentGroup || currentGroup.startIndex != currentGroupStartIndex) {
				
				currentGroupIndex++;
				
				currentGroup = {};
				currentGroup.seq = currentGroupIndex;
				currentGroup.parameters = [];
				groupInfo[groupInfo.length] = currentGroup;
				currentGroup.startIndex = currentGroupStartIndex;
			}
			
			for (var current = parameterLocationIndex + 1; current < sourceSql.length; current++) {

				if (sourceSql.charAt(current) == ")" || current == sourceSql.length - 1) {
					if (sourceSql.charAt(current) == ")") {
						currentGroup.endIndex = current;
					}
					else {
						
						currentGroup.endIndex = parameterLocationIndex;
					}

					break;
				}
			}
			
			if (this.sqlInfo.parameterInfo.items.length > parameterIndex) {
				
				parameter = this.sqlInfo.parameterInfo.items[parameterIndex];
			}
			
			currentGroup.parameters[currentGroup.parameters.length] = parameter;
			
			// 更換 ? 為  ^
			sourceSql = sourceSql.substr(0, parameterLocationIndex) + "^" + sourceSql.substr(parameterLocationIndex + 1);
		}
		
	}
	
	
	/**
	 * 增加參數
	 */
	$scope.addParameter = function(parameterStr) {

		var length = this.sqlInfo.parameterInfo.items.length;
		var newParameter = this.createNewParameter();
		this.sqlInfo.parameterInfo.items[length] = newParameter;
		
		newParameter.name = length;
		
		var typeLeftBraceIndex = parameterStr.indexOf("(");
		
		newParameter.value = parameterStr.substr(0, typeLeftBraceIndex);
		newParameter.type = parameterStr.substr(typeLeftBraceIndex);
		
		return newParameter;
	}
	
	/**
	 * 建立新的參數
	 */
	$scope.createNewParameter = function() {
		
		var instance = { "name":null, "value":null, "type":null };
		return instance;
	}
	
	/**
	 * 取得顯示的 SQL
	 */
	$scope.getDisplaySql = function() {
		
		var parameterIndex = 0;
		
		var parameterSize = this.sqlInfo.parameterInfo.items.length;
		var parameter, parameterValue, parameterLocationIndex;
		var displaySql = this.sqlInfo.preparedStatement;
		
		if (!displaySql) return "";
		
		var displaySqlParameterSize;
		var stringType = "(String)";
		var value;
		for (var i = 0; i < parameterSize; i++) {
			
			parameter = this.sqlInfo.parameterInfo.items[i];
			parameterValue = parameter.value;
			
			parameterLocationIndex = displaySql.indexOf("?");
			if (stringType === parameter.type) {
				
				value = "'" + parameterValue + "'";
			}
			else {
				
				value = parameterValue;
			}
			
			displaySql = displaySql.substr(0, parameterLocationIndex) + value + displaySql.substr(parameterLocationIndex + 1);
			
			if (parameterLocationIndex == -1) {
				
				displaySqlParameterSize = i + 1;
				break;
			}
		}
		
		displaySqlParameterSize = parameterSize;
		parameterLocationIndex = displaySql.indexOf("?");		
		if (parameterLocationIndex != -1) {
			
			displaySqlParameterSize += 1;
		}
		
		return displaySql;
	}

});
