﻿﻿
function getServerPort() {
	return "http://localhost:8080";
	// return "http://localhost:8080";
}

function getBasicUrlList() {
	
	return [
		// "http://localhost:8080/DWGateway.Server/restful",
		"http://localhost:8080/DWGateway/restful"
	];
}

// 取得歷史參數值清單
function getHistoryParameterValues() {

	// 2017/9/4 falcon 暫無歷史參數值的需求
	return [];

	/*return [
		{ "displayName":"背景圖報表", "value": { "moduleName":"FEG", "serviceName":"IFarEastToneTelecomService", "methodName":"getDemoReportDataSource", "parameters":{ "parameters":null } } },
		{ "displayName":"Bean Collection 報表", "value" : { "moduleName":"FEG", "serviceName":"IFarEastToneTelecomService", "methodName":"getCallDetailsReport", "parameters":null } },
	  { "displayName":"查詢費率", "value":{"moduleName":"FEG","serviceName":"IFarEastToneTelecomService","methodName":"queryFee","parameters":{"minutes":5}} },
	  { "displayName":"取得帳單", "value":{"moduleName":"FEG","serviceName":"IFarEastToneTelecomService","methodName":"getBill"} },
	  { "displayName":"IVY_CreateSrv", "value": { "stockInID": "test", "serviceId": "StockInCreate",	"bDate": "20180101", "memo": "", "status": "0",	"docType":"1", "oType": "0", "ofNO": "0", "loadDocType":"0", "loadDocNO":"10001", "datas": [ { "item": "1", "oItem": "1", "pluNO": "99977520", "featureNO": "2001", "punit": "101", "pqty": "3.00", "receivingqty": "3.00", "price": "100.00", "amt": "300.00", "pluBarcode": "1111111" }] } },
	];*/
}

function getModuleListServiceUrl() {
	
	return getBasicUrlList()[0] + "/" + "RequestHelper/IModuleInfoService/getModuleInfos";
	// return null;
}

function getTokenServiceUrl() {
	return [ getBasicUrlList()[0] + "/" + "DemoAP/DemoLoginService/login",
		{ "userId" : "user001", "password" : "001", "language" : "zh_TW" }
	];
	return [ getBasicUrlList()[0] + "/" + "FEG/ILoginService/login",	// login service partial url
		// { "id" : "test", "password" : "test", "mode" : 1 } // login service parameters
		{ "id" : "00320", "password" : "00320", "mode" : 1 }
	];
}

// 2016-11-22 falcon
function getTokenServiceInfo() {
	
	var serviceInfo = {};
	serviceInfo.url = getBasicUrlList()[0] + "/" + "DemoAP/DemoLoginService/login";
	
	var parameters = [];
	parameters[0] = { name:"id", value:"00320" };
	parameters[1] = { name:"password", value:"00320" };
	parameters[2] = { name:"language", value:"zh_TW" };
	
	serviceInfo.parameters = parameters;
	
	return serviceInfo;
}

function getModuleList() {
	
	return [
		/*{
			"name": "TestService",
			"services": [
				"ITestService.upload(data001, *file002)"
			]
		},
		{
			"name": "testing",
			"services": [
				"IDemoServiceA.getPrinters()"
			]
		},
		{
			"name": "DigiwinADLoginService",
			"services": [
				"ILoginService.execute(userId, password)",
				"ILoginService.hardcodeExecute(userId, password)"
			]
		},*/
		{
			"name": "PDFPrinter",
			"services": [
				"IPDFPrintService.getPrinters()",
				"IPDFPrintService.print(printServiceName, *pdfFile)"
			]
		},
	]
}

function getModuleObjects() {
	
	var parts, moduleIdx, srvIdx;
	var serviceName, methodName;
	var modules = getModuleList();
	var module, serviceInfo, srvInfoObj;
	var result = [];
	var distinctServiceListObject, distinctServiceInfo;
	for (moduleIdx in modules) {
		
		module = modules[moduleIdx];
		module.serviceList = [];

		distinctServiceListObject = {};
		result[result.length] = module;
		for (srvIdx in module.services) {
			
			serviceInfo = module.services[srvIdx];
			srvInfoObj = createServiceInfoObject(serviceInfo);
			if (srvInfoObj) {
				module.serviceList[module.serviceList.length] = srvInfoObj;
				
				distinctServiceInfo = distinctServiceListObject[srvInfoObj.name];
				if (distinctServiceInfo == undefined) {
					
					distinctServiceInfo = { "name":srvInfoObj.name, "methodList":[] };
					distinctServiceListObject[srvInfoObj.name] = distinctServiceInfo;
				}

				distinctServiceInfo.methodList[distinctServiceInfo.methodList.length] = srvInfoObj;
			}
		}
	
		for (srvName in distinctServiceListObject) {
			module.serviceList[module.serviceList.length] = distinctServiceListObject[srvName];
		}
	}
	
	return result;
}

function createServiceInfoObject(serviceInfo) {
	var instance = {};
	
	var parts = serviceInfo.split('.');
	
	// service name
	instance.name = parts[0];
	instance.parameters = [];
	instance.files = [];
	
	var methodInfo = parts[1];
	
	instance.method = methodInfo.substring(0, methodInfo.indexOf("("));
	var parameterInfo = methodInfo.substring(methodInfo.indexOf("("));
	instance.signature = parameterInfo;
	instance.displayName = methodInfo;
	
	var parameterName;
	parameters = parameterInfo.split(',');
	for (paramIdx in parameters) {
			
		parameterName = parameters[paramIdx].trim().replace(/[\(,\)]/g, "");
		if (parameterName.length == 0) {
			continue;
		}
		if (parameterName.indexOf("*") == 0) {
			instance.files[instance.files.length] = parameterName.substring(1);
		}
		else {
			instance.parameters[instance.parameters.length] = parameterName;
		}
	}
	
	return instance;
}