/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mcp.config;

import com.digiwin.mcp.entity.McpFunctionInfo;
import com.digiwin.mcp.entity.annotation.McpFunction;
import com.digiwin.mcp.entity.annotation.McpHeaderParam;
import com.digiwin.mcp.entity.annotation.McpParam;
import com.digiwin.mcp.entity.annotation.McpServerEndpoint;
import com.digiwin.mcp.interceptor.McpStreamableHttpHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPatternParser;

/*
 * Exception performing whole class analysis ignored.
 */
public class McpServerEndpointAutoRegistry
implements BeanPostProcessor,
ApplicationContextAware,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(McpServerEndpointAutoRegistry.class);
    private ApplicationContext applicationContext;
    private BeanFactory beanFactory;
    private WebMvcProperties webMvcProperties;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.webMvcProperties = (WebMvcProperties)applicationContext.getBean(WebMvcProperties.class);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClass = bean.getClass();
        McpServerEndpoint annotation = beanClass.getAnnotation(McpServerEndpoint.class);
        if (annotation != null) {
            String path = annotation.value();
            try {
                List functionInfos = this.collectMcpFunctions(beanClass);
                BeanDefinitionRegistry beanRegistry = (BeanDefinitionRegistry)this.beanFactory;
                String handlerBeanName = beanClass.getSimpleName() + "@McpServerEndpoint";
                BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(McpStreamableHttpHandler.class);
                beanRegistry.registerBeanDefinition(handlerBeanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
                McpStreamableHttpHandler handler = (McpStreamableHttpHandler)this.applicationContext.getBean(handlerBeanName);
                handler.setName(annotation.name());
                handler.setVersion(annotation.version());
                handler.setTargetBean(bean);
                handler.setFunctionInfos(functionInfos);
                this.registerMcpServerEndpoint(path, (Object)handler);
                log.info("Mcp\u670d\u52a1\u63a5\u53e3\u521b\u5efa\u6210\u529f: {}", (Object)path);
            }
            catch (Exception e) {
                log.error("Mcp\u670d\u52a1\u63a5\u53e3\u521b\u5efa\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                log.error("Mcp\u670d\u52a1\u63a5\u53e3\u521b\u5efa\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return bean;
    }

    private List<McpFunctionInfo> collectMcpFunctions(Class<?> beanClass) {
        Method[] methods = beanClass.getDeclaredMethods();
        ArrayList<McpFunctionInfo> functionInfos = new ArrayList<McpFunctionInfo>();
        for (Method method : methods) {
            McpFunction mcpFunction = method.getAnnotation(McpFunction.class);
            if (mcpFunction == null) continue;
            Map map = McpServerEndpointAutoRegistry.collectFunctionParamInfos((Method)method);
            McpFunctionInfo functionInfo = new McpFunctionInfo(mcpFunction.name(), mcpFunction.description(), method, (List)map.get("body"), (List)map.get("header"));
            functionInfos.add(functionInfo);
        }
        return functionInfos;
    }

    private static Map<String, List<McpFunctionInfo.ParamInfo>> collectFunctionParamInfos(Method method) {
        Parameter[] parameters = method.getParameters();
        HashMap<String, List<McpFunctionInfo.ParamInfo>> maps = new HashMap<String, List<McpFunctionInfo.ParamInfo>>(2);
        ArrayList<McpFunctionInfo.ParamInfo> paramInfos = new ArrayList<McpFunctionInfo.ParamInfo>();
        ArrayList<McpFunctionInfo.ParamInfo> headerParamInfos = new ArrayList<McpFunctionInfo.ParamInfo>();
        for (Parameter parameter : parameters) {
            McpFunctionInfo.ParamInfo paramInfo;
            McpParam mcpParam = parameter.getAnnotation(McpParam.class);
            McpHeaderParam headerParam = parameter.getAnnotation(McpHeaderParam.class);
            if (mcpParam != null) {
                paramInfo = new McpFunctionInfo.ParamInfo(mcpParam.name(), mcpParam.description(), mcpParam.enums(), mcpParam.required());
                paramInfos.add(paramInfo);
            }
            if (headerParam == null) continue;
            paramInfo = new McpFunctionInfo.ParamInfo(headerParam.name(), headerParam.description(), headerParam.enums(), headerParam.required());
            headerParamInfos.add(paramInfo);
        }
        maps.put("body", paramInfos);
        maps.put("header", headerParamInfos);
        return maps;
    }

    private void registerMcpServerEndpoint(String path, Object bean) throws NoSuchMethodException {
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)this.applicationContext.getBean(RequestMappingHandlerMapping.class);
        RequestMappingInfo.BuilderConfiguration config = new RequestMappingInfo.BuilderConfiguration();
        if (this.webMvcProperties.getPathmatch().getMatchingStrategy() == WebMvcProperties.MatchingStrategy.PATH_PATTERN_PARSER) {
            config.setPatternParser(new PathPatternParser());
        } else {
            config.setPathMatcher((PathMatcher)new AntPathMatcher());
        }
        RequestMappingInfo handleGet = RequestMappingInfo.paths((String[])new String[]{path}).methods(new RequestMethod[]{RequestMethod.GET}).headers(new String[0]).options(config).build();
        mapping.registerMapping(handleGet, bean, McpStreamableHttpHandler.class.getMethod("handleGet", new Class[0]));
        RequestMappingInfo handlePost = RequestMappingInfo.paths((String[])new String[]{path}).methods(new RequestMethod[]{RequestMethod.POST}).options(config).build();
        mapping.registerMapping(handlePost, bean, McpStreamableHttpHandler.class.getMethod("handlePost", String.class, Map.class));
    }
}

