/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mcp.entity;

import com.digiwin.mcp.entity.AdtExtData;
import com.digiwin.mcp.entity.AdtMessage;
import java.io.Serializable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AdtRequest
implements Serializable {
    private static final long serialVersionUID = 3168649668979576733L;
    private String assistantId;
    private AdtMessage message;

    public static AdtRequest build(String question, String appCode, String datasetId) {
        AdtRequest adtRequest = new AdtRequest();
        adtRequest.setAssistantId(appCode);
        AdtMessage message = new AdtMessage();
        message.setContent(question);
        AdtExtData extData = new AdtExtData();
        extData.setMsg(question);
        extData.setAsaCode(appCode);
        if (StringUtils.hasText((String)datasetId)) {
            extData.setDatasetIdList(CollectionUtils.arrayToList((Object)datasetId.split(",")));
        }
        message.setExtData(extData);
        adtRequest.setMessage(message);
        return adtRequest;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public AdtMessage getMessage() {
        return this.message;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public void setMessage(AdtMessage message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdtRequest)) {
            return false;
        }
        AdtRequest other = (AdtRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$assistantId = this.getAssistantId();
        String other$assistantId = other.getAssistantId();
        if (this$assistantId == null ? other$assistantId != null : !this$assistantId.equals(other$assistantId)) {
            return false;
        }
        AdtMessage this$message = this.getMessage();
        AdtMessage other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdtRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $assistantId = this.getAssistantId();
        result = result * 59 + ($assistantId == null ? 43 : $assistantId.hashCode());
        AdtMessage $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "AdtRequest(assistantId=" + this.getAssistantId() + ", message=" + this.getMessage() + ")";
    }

    public AdtRequest() {
    }

    public AdtRequest(String assistantId, AdtMessage message) {
        this.assistantId = assistantId;
        this.message = message;
    }
}

