/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mcp.interceptor;

import com.digiwin.mcp.entity.ResponseStatus;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpRetryInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(OkHttpRetryInterceptor.class);
    private Integer retryCount;
    private Integer retryDelayMills;
    public static final List<String> RETRY_HTTP_CODE = Collections.unmodifiableList(Arrays.asList(ResponseStatus.HTTP_STATUS_500.getResponseCode(), ResponseStatus.HTTP_STATUS_502.getResponseCode(), ResponseStatus.HTTP_STATUS_503.getResponseCode()));

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.retry(chain, 0);
    }

    private Response retry(Interceptor.Chain chain, int retryNums) {
        Response response;
        block5: {
            Request request = chain.request();
            response = null;
            try {
                log.info("OkHttp\u7b2c{}\u6b21\u8c03\u7528\u63a5\u53e3{}\uff0c\u8be6\u7ec6\u8bf7\u6c42:{}", new Object[]{retryNums, request.url(), request.toString()});
                response = chain.proceed(request);
                if (RETRY_HTTP_CODE.contains(response.code()) && this.retryCount > retryNums) {
                    TimeUnit.MILLISECONDS.sleep(this.retryDelayMills.intValue());
                    return this.retry(chain, retryNums + 1);
                }
            }
            catch (Exception e) {
                if (retryNums >= this.retryCount) break block5;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryDelayMills.intValue());
                }
                catch (InterruptedException ex) {
                    log.error("\u8bf7\u6c42\u63a5\u53e3{}\u5931\u8d25\uff0c\u539f\u56e0{}", (Object)request.url(), (Object)ex.getMessage());
                }
                return this.retry(chain, retryNums + 1);
            }
        }
        return response;
    }

    public OkHttpRetryInterceptor() {
    }

    public OkHttpRetryInterceptor(Integer retryCount, Integer retryDelayMills) {
        this.retryCount = retryCount;
        this.retryDelayMills = retryDelayMills;
    }
}

