/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mcp.tool;

import com.digiwin.mcp.entity.AdtRequest;
import com.digiwin.mcp.entity.agiledata.BizParams;
import com.digiwin.mcp.entity.agiledata.Snapshot;
import com.digiwin.mcp.entity.annotation.McpFunction;
import com.digiwin.mcp.entity.annotation.McpParam;
import com.digiwin.mcp.entity.annotation.McpServerEndpoint;
import com.digiwin.mcp.util.JsonUtil;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@McpServerEndpoint(value="/mcp", version="1.0.0", name="\u5929\u6c14\u67e5\u8be2\u670d\u52a1")
public class ToolComponent {
    private static final Logger log = LoggerFactory.getLogger(ToolComponent.class);
    @Value(value="${iam.url}")
    private String iamUrl;
    @Value(value="${adt.url}")
    private String adtUrl;
    @Value(value="${iam.appToken}")
    private String appToken;
    private final OkHttpClient okHttpClient;
    private String ERR_MESSAGE = "\u7528\u6236token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u6216\u8054\u7cfb\u5ba2\u670d\u4e13\u5458";

    public ToolComponent(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @McpFunction(name="getAgileData", description="\u83b7\u53d6\u654f\u6377\u6570\u636e\u4fe1\u606f")
    public Object getAgileData(@McpParam(name="question", required=true, description="\u5165\u53c2\u4e3a\u95ee\u53e5\uff0c\u8bf7\u4f20\u5165\u95ee\u53e5") String question, @McpParam(name="appCode", required=true, description="\u5165\u53c2\u4e3a\u5e94\u7528\uff0c\u8bf7\u4f20\u5165\u5e94\u7528\u7f16\u7801") String appCode, @McpParam(name="datasetId", description="\u5165\u53c2\u4e3a\u6570\u636e\u96c6\u5217\u8868\uff0c\u53ef\u4f20\u5165\u6570\u636e\u96c6\u7f16\u7801\u96c6\u5408,\u4ee5','\u5206\u5272") String datasetId, @McpParam(name="token", description="\u5165\u53c2\u4e3a\u9f0e\u6377\u7684\u7528\u6237token,\u8bf7\u4f20\u5165\u9f0e\u6377\u4e91\u7684userToken", required=true) String token) throws SQLException {
        Map checkMap = this.checkToken(token);
        if (!CollectionUtils.isEmpty((Map)checkMap)) {
            return checkMap;
        }
        AdtRequest adtRequest = AdtRequest.build((String)question, (String)appCode, (String)datasetId);
        RequestBody requestBody = RequestBody.create((String)JsonUtil.getJsonString((Object)adtRequest), (MediaType)MediaType.parse((String)"application/json"));
        log.error("\u63a5\u6536\u5230\u7684\u5165\u53c2\u4e3a:{}", (Object)JsonUtil.getJsonString((Object)adtRequest));
        Request okHttpRequest = new Request.Builder().url(this.adtUrl + "/api/ai/agileData/mcp/processMessage").method("POST", requestBody).header("digi-middleware-auth-app", this.appToken).header("digi-middleware-auth-user", token).build();
        try (Response okHttpResponse = this.okHttpClient.newCall(okHttpRequest).execute();){
            if (!okHttpResponse.isSuccessful()) {
                if (okHttpResponse.body() == null) return "\u654f\u6570\u670d\u52a1\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
                Object v = JsonUtil.json2Map((String)okHttpResponse.body().string()).get("msg");
                return v;
            }
            Map reponseMap = JsonUtil.json2Map((String)okHttpResponse.body().string());
            if (reponseMap.get("response") == null) return "\u654f\u6570\u670d\u52a1\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
            if (!(reponseMap.get("response") instanceof Map)) return "\u654f\u6570\u670d\u52a1\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
            HashMap response = new HashMap(2);
            String traceId = "";
            if (reponseMap.get("traceId") != null && StringUtils.hasText((String)String.valueOf(reponseMap.get("traceId")))) {
                traceId = (String)reponseMap.get("traceId");
            }
            if (((Boolean)((Map)reponseMap.get("response")).get("result")).booleanValue() && ((Map)reponseMap.get("response")).get("snapShotDTO") != null) {
                Snapshot snapshot = (Snapshot)JsonUtil.getObject((String)JsonUtil.getJsonString(((Map)reponseMap.get("response")).get("snapShotDTO")), Snapshot.class);
                log.error("\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a:{}", (Object)JsonUtil.getJsonString((Object)snapshot.getContext()));
                if (snapshot.getContext() == null) return "\u654f\u6570\u670d\u52a1\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
                response.put("data", snapshot.getContext().getPullData());
                BizParams bizParams = snapshot.getContext().getBizParams();
                bizParams.setTraceId(traceId);
                response.put("bizParams", bizParams);
                HashMap hashMap = response;
                return hashMap;
            }
            Object v = ((Map)reponseMap.get("response")).get("message");
            return v;
        }
        catch (Exception e) {
            log.error("\u8bbf\u95ee\u654f\u6377\u6570\u636e\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0:{}", (Object)e.getMessage());
            return "\u654f\u6570\u670d\u52a1\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> checkToken(String userToken) {
        HashMap<String, Object> response = new HashMap<String, Object>(4);
        if (StringUtils.isEmpty((Object)userToken)) {
            userToken = "";
        }
        HashMap bodys = new HashMap(0);
        RequestBody requestBody = RequestBody.create((String)JsonUtil.getJsonString(bodys), (MediaType)MediaType.parse((String)"application/json"));
        Request okHttpRequest = new Request.Builder().url(this.iamUrl + "/api/iam/v2/identity/token/analyze").method("POST", requestBody).header("digi-middleware-auth-app", this.appToken).header("digi-middleware-auth-user", userToken).build();
        try (Response okHttpResponse = this.okHttpClient.newCall(okHttpRequest).execute();){
            if (okHttpResponse.isSuccessful()) return response;
            Map map = this.returnTokenCheckJson(response, (String)Optional.ofNullable(JsonUtil.json2Map((String)okHttpResponse.body().string())).map(e -> e.get("errorMessage")).orElse(this.ERR_MESSAGE));
            return map;
        }
        catch (Exception e2) {
            return this.returnTokenCheckJson(response, this.ERR_MESSAGE);
        }
    }

    public Map<String, Object> returnTokenCheckJson(Map<String, Object> response, String returnMsg) {
        response.put("characterEncoding", "utf-8");
        response.put("contentType", "application/json; charset=utf-8");
        response.put("code", HttpStatus.UNAUTHORIZED.value());
        response.put("message", returnMsg);
        return response;
    }
}

