/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.function;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.function.DistanceFromPoint;
import org.neo4j.ogm.cypher.function.FilterFunction;

public class DistanceComparison
implements FilterFunction<DistanceFromPoint> {
    private DistanceFromPoint value;
    private Filter filter;

    public DistanceComparison(DistanceFromPoint value) {
        this.value = value;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public DistanceFromPoint getValue() {
        return this.value;
    }

    @Override
    public String expression(String nodeIdentifier) {
        return String.format("distance(point(%s),point({latitude:{lat}, longitude:{lon}})) %s {distance} ", nodeIdentifier, this.filter.getComparisonOperator().getValue());
    }

    @Override
    public Map<String, Object> parameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lat", this.value.getLatitude());
        map.put("lon", this.value.getLongitude());
        map.put("distance", this.value.getDistance());
        return map;
    }
}

