/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class AnnotationInfo {
    private String annotationName;
    private Annotation annotation;
    private Map<String, String> elements;

    private static String convert(Method element, Object value) {
        Class<?> returnType = element.getReturnType();
        if (returnType.isPrimitive()) {
            return String.valueOf(value);
        }
        if (returnType.equals(Class.class)) {
            return ((Class)value).getName();
        }
        String result = value.toString();
        if (result.isEmpty()) {
            if (element.getDefaultValue().toString().isEmpty()) {
                return null;
            }
            return element.getDefaultValue().toString();
        }
        return result;
    }

    public AnnotationInfo(Annotation annotation) {
        Method[] declaredElements;
        this.annotationName = annotation.annotationType().getName();
        this.annotation = annotation;
        this.elements = new HashMap<String, String>();
        for (Method element : declaredElements = annotation.annotationType().getDeclaredMethods()) {
            Object value;
            try {
                value = element.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Could not read value of Annotation " + element.getName(), e);
            }
            this.elements.put(element.getName(), value != null ? AnnotationInfo.convert(element, value) : element.getDefaultValue().toString());
        }
    }

    public String getName() {
        return this.annotationName;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public String get(String key, String defaultValue) {
        this.elements.putIfAbsent(key, defaultValue);
        return this.get(key);
    }

    public String get(String key) {
        return this.elements.get(key);
    }
}

