/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.InterfaceInfo;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.ConversionCallback;
import org.neo4j.ogm.typeconversion.ConversionCallbackRegistry;
import org.neo4j.ogm.typeconversion.ConvertibleTypes;
import org.neo4j.ogm.typeconversion.ProxyAttributeConverter;
import org.neo4j.ogm.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainInfo.class);
    private static final String DATE_SIGNATURE = "java.util.Date";
    private static final String BIG_DECIMAL_SIGNATURE = "java.math.BigDecimal";
    private static final String BIG_INTEGER_SIGNATURE = "java.math.BigInteger";
    private static final String BYTE_ARRAY_SIGNATURE = "byte[]";
    private static final String BYTE_ARRAY_WRAPPER_SIGNATURE = "java.lang.Byte[]";
    private static final String INSTANT_SIGNATURE = "java.time.Instant";
    private static final String LOCAL_DATE_SIGNATURE = "java.time.LocalDate";
    private static final String LOCAL_DATE_TIME_SIGNATURE = "java.time.LocalDateTime";
    private static final String OFFSET_DATE_TIME_SIGNATURE = "java.time.OffsetDateTime";
    private final Map<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
    private final Map<String, ArrayList<ClassInfo>> annotationNameToClassInfo = new HashMap<String, ArrayList<ClassInfo>>();
    private final Map<String, ArrayList<ClassInfo>> interfaceNameToClassInfo = new HashMap<String, ArrayList<ClassInfo>>();
    private final Set<Class> enumTypes = new HashSet<Class>();
    private final ConversionCallbackRegistry conversionCallbackRegistry = new ConversionCallbackRegistry();

    public static DomainInfo create(String ... packages) {
        ScanResult scanResult = new FastClasspathScanner(packages).strictWhitelist().scan();
        List allClasses = scanResult.getNamesOfAllClasses();
        DomainInfo domainInfo = new DomainInfo();
        for (String className : allClasses) {
            Class<?> cls = null;
            try {
                cls = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Could not load class {}", (Object)className);
                continue;
            }
            ClassInfo classInfo = new ClassInfo(cls);
            String superclassName = classInfo.superclassName();
            LOGGER.debug("Processing: {} -> {}", (Object)className, (Object)superclassName);
            if (className == null || cls.isAnnotation() || cls.isAnonymousClass() || cls.equals(Object.class)) continue;
            ClassInfo thisClassInfo = domainInfo.classNameToClassInfo.computeIfAbsent(className, k -> classInfo);
            if (!thisClassInfo.hydrated()) {
                thisClassInfo.hydrate(classInfo);
                ClassInfo superclassInfo = domainInfo.classNameToClassInfo.get(superclassName);
                if (superclassInfo == null) {
                    if (superclassName != null && !superclassName.equals("java.lang.Object") && !superclassName.equals("java.lang.Enum")) {
                        domainInfo.classNameToClassInfo.put(superclassName, new ClassInfo(superclassName, thisClassInfo));
                    }
                } else {
                    superclassInfo.addSubclass(thisClassInfo);
                }
            }
            if (!thisClassInfo.isEnum()) continue;
            LOGGER.debug("Registering enum class: {}", (Object)thisClassInfo.name());
            domainInfo.enumTypes.add(thisClassInfo.getUnderlyingClass());
        }
        domainInfo.finish();
        return domainInfo;
    }

    private void buildAnnotationNameToClassInfoMap() {
        LOGGER.info("Building annotation class map");
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            for (AnnotationInfo annotation : classInfo.annotations()) {
                ArrayList<ClassInfo> classInfoList = this.annotationNameToClassInfo.get(annotation.getName());
                if (classInfoList == null) {
                    classInfoList = new ArrayList();
                    this.annotationNameToClassInfo.put(annotation.getName(), classInfoList);
                }
                classInfoList.add(classInfo);
            }
        }
    }

    private void buildInterfaceNameToClassInfoMap() {
        LOGGER.info("Building interface class map for {} classes", (Object)this.classNameToClassInfo.values().size());
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            LOGGER.debug(" - {} implements {} interfaces", (Object)classInfo.simpleName(), (Object)classInfo.interfacesInfo().list().size());
            for (InterfaceInfo iface : classInfo.interfacesInfo().list()) {
                ArrayList<ClassInfo> classInfoList = this.interfaceNameToClassInfo.get(iface.name());
                if (classInfoList == null) {
                    classInfoList = new ArrayList();
                    this.interfaceNameToClassInfo.put(iface.name(), classInfoList);
                }
                LOGGER.debug("   - {}", (Object)iface.name());
                classInfoList.add(classInfo);
            }
        }
    }

    void registerConversionCallback(ConversionCallback conversionCallback) {
        this.conversionCallbackRegistry.registerConversionCallback(conversionCallback);
    }

    private void finish() {
        LOGGER.info("Starting Post-processing phase");
        this.buildAnnotationNameToClassInfoMap();
        this.buildInterfaceNameToClassInfoMap();
        ArrayList<ClassInfo> transientClasses = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            if (classInfo.name() == null || classInfo.name().equals("java.lang.Object")) continue;
            LOGGER.debug("Post-processing: {}", (Object)classInfo.name());
            if (classInfo.isTransient()) {
                LOGGER.debug(" - Registering @Transient baseclass: {}", (Object)classInfo.name());
                transientClasses.add(classInfo);
                continue;
            }
            if (classInfo.superclassName() == null || classInfo.superclassName().equals("java.lang.Object")) {
                this.extend(classInfo, classInfo.directSubclasses());
            }
            for (InterfaceInfo interfaceInfo : classInfo.interfacesInfo().list()) {
                this.implement(classInfo, interfaceInfo);
            }
        }
        LOGGER.debug("Checking for @Transient classes....");
        Collection<ArrayList<ClassInfo>> interfaceInfos = this.interfaceNameToClassInfo.values();
        for (ArrayList<ClassInfo> arrayList : interfaceInfos) {
            for (ClassInfo classInfo : arrayList) {
                if (!classInfo.isTransient()) continue;
                LOGGER.debug("Registering @Transient baseclass: {}", (Object)classInfo.name());
                transientClasses.add(classInfo);
            }
        }
        HashSet<Class> hashSet = new HashSet<Class>();
        for (ClassInfo classInfo : transientClasses) {
            hashSet.addAll(this.removeTransientClass(classInfo));
        }
        LOGGER.debug("Registering converters and deregistering transient fields and methods....");
        this.postProcessFields(hashSet);
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            classInfo.primaryIndexField();
            classInfo.getVersionField();
        }
        LOGGER.info("Post-processing complete");
    }

    private void postProcessFields(Set<Class> transientClassesRemoved) {
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            boolean registerConverters = false;
            if (!classInfo.isEnum() && !classInfo.isInterface()) {
                registerConverters = true;
            }
            Iterator<FieldInfo> fieldInfoIterator = classInfo.fieldsInfo().fields().iterator();
            while (fieldInfoIterator.hasNext()) {
                FieldInfo fieldInfo = fieldInfoIterator.next();
                if (!fieldInfo.persistableAsProperty()) {
                    Class<?> fieldClass = null;
                    try {
                        fieldClass = ClassUtils.getType(fieldInfo.getTypeDescriptor());
                    }
                    catch (Exception e) {
                        LOGGER.debug("Unable to compute class type for " + classInfo.name() + ", field: " + fieldInfo.getName());
                    }
                    if (fieldClass != null && transientClassesRemoved.contains(fieldClass)) {
                        fieldInfoIterator.remove();
                        continue;
                    }
                }
                if (!registerConverters) continue;
                this.registerDefaultFieldConverters(classInfo, fieldInfo);
            }
        }
    }

    private Set<Class> removeTransientClass(ClassInfo transientClass) {
        HashSet<Class> removed = new HashSet<Class>();
        if (transientClass != null && !transientClass.name().equals("java.lang.Object")) {
            LOGGER.debug("Removing @Transient class: {}", (Object)transientClass.name());
            this.classNameToClassInfo.remove(transientClass.name());
            removed.add(transientClass.getUnderlyingClass());
            for (ClassInfo transientChild : transientClass.directSubclasses()) {
                this.removeTransientClass(transientChild);
            }
            for (ClassInfo transientChild : transientClass.directImplementingClasses()) {
                this.removeTransientClass(transientChild);
            }
        }
        return removed;
    }

    private void extend(ClassInfo superclass, List<ClassInfo> subclasses) {
        for (ClassInfo subclass : subclasses) {
            subclass.extend(superclass);
            this.extend(subclass, subclass.directSubclasses());
        }
    }

    private void implement(ClassInfo implementingClass, InterfaceInfo interfaceInfo) {
        ClassInfo interfaceClass = this.classNameToClassInfo.get(interfaceInfo.name());
        if (interfaceClass != null) {
            if (!implementingClass.directInterfaces().contains(interfaceClass)) {
                LOGGER.debug(" - Setting {} implements {}", (Object)implementingClass.simpleName(), (Object)interfaceClass.simpleName());
                implementingClass.directInterfaces().add(interfaceClass);
            }
            if (!interfaceClass.directImplementingClasses().contains(implementingClass)) {
                interfaceClass.directImplementingClasses().add(implementingClass);
            }
            for (ClassInfo subClassInfo : implementingClass.directSubclasses()) {
                this.implement(subClassInfo, interfaceInfo);
            }
        } else {
            LOGGER.debug(" - No ClassInfo found for interface class: {}", (Object)interfaceInfo.name());
        }
    }

    public ClassInfo getClass(String fqn) {
        return this.classNameToClassInfo.get(fqn);
    }

    ClassInfo getClassSimpleName(String fullOrPartialClassName) {
        return this.getClassInfo(fullOrPartialClassName, this.classNameToClassInfo);
    }

    ClassInfo getClassInfoForInterface(String fullOrPartialClassName) {
        ClassInfo classInfo = this.getClassSimpleName(fullOrPartialClassName);
        if (classInfo != null && classInfo.isInterface()) {
            return classInfo;
        }
        return null;
    }

    private ClassInfo getClassInfo(String fullOrPartialClassName, Map<String, ClassInfo> infos) {
        ClassInfo match = null;
        for (String fqn : infos.keySet()) {
            if (!fqn.endsWith("." + fullOrPartialClassName) && !fqn.equals(fullOrPartialClassName)) continue;
            if (match == null) {
                match = infos.get(fqn);
                continue;
            }
            throw new MappingException("More than one class has simple name: " + fullOrPartialClassName);
        }
        return match;
    }

    List<ClassInfo> getClassInfosWithAnnotation(String annotation) {
        return this.annotationNameToClassInfo.get(annotation);
    }

    private void registerDefaultFieldConverters(ClassInfo classInfo, FieldInfo fieldInfo) {
        if (!fieldInfo.hasPropertyConverter() && !fieldInfo.hasCompositeConverter()) {
            String typeDescriptor = fieldInfo.getTypeDescriptor();
            if (typeDescriptor.contains(DATE_SIGNATURE)) {
                this.setDateFieldConverter(fieldInfo);
            } else if (typeDescriptor.contains(BIG_INTEGER_SIGNATURE)) {
                this.setBigIntegerFieldConverter(fieldInfo);
            } else if (typeDescriptor.contains(BIG_DECIMAL_SIGNATURE)) {
                this.setBigDecimalConverter(fieldInfo);
            } else if (typeDescriptor.contains(INSTANT_SIGNATURE)) {
                this.setInstantConverter(fieldInfo);
            } else if (typeDescriptor.contains(OFFSET_DATE_TIME_SIGNATURE)) {
                this.setOffsetDateTimeConverter(fieldInfo);
            } else if (typeDescriptor.contains(LOCAL_DATE_TIME_SIGNATURE)) {
                this.setLocalDateTimeConverter(fieldInfo);
            } else if (typeDescriptor.contains(LOCAL_DATE_SIGNATURE)) {
                this.setLocalDateConverter(fieldInfo);
            } else if (typeDescriptor.contains(BYTE_ARRAY_SIGNATURE)) {
                fieldInfo.setPropertyConverter(ConvertibleTypes.getByteArrayBase64Converter());
            } else if (typeDescriptor.contains(BYTE_ARRAY_WRAPPER_SIGNATURE)) {
                fieldInfo.setPropertyConverter(ConvertibleTypes.getByteArrayWrapperBase64Converter());
            } else {
                Class<?> fieldType;
                if (fieldInfo.getAnnotations().get(Convert.class) != null) {
                    Class<?> entityAttributeType = ClassUtils.getType(typeDescriptor);
                    String graphTypeDescriptor = fieldInfo.getAnnotations().get(Convert.class).get("graphPropertyType", null);
                    if (graphTypeDescriptor == null) {
                        throw new MappingException("Found annotation to convert a " + (entityAttributeType != null ? entityAttributeType.getName() : " null object ") + " on " + classInfo.name() + '.' + fieldInfo.getName() + " but no target graph property type or specific AttributeConverter have been specified.");
                    }
                    fieldInfo.setPropertyConverter(new ProxyAttributeConverter(entityAttributeType, ClassUtils.getType(graphTypeDescriptor), this.conversionCallbackRegistry));
                }
                if ((fieldType = ClassUtils.getType(typeDescriptor)) == null) {
                    throw new RuntimeException("Class " + classInfo.name() + " field " + fieldInfo.getName() + " has null field type.");
                }
                boolean enumConverterSet = false;
                for (Class enumClass : this.enumTypes) {
                    if (!fieldType.equals(enumClass)) continue;
                    this.setEnumFieldConverter(fieldInfo, enumClass);
                    enumConverterSet = true;
                    break;
                }
                if (!enumConverterSet && fieldType.isEnum()) {
                    LOGGER.debug("Setting default enum converter for unscanned class " + classInfo.name() + ", field: " + fieldInfo.getName());
                    this.setEnumFieldConverter(fieldInfo, fieldType);
                }
            }
        }
    }

    private void setEnumFieldConverter(FieldInfo fieldInfo, Class enumClass) {
        if (fieldInfo.isArray()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getEnumArrayConverter(enumClass));
        } else if (fieldInfo.isIterable()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getEnumCollectionConverter(enumClass, fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getEnumConverter(enumClass));
        }
    }

    private void setBigDecimalConverter(FieldInfo fieldInfo) {
        if (fieldInfo.isArray()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getBigDecimalArrayConverter());
        } else if (fieldInfo.isIterable()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getBigDecimalCollectionConverter(fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getBigDecimalConverter());
        }
    }

    private void setBigIntegerFieldConverter(FieldInfo fieldInfo) {
        if (fieldInfo.isArray()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getBigIntegerArrayConverter());
        } else if (fieldInfo.isIterable()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getBigIntegerCollectionConverter(fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getBigIntegerConverter());
        }
    }

    private void setDateFieldConverter(FieldInfo fieldInfo) {
        if (fieldInfo.isArray()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getDateArrayConverter());
        } else if (fieldInfo.isIterable()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getDateCollectionConverter(fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getDateConverter());
        }
    }

    private void setInstantConverter(FieldInfo fieldInfo) {
        fieldInfo.setPropertyConverter(ConvertibleTypes.getInstantConverter());
    }

    private void setLocalDateConverter(FieldInfo fieldInfo) {
        AttributeConverter<?, ?> localDateConverter = ConvertibleTypes.getLocalDateConverter();
        if (fieldInfo.isIterable()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getConverterBasedCollectionConverter(localDateConverter, fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setPropertyConverter(localDateConverter);
        }
    }

    private void setLocalDateTimeConverter(FieldInfo fieldInfo) {
        AttributeConverter<?, ?> localDateTimeConverter = ConvertibleTypes.getLocalDateTimeConverter();
        if (fieldInfo.isIterable()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getConverterBasedCollectionConverter(localDateTimeConverter, fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setPropertyConverter(localDateTimeConverter);
        }
    }

    private void setOffsetDateTimeConverter(FieldInfo fieldInfo) {
        AttributeConverter<?, ?> offsetDateTimeConverter = ConvertibleTypes.getOffsetDateTimeConverter();
        if (fieldInfo.isIterable()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getConverterBasedCollectionConverter(offsetDateTimeConverter, fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setPropertyConverter(offsetDateTimeConverter);
        }
    }

    public Map<String, ClassInfo> getClassInfoMap() {
        return this.classNameToClassInfo;
    }

    public List<ClassInfo> getClassInfos(String interfaceName) {
        return this.interfaceNameToClassInfo.get(interfaceName);
    }
}

