/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.utils;

import java.util.HashMap;
import java.util.Map;

public abstract class ClassUtils {
    private static final String primitives = "char,byte,short,int,long,float,double,boolean";
    private static Map<String, Class<?>> descriptorTypeMappings = new HashMap();

    public static Class<?> getType(String descriptor) {
        Class<?> type;
        Class<?> clazz = descriptorTypeMappings.get(descriptor);
        if (clazz != null) {
            return descriptorTypeMappings.get(descriptor);
        }
        try {
            type = ClassUtils.computeType(descriptor);
        }
        catch (Throwable t) {
            return null;
        }
        descriptorTypeMappings.put(descriptor, type);
        return type;
    }

    private static Class<?> computeType(String descriptor) throws ClassNotFoundException {
        if (descriptor == null) {
            return null;
        }
        if (descriptor.endsWith("[]")) {
            descriptor = descriptor.substring(0, descriptor.length() - 2);
        }
        if (descriptor.equals(String.class.getName())) {
            return String.class;
        }
        if (descriptor.equals(Character.class.getName())) {
            return Character.class;
        }
        if (descriptor.equals(Byte.class.getName())) {
            return Byte.class;
        }
        if (descriptor.equals(Short.class.getName())) {
            return Short.class;
        }
        if (descriptor.equals(Integer.class.getName())) {
            return Integer.class;
        }
        if (descriptor.equals(Long.class.getName())) {
            return Long.class;
        }
        if (descriptor.equals(Float.class.getName())) {
            return Float.class;
        }
        if (descriptor.equals(Double.class.getName())) {
            return Double.class;
        }
        if (descriptor.equals(Boolean.class.getName())) {
            return Boolean.class;
        }
        if (descriptor.equals("char")) {
            return Character.TYPE;
        }
        if (descriptor.equals("byte")) {
            return Byte.TYPE;
        }
        if (descriptor.equals("short")) {
            return Short.TYPE;
        }
        if (descriptor.equals("int")) {
            return Integer.TYPE;
        }
        if (descriptor.equals("long")) {
            return Long.TYPE;
        }
        if (descriptor.equals("float")) {
            return Float.TYPE;
        }
        if (descriptor.equals("double")) {
            return Double.TYPE;
        }
        if (descriptor.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (!descriptor.contains(".") && !descriptor.contains("$")) {
            return Object.class;
        }
        return Class.forName(descriptor, false, Thread.currentThread().getContextClassLoader());
    }
}

