/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.schema;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DomainInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.reflect.GenericUtils;
import org.neo4j.ogm.metadata.schema.NodeImpl;
import org.neo4j.ogm.metadata.schema.RelationshipImpl;
import org.neo4j.ogm.metadata.schema.Schema;
import org.neo4j.ogm.metadata.schema.SchemaImpl;
import org.neo4j.ogm.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainInfoSchemaBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DomainInfoSchemaBuilder.class);
    private DomainInfo domainInfo;
    private Map<String, ClassInfo> classInfoMap;
    private SchemaImpl schema;

    public DomainInfoSchemaBuilder(DomainInfo domainInfo) {
        this.domainInfo = domainInfo;
        this.classInfoMap = domainInfo.getClassInfoMap();
        this.schema = new SchemaImpl();
    }

    public Schema build() {
        this.buildNodes();
        this.buildRelationships();
        return this.schema;
    }

    private void buildNodes() {
        for (ClassInfo classInfo : this.classInfoMap.values()) {
            if (classInfo.isRelationshipEntity()) continue;
            String label = classInfo.neo4jName();
            NodeImpl node = new NodeImpl(classInfo.neo4jName(), classInfo.staticLabels());
            this.schema.addNode(label, node);
        }
    }

    private void buildRelationships() {
        for (ClassInfo classInfo : this.classInfoMap.values()) {
            if (!classInfo.isRelationshipEntity()) {
                String label = classInfo.neo4jName();
                NodeImpl node = (NodeImpl)this.schema.findNode(label);
                Collection<FieldInfo> relationships = classInfo.relationshipFields();
                for (FieldInfo fieldInfo : relationships) {
                    this.createRelationship(node, fieldInfo);
                }
                continue;
            }
            String type = classInfo.neo4jName();
            if (this.schema.getRelationship(type) != null) continue;
            if (classInfo.getStartNodeReader() == null || classInfo.getEndNodeReader() == null) {
                logger.warn("Start or end node not found for classInfo={}, is the metadata correct?", (Object)classInfo);
                continue;
            }
            NodeImpl start = this.getNodeByFieldAndContainingClass(classInfo, classInfo.getStartNodeReader());
            NodeImpl end = this.getNodeByFieldAndContainingClass(classInfo, classInfo.getEndNodeReader());
            this.schema.addRelationship(new RelationshipImpl(type, "OUTGOING", start, end));
        }
    }

    private void createRelationship(NodeImpl fromNode, FieldInfo relFieldInfo) {
        Class<?> otherClass = ClassUtils.getType(relFieldInfo.getTypeDescriptor());
        String otherType = otherClass.getName();
        ClassInfo otherClassInfo = this.classInfoMap.get(otherType);
        if (otherClassInfo == null) {
            logger.debug("Type " + otherType + " not found. Did you specify 'packages' parameter to SessionFactory correctly?");
            return;
        }
        NodeImpl toNode = otherClassInfo.isRelationshipEntity() ? (relFieldInfo.relationshipDirection().equals("OUTGOING") ? this.getNodeByFieldAndContainingClass(otherClassInfo, otherClassInfo.getEndNodeReader()) : this.getNodeByFieldAndContainingClass(otherClassInfo, otherClassInfo.getStartNodeReader())) : (NodeImpl)this.schema.findNode(otherClassInfo.neo4jName());
        RelationshipImpl relationship = new RelationshipImpl(relFieldInfo.relationshipType(), relFieldInfo.relationshipDirection(), fromNode, toNode);
        fromNode.addRelationship(relFieldInfo.getName(), relationship);
    }

    private NodeImpl getNodeByFieldAndContainingClass(ClassInfo classInfo, FieldInfo fieldInfo) {
        Field endField = fieldInfo.getField();
        Class endType = GenericUtils.findFieldType(endField, classInfo.getUnderlyingClass());
        NodeImpl toNode = this.getNodeByTypeDescriptor(endType.getName());
        return toNode;
    }

    private NodeImpl getNodeByTypeDescriptor(String typeDescriptor) {
        ClassInfo classInfo = this.classInfoMap.get(typeDescriptor);
        return (NodeImpl)this.schema.findNode(classInfo.neo4jName());
    }
}

