/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import org.neo4j.ogm.exception.core.MetadataException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.utils.EntityUtils;

public class GraphIdDelegate {
    private final Neo4jSession session;

    public GraphIdDelegate(Neo4jSession session) {
        this.session = session;
    }

    public Long resolveGraphIdFor(Object possibleEntity) {
        if (possibleEntity != null) {
            ClassInfo classInfo = this.session.metaData().classInfo(possibleEntity);
            try {
                Long id;
                if (classInfo != null && (id = EntityUtils.identity(possibleEntity, this.session.metaData())) >= 0L) {
                    return (long)id;
                }
            }
            catch (MetadataException me) {
                return null;
            }
        }
        return null;
    }

    public boolean detachNodeEntity(Long id) {
        return this.session.context().detachNodeEntity(id);
    }

    public boolean detachRelationshipEntity(Long id) {
        return this.session.context().detachRelationshipEntity(id);
    }
}

