/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.util.Collection;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.context.GraphRowListModelMapper;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.DefaultGraphModelRequest;
import org.neo4j.ogm.cypher.query.DefaultGraphRowListModelRequest;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowListModel;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.request.GraphRowListModelRequest;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadByTypeDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(LoadByTypeDelegate.class);
    private final Neo4jSession session;

    public LoadByTypeDelegate(Neo4jSession session) {
        this.session = session;
    }

    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, Pagination pagination, int depth) {
        PagingAndSortingQuery query;
        String entityLabel = this.session.entityType(type.getName());
        if (entityLabel == null) {
            LOG.warn("Unable to find database label for entity " + type.getName() + " : no results will be returned. Make sure the class is registered, and not abstract without @NodeEntity annotation");
        }
        QueryStatements queryStatements = this.session.queryStatementsFor(type, depth);
        this.session.resolvePropertyAnnotations(type, sortOrder);
        if (filters.isEmpty()) {
            query = queryStatements.findByType(entityLabel, depth);
        } else {
            this.session.resolvePropertyAnnotations(type, filters);
            query = queryStatements.findByType(entityLabel, filters, depth);
        }
        query.setSortOrder(sortOrder).setPagination(pagination);
        return this.session.doInTransaction(() -> {
            if (query.needsRowResult()) {
                DefaultGraphRowListModelRequest graphRowListModelRequest = new DefaultGraphRowListModelRequest(query.getStatement(), query.getParameters());
                try (Response response = this.session.requestHandler().execute((GraphRowListModelRequest)graphRowListModelRequest);){
                    Collection collection = (Collection)new GraphRowListModelMapper(this.session.metaData(), this.session.context(), this.session.getEntityInstantiator()).map(type, (Response<GraphRowListModel>)response);
                    return collection;
                }
            }
            DefaultGraphModelRequest request = new DefaultGraphModelRequest(query.getStatement(), query.getParameters());
            try (Response response = this.session.requestHandler().execute((GraphModelRequest)request);){
                Collection collection = (Collection)new GraphEntityMapper(this.session.metaData(), this.session.context(), this.session.getEntityInstantiator()).map(type, (Response<GraphModel>)response);
                return collection;
            }
        }, Transaction.Type.READ_WRITE);
    }

    public <T> Collection<T> loadAll(Class<T> type) {
        return this.loadAll(type, new Filters(), new SortOrder(), null, 1);
    }

    public <T> Collection<T> loadAll(Class<T> type, int depth) {
        return this.loadAll(type, new Filters(), new SortOrder(), null, depth);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filter filter) {
        return this.loadAll(type, new Filters().add(filter), new SortOrder(), null, 1);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filter filter, int depth) {
        return this.loadAll(type, new Filters().add(filter), new SortOrder(), null, depth);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder) {
        return this.loadAll(type, new Filters().add(filter), sortOrder, null, 1);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, int depth) {
        return this.loadAll(type, new Filters().add(filter), sortOrder, null, depth);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filter filter, Pagination pagination) {
        return this.loadAll(type, new Filters().add(filter), new SortOrder(), pagination, 1);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filter filter, Pagination pagination, int depth) {
        return this.loadAll(type, new Filters().add(filter), new SortOrder(), pagination, depth);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(type, new Filters().add(filter), sortOrder, pagination, 1);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadAll(type, new Filters().add(filter), sortOrder, pagination, depth);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filters filters) {
        return this.loadAll(type, filters, new SortOrder(), null, 1);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filters filters, int depth) {
        return this.loadAll(type, filters, new SortOrder(), null, depth);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder) {
        return this.loadAll(type, filters, sortOrder, null, 1);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, int depth) {
        return this.loadAll(type, filters, sortOrder, null, depth);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filters filters, Pagination pagination) {
        return this.loadAll(type, filters, new SortOrder(), pagination, 1);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filters filters, Pagination pagination, int depth) {
        return this.loadAll(type, filters, new SortOrder(), pagination, depth);
    }

    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(type, filters, sortOrder, pagination, 1);
    }

    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder) {
        return this.loadAll(type, new Filters(), sortOrder, null, 1);
    }

    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, int depth) {
        return this.loadAll(type, new Filters(), sortOrder, null, depth);
    }

    public <T> Collection<T> loadAll(Class<T> type, Pagination paging) {
        return this.loadAll(type, new Filters(), new SortOrder(), paging, 1);
    }

    public <T> Collection<T> loadAll(Class<T> type, Pagination paging, int depth) {
        return this.loadAll(type, new Filters(), new SortOrder(), paging, depth);
    }

    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(type, new Filters(), sortOrder, pagination, 1);
    }

    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadAll(type, new Filters(), sortOrder, pagination, depth);
    }
}

