package com.digiwin.athena.adt;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.loadbalance.scan.DWPathScan;
import com.jugg.agile.framework.core.dapper.alarm.JaNotify;
import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@Slf4j
@EnableAsync
@DWPathScan
@EnableScheduling
@MapperScan(basePackages = {"com.digiwin.athena.adt"}, markerInterface = BaseMapper.class)
@SpringBootApplication
public class AdtApplication extends SpringBootServletInitializer {

    public static void main(String[] args) throws Throwable {
        JaNotify.notifyRun(() -> SpringApplication.run(AdtApplication.class, args));
    }

    @Override
    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.sources(AdtApplication.class);
    }
}
