package com.digiwin.athena.adt.agileReport.config;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.dao.AgileDataConfigMapper;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.domain.po.AgileDataConfig;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * @version 1.0
 * @Author: Sun Hong
 * @Date: 2024/6/3 15:22
 * @Description :
 */
@Component
public class AgileDataHandlerProcessor {

    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private AgileDataConfigMapper agileDataConfigMapper;

    private static final String DESIGNER = "designer";
    private static final String TARGET = "target";
    private static final String TENANT_ID = "tenant_id";

    protected static final Map<AgileDataEnum,Class<AgileDataProcessService>> SERVICE_HAND_MAP = new HashMap<>(2);

    public AgileDataProcessService getEnumServiceByType(Enum type){
        Class<AgileDataProcessService> strategyClass = SERVICE_HAND_MAP.get(type);
        if(strategyClass==null) {
            throw new IllegalArgumentException("没有找到对应的实现");
        }
        //从容器中获取对应的策略Bean
        return applicationContext.getBean(strategyClass);
    }

    public String getAgileDataByUserConfig(AuthoredUser user) {
        QueryWrapper<AgileDataConfig> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(TENANT_ID, user.getTenantId());
        AgileDataConfig agileDataConfig = agileDataConfigMapper.selectOne(queryWrapper);
        String serviceName = DESIGNER;
        if(agileDataConfig != null && StringUtils.isNotEmpty(agileDataConfig.getType())
                && (TARGET.equals(agileDataConfig.getType()) || DESIGNER.equals(agileDataConfig.getType()))){
            serviceName = agileDataConfig.getType();
        }
        return serviceName;
    }
}
